/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.particle;

import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.SharedNode;
import org.j3d.renderer.aviatrix3d.geom.particle.AVParticleSystem;
import org.j3d.renderer.aviatrix3d.geom.particle.PointParticleSystem;
import org.j3d.renderer.aviatrix3d.geom.particle.QuadParticleSystem;
import org.j3d.renderer.aviatrix3d.geom.particle.TriangleFanParticleSystem;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.particle.BaseParticleSystem;
import org.web3d.vrml.renderer.ogl.nodes.OGLAppearanceNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;

public class OGLParticleSystem
extends BaseParticleSystem
implements OGLVRMLNode,
NodeUpdateListener {
    private Shape3D implShape;
    private SharedNode implNode;

    public OGLParticleSystem() {
    }

    public OGLParticleSystem(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public void updateNodeBoundsChanges(Object object) {
    }

    public void updateNodeDataChanges(Object object) {
        Appearance appearance = null;
        if (this.vfAppearance != null) {
            OGLAppearanceNodeType oGLAppearanceNodeType = (OGLAppearanceNodeType)this.vfAppearance;
            appearance = oGLAppearanceNodeType.getAppearance();
        }
        this.implShape.setAppearance(appearance);
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implNode;
    }

    public void setupFinished() {
        Object object;
        Object object2;
        if (!this.inSetup) {
            return;
        }
        int n = 3;
        if (this.vfColorRamp != null) {
            n = this.vfColorRamp.getNumColorComponents();
        }
        switch (this.geometryType) {
            case 1: {
                this.particleSystem = new QuadParticleSystem(null, this.vfMaxParticles, n);
                ((QuadParticleSystem)this.particleSystem).setParticleSize(this.vfParticleSize[0], this.vfParticleSize[1]);
                break;
            }
            case 2: {
                this.particleSystem = new TriangleFanParticleSystem(null, this.vfMaxParticles, n);
                ((TriangleFanParticleSystem)this.particleSystem).setParticleSize(this.vfParticleSize[0], this.vfParticleSize[1]);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.particleSystem = new PointParticleSystem(null, this.vfMaxParticles, n);
                break;
            }
            case 5: {
                System.out.println("OpenGL does not support point sprite particles yet");
                break;
            }
            case 6: {
                System.out.println("OpenGL does not support custom geometry particles yet");
                break;
            }
            default: {
                System.out.println("unknown particle system index " + this.geometryType);
            }
        }
        this.implShape = new Shape3D();
        this.implShape.setGeometry(((AVParticleSystem)this.particleSystem).getNode());
        this.implNode = new SharedNode();
        this.implNode.setChild((Node)this.implShape);
        super.setupFinished();
        if (this.vfAppearance != null) {
            object2 = (OGLAppearanceNodeType)this.vfAppearance;
            object2.setSolid(false);
            object2.setLightingEnabled(true);
            object2.setCCW(true);
            object = object2.getAppearance();
            this.implShape.setAppearance(object);
        }
        if (this.vfBboxSize[0] != -1.0f && this.vfBboxSize[1] != -1.0f && this.vfBboxSize[2] != -1.0f) {
            object2 = new float[3];
            object2[0] = this.vfBboxCenter[0] - this.vfBboxSize[0] / 2.0f;
            object2[1] = this.vfBboxCenter[1] - this.vfBboxSize[1] / 2.0f;
            object2[2] = this.vfBboxCenter[2] - this.vfBboxSize[2] / 2.0f;
            object = new float[3];
            object[0] = (Appearance)(this.vfBboxCenter[0] + this.vfBboxSize[0] / 2.0f);
            object[1] = (Appearance)(this.vfBboxCenter[1] + this.vfBboxSize[1] / 2.0f);
            object[2] = (Appearance)(this.vfBboxCenter[2] + this.vfBboxSize[2] / 2.0f);
            BoundingBox boundingBox = new BoundingBox((float[])object2, (float[])object);
            this.implShape.setBounds((BoundingVolume)boundingBox);
        }
    }

    public void setAppearance(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (!(vRMLNodeType instanceof OGLAppearanceNodeType) && !(vRMLNodeType instanceof VRMLProtoInstance)) {
            throw new InvalidFieldValueException("Node does not describe a Appearance object");
        }
        super.setAppearance(vRMLNodeType);
        if (this.implShape != null) {
            if (this.implShape.isLive()) {
                this.implShape.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.implShape);
            }
        }
    }

    protected void setParticleSize(float[] fArray) throws InvalidFieldValueException {
        super.setParticleSize(fArray);
        if (this.inSetup) {
            return;
        }
        switch (this.geometryType) {
            case 1: {
                ((QuadParticleSystem)this.particleSystem).setParticleSize(fArray[0], fArray[1]);
                break;
            }
            case 2: {
                ((TriangleFanParticleSystem)this.particleSystem).setParticleSize(fArray[0], fArray[1]);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
        }
    }
}

