/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.render;

import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.LineStripArray;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.render.BaseIndexedLineSet;
import org.web3d.vrml.renderer.ogl.nodes.OGLGeometryNodeType;

public class OGLIndexedLineSet
extends BaseIndexedLineSet
implements OGLGeometryNodeType,
NodeUpdateListener {
    private LineStripArray implGeom;
    private float[] tmpCoords;
    private float[] tmpColors;
    private int[] stripCounts;
    private int numStripCounts;
    private float[] lfCoords;
    private int numCoords;
    private float[] lfColors;
    private int numColors;
    private float[] unlitColor;
    private boolean hasAlpha;

    public OGLIndexedLineSet() {
        this.init();
    }

    public OGLIndexedLineSet(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public Geometry getGeometry() {
        return this.implGeom;
    }

    public int getNumSets() {
        return 0;
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            return;
        }
        switch (n) {
            case 2: {
                if (vRMLNodeType.getPrimaryType() != 9) {
                    throw new InvalidFieldValueException("Proto does not describe a GeometryComponent object");
                }
                if (this.implGeom.isLive()) {
                    this.implGeom.dataChanged((NodeUpdateListener)this);
                    break;
                }
                this.updateNodeDataChanges(this.implGeom);
                break;
            }
            case 1: {
                if (vRMLNodeType.getPrimaryType() != 11) {
                    throw new InvalidFieldValueException("Proto does not describe a GeometryComponent object");
                }
                if (this.implGeom.isLive()) {
                    this.implGeom.boundsChanged((NodeUpdateListener)this);
                    break;
                }
                this.updateNodeBoundsChanges(this.implGeom);
                break;
            }
            default: {
                System.out.println("OGLIndexedLineSet: Unknown field for notifyExternProtoLoaded");
            }
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        int n = this.vfCoord == null ? 0 : this.vfCoord.getNumPoints();
        int n2 = this.vfColor == null ? 0 : this.vfColor.getNumColors();
        this.tmpCoords = new float[n];
        this.tmpColors = new float[n2];
        this.buildImpl();
    }

    public void fieldChanged(VRMLNodeType vRMLNodeType, int n) {
        if (!this.inSetup) {
            if (vRMLNodeType == this.vfCoord) {
                this.changeFlags |= 1;
            } else if (vRMLNodeType == this.vfColor) {
                this.changeFlags |= 8;
            } else if (vRMLNodeType == this.vfNormal) {
                this.changeFlags |= 2;
            } else if (vRMLNodeType == this.vfTexCoord) {
                this.changeFlags |= 4;
            } else {
                System.out.println("BaseIndexedFaceSet: Unknown field fieldChanged");
            }
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    public boolean requiresUnlitColor() {
        return true;
    }

    public void setUnlitColor(float[] fArray) {
        this.changeFlags |= 0x40;
        if (this.unlitColor == null) {
            this.unlitColor = new float[3];
        }
        this.unlitColor[0] = fArray[0];
        this.unlitColor[1] = fArray[1];
        this.unlitColor[2] = fArray[2];
        if (this.implGeom.isLive()) {
            this.implGeom.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implGeom);
        }
    }

    protected void setCoordinateNode(VRMLCoordinateNodeType vRMLCoordinateNodeType) {
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    protected void setColorNode(VRMLColorNodeType vRMLColorNodeType) {
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    public void allEventsComplete() {
        this.buildImpl();
    }

    public void updateNodeBoundsChanges(Object object) {
        if (this.vfCoord == null) {
            this.implGeom.setValidVertexCount(0);
        } else {
            this.implGeom.setVertices(3, this.lfCoords, this.numCoords / 3);
            this.implGeom.setStripCount(this.stripCounts, this.numStripCounts);
        }
    }

    public void updateNodeDataChanges(Object object) {
        if (this.vfColor == null) {
            this.implGeom.setSingleColor(false, this.unlitColor);
        } else {
            this.implGeom.setColors(this.hasAlpha, this.lfColors);
        }
    }

    protected void setCoordIndex(int[] nArray, int n) {
        super.setCoordIndex(nArray, n);
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    protected void setColorIndex(int[] nArray, int n) {
        super.setColorIndex(nArray, n);
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    private void init() {
        this.implGeom = new LineStripArray();
        this.hasAlpha = false;
    }

    private void buildImpl() {
        int n;
        int n2;
        int n3;
        int n4;
        if ((this.changeFlags & 0x100) != 0 || (this.changeFlags & 1) != 0) {
            if ((this.changeFlags & 1) != 0) {
                this.tmpCoords = this.vfCoord.getPointRef();
            }
            n4 = 0;
            for (n3 = 0; n3 < this.numCoordIndex; ++n3) {
                if (this.vfCoordIndex[n3] != -1) continue;
                ++n4;
            }
            n3 = this.numCoordIndex - n4;
            if (this.numCoordIndex != 0 && this.vfCoordIndex[this.numCoordIndex - 1] != -1) {
                ++n4;
            }
            if (this.stripCounts == null || this.stripCounts.length < n4) {
                this.stripCounts = new int[this.numCoordIndex];
            } else {
                for (n2 = 0; n2 < this.stripCounts.length; ++n2) {
                    this.stripCounts[n2] = 0;
                }
            }
            if (this.lfCoords == null || this.lfCoords.length < n3 * 3) {
                this.lfCoords = new float[n3 * 3];
            }
            n2 = 0;
            n = 0;
            for (int i = 0; i < this.numCoordIndex; ++i) {
                if (this.vfCoordIndex[i] == -1) {
                    if (this.stripCounts[n2] != 0) {
                        ++n2;
                        continue;
                    }
                    --n4;
                    continue;
                }
                int n5 = n2;
                this.stripCounts[n5] = this.stripCounts[n5] + 1;
                int n6 = this.vfCoordIndex[i] * 3;
                this.lfCoords[n++] = this.tmpCoords[n6++];
                this.lfCoords[n++] = this.tmpCoords[n6++];
                this.lfCoords[n++] = this.tmpCoords[n6];
            }
            this.numCoords = n;
            this.numStripCounts = n4;
            if (this.implGeom.isLive()) {
                this.implGeom.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implGeom);
            }
        }
        if ((this.changeFlags & 0x800) != 0 || (this.changeFlags & 8) != 0) {
            if ((this.changeFlags & 8) != 0) {
                this.numColors = this.vfColor.getNumColors();
                if (this.tmpColors.length < this.numColors) {
                    this.tmpColors = new float[this.numColors];
                }
                this.vfColor.getColor(this.tmpColors);
            }
            this.hasAlpha = this.vfColor.getNumColorComponents() == 4;
            n4 = this.numCoordIndex - this.numStripCounts + 1;
            if (this.lfColors == null || this.lfColors.length < (n4 *= this.hasAlpha ? 4 : 3)) {
                this.lfColors = new float[n4];
            }
            n3 = 0;
            if (this.vfColorPerVertex) {
                if (this.numColorIndex == 0) {
                    if (!this.hasAlpha) {
                        for (n2 = 0; n2 < this.numCoordIndex; ++n2) {
                            if (this.vfCoordIndex[n2] == -1) continue;
                            n = this.vfCoordIndex[n2] * 3;
                            this.lfColors[n3++] = this.tmpColors[n++];
                            this.lfColors[n3++] = this.tmpColors[n++];
                            this.lfColors[n3++] = this.tmpColors[n];
                        }
                    } else {
                        for (n2 = 0; n2 < this.numCoordIndex; ++n2) {
                            if (this.vfCoordIndex[n2] == -1) continue;
                            n = this.vfCoordIndex[n2] * 4;
                            this.lfColors[n3++] = this.tmpColors[n++];
                            this.lfColors[n3++] = this.tmpColors[n++];
                            this.lfColors[n3++] = this.tmpColors[n++];
                            this.lfColors[n3++] = this.tmpColors[n];
                        }
                    }
                } else if (!this.hasAlpha) {
                    for (n2 = 0; n2 < this.numColorIndex; ++n2) {
                        if (this.vfColorIndex[n2] == -1) continue;
                        n = this.vfColorIndex[n2] * 3;
                        this.lfColors[n3++] = this.tmpColors[n++];
                        this.lfColors[n3++] = this.tmpColors[n++];
                        this.lfColors[n3++] = this.tmpColors[n];
                    }
                } else {
                    for (n2 = 0; n2 < this.numColorIndex; ++n2) {
                        if (this.vfColorIndex[n2] == -1) continue;
                        n = this.vfColorIndex[n2] * 4;
                        this.lfColors[n3++] = this.tmpColors[n++];
                        this.lfColors[n3++] = this.tmpColors[n++];
                        this.lfColors[n3++] = this.tmpColors[n++];
                        this.lfColors[n3++] = this.tmpColors[n];
                    }
                }
            } else if (this.numColorIndex == 0) {
                if (!this.hasAlpha) {
                    n2 = 0;
                    for (n = 0; n < this.numCoordIndex; ++n) {
                        if (this.vfCoordIndex[n] == -1) {
                            n2 += 3;
                            continue;
                        }
                        this.lfColors[n3++] = this.tmpColors[n2];
                        this.lfColors[n3++] = this.tmpColors[n2 + 1];
                        this.lfColors[n3++] = this.tmpColors[n2 + 2];
                    }
                } else {
                    n2 = 0;
                    for (n = 0; n < this.numCoordIndex; ++n) {
                        if (this.vfCoordIndex[n] == -1) {
                            n2 += 4;
                            continue;
                        }
                        this.lfColors[n3++] = this.tmpColors[n2];
                        this.lfColors[n3++] = this.tmpColors[n2 + 1];
                        this.lfColors[n3++] = this.tmpColors[n2 + 2];
                        this.lfColors[n3++] = this.tmpColors[n2 + 3];
                    }
                }
            } else if (!this.hasAlpha) {
                for (n2 = 0; n2 < this.numColorIndex; ++n2) {
                    if (this.vfColorIndex[n2] == -1) continue;
                    n = this.vfColorIndex[n2] * 3;
                    this.lfColors[n3++] = this.tmpColors[n++];
                    this.lfColors[n3++] = this.tmpColors[n++];
                    this.lfColors[n3++] = this.tmpColors[n];
                }
            } else {
                for (n2 = 0; n2 < this.numColorIndex; ++n2) {
                    if (this.vfColorIndex[n2] == -1) continue;
                    n = this.vfColorIndex[n2] * 4;
                    this.lfColors[n3++] = this.tmpColors[n++];
                    this.lfColors[n3++] = this.tmpColors[n++];
                    this.lfColors[n3++] = this.tmpColors[n++];
                    this.lfColors[n3++] = this.tmpColors[n];
                }
            }
            if (this.implGeom.isLive()) {
                this.implGeom.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.implGeom);
            }
        }
        this.changeFlags = 0;
    }
}

