/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.render;

import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.LineStripArray;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.render.BaseLineSet;
import org.web3d.vrml.renderer.ogl.nodes.OGLGeometryNodeType;

public class OGLLineSet
extends BaseLineSet
implements OGLGeometryNodeType,
NodeUpdateListener {
    private LineStripArray implGeom;
    private float[] tmpColors;
    private boolean coordsChanged;
    private boolean stripsChanged;
    private float[] unlitColor;

    public OGLLineSet() {
        this.init();
    }

    public OGLLineSet(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public Geometry getGeometry() {
        return this.implGeom;
    }

    public int getNumSets() {
        return 0;
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public boolean requiresUnlitColor() {
        return true;
    }

    public void setUnlitColor(float[] fArray) {
        this.changeFlags |= 0x40;
        if (this.unlitColor == null) {
            this.unlitColor = new float[3];
        }
        this.unlitColor[0] = fArray[0];
        this.unlitColor[1] = fArray[1];
        this.unlitColor[2] = fArray[2];
        if (this.implGeom.isLive()) {
            this.implGeom.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implGeom);
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            return;
        }
        switch (n) {
            case 2: {
                if (vRMLNodeType.getPrimaryType() != 9) {
                    throw new InvalidFieldValueException("Proto does not describe a GeometryComponent object");
                }
                if (this.implGeom.isLive()) {
                    this.implGeom.dataChanged((NodeUpdateListener)this);
                    break;
                }
                this.updateNodeDataChanges(this.implGeom);
                break;
            }
            case 1: {
                if (vRMLNodeType.getPrimaryType() != 11) {
                    throw new InvalidFieldValueException("Proto does not describe a GeometryComponent object");
                }
                if (this.implGeom.isLive()) {
                    this.implGeom.boundsChanged((NodeUpdateListener)this);
                    break;
                }
                this.updateNodeBoundsChanges(this.implGeom);
                break;
            }
            default: {
                System.out.println("OGLLineSet: Unknown field for notifyExternProtoLoaded");
            }
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        int n = this.vfColor == null ? 0 : this.vfColor.getNumColors();
        this.tmpColors = new float[n];
        this.coordsChanged = true;
        this.stripsChanged = true;
        this.updateNodeBoundsChanges(null);
        this.updateNodeDataChanges(null);
    }

    public void fieldChanged(VRMLNodeType vRMLNodeType, int n) {
        if (vRMLNodeType instanceof VRMLCoordinateNodeType) {
            if (this.implGeom.isLive()) {
                this.implGeom.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implGeom);
            }
        } else if (this.implGeom.isLive()) {
            this.implGeom.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implGeom);
        }
    }

    protected void setCoordinateNode(VRMLCoordinateNodeType vRMLCoordinateNodeType) {
        if (this.inSetup) {
            return;
        }
        this.coordsChanged = true;
        if (this.implGeom.isLive()) {
            this.implGeom.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.implGeom);
        }
    }

    protected void setColorNode(VRMLColorNodeType vRMLColorNodeType) {
        if (this.inSetup) {
            return;
        }
        if (this.implGeom.isLive()) {
            this.implGeom.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implGeom);
        }
    }

    public void updateNodeBoundsChanges(Object object) {
        if (this.vfCoord == null) {
            this.implGeom.setValidVertexCount(0);
        } else {
            if (this.coordsChanged) {
                int n = 0;
                for (int i = 0; i < this.numVertexCount; ++i) {
                    n += this.vfVertexCount[i];
                }
                float[] fArray = this.vfCoord.getPointRef();
                this.implGeom.setVertices(3, fArray, n);
                this.coordsChanged = false;
            }
            if (this.stripsChanged) {
                this.implGeom.setStripCount(this.vfVertexCount, this.numVertexCount);
                this.stripsChanged = false;
            }
        }
    }

    public void updateNodeDataChanges(Object object) {
        if (this.vfColor == null) {
            this.implGeom.setSingleColor(false, this.unlitColor);
        } else {
            boolean bl = this.vfColor.getNumColorComponents() == 4;
            int n = this.vfColor.getNumColors();
            if (this.tmpColors.length < n) {
                this.tmpColors = new float[n];
            }
            this.vfColor.getColor(this.tmpColors);
            this.implGeom.setColors(bl, this.tmpColors);
        }
    }

    protected void setVertexCount(int[] nArray, int n) throws InvalidFieldValueException {
        super.setVertexCount(nArray, n);
        if (!this.inSetup) {
            this.stripsChanged = true;
            if (this.implGeom.isLive()) {
                this.implGeom.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implGeom);
            }
        }
    }

    private void init() {
        this.implGeom = new LineStripArray();
        this.stripsChanged = false;
        this.coordsChanged = false;
    }
}

