/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.render;

import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.PointArray;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.render.BasePointSet;
import org.web3d.vrml.renderer.ogl.nodes.OGLGeometryNodeType;

public class OGLPointSet
extends BasePointSet
implements OGLGeometryNodeType,
NodeUpdateListener {
    private PointArray implGeom;
    private float[] tmpColors;
    private float[] unlitColor;

    public OGLPointSet() {
        this.init();
    }

    public OGLPointSet(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public Geometry getGeometry() {
        return this.implGeom;
    }

    public int getNumSets() {
        return 0;
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public boolean requiresUnlitColor() {
        return true;
    }

    public void setUnlitColor(float[] fArray) {
        this.changeFlags |= 0x40;
        if (this.unlitColor == null) {
            this.unlitColor = new float[3];
        }
        this.unlitColor[0] = fArray[0];
        this.unlitColor[1] = fArray[1];
        this.unlitColor[2] = fArray[2];
        if (this.implGeom.isLive()) {
            this.implGeom.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implGeom);
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            return;
        }
        switch (n) {
            case 2: {
                if (vRMLNodeType.getPrimaryType() != 9) {
                    throw new InvalidFieldValueException("Proto does not describe a GeometryComponent object");
                }
                if (this.implGeom.isLive()) {
                    this.implGeom.boundsChanged((NodeUpdateListener)this);
                    break;
                }
                this.updateNodeBoundsChanges(this.implGeom);
                break;
            }
            case 1: {
                if (vRMLNodeType.getPrimaryType() != 11) {
                    throw new InvalidFieldValueException("Proto does not describe a GeometryComponent object");
                }
                if (this.implGeom.isLive()) {
                    this.implGeom.boundsChanged((NodeUpdateListener)this);
                    break;
                }
                this.updateNodeBoundsChanges(this.implGeom);
                break;
            }
            default: {
                System.out.println("OGLPointSet: Unknown field for notifyExternProtoLoaded");
            }
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        int n = this.vfColor == null ? 0 : this.vfColor.getNumColors();
        this.tmpColors = new float[n];
        this.updateNodeBoundsChanges(null);
        this.updateNodeDataChanges(null);
    }

    public void fieldChanged(VRMLNodeType vRMLNodeType, int n) {
        if (vRMLNodeType instanceof VRMLCoordinateNodeType) {
            if (this.implGeom.isLive()) {
                this.implGeom.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implGeom);
            }
        } else if (this.implGeom.isLive()) {
            this.implGeom.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.implGeom);
        }
    }

    protected void setCoordinateNode(VRMLCoordinateNodeType vRMLCoordinateNodeType) {
        if (this.inSetup) {
            return;
        }
        if (this.implGeom.isLive()) {
            this.implGeom.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.implGeom);
        }
    }

    protected void setColorNode(VRMLColorNodeType vRMLColorNodeType) {
        if (this.inSetup) {
            return;
        }
        if (this.implGeom.isLive()) {
            this.implGeom.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.implGeom);
        }
    }

    public void updateNodeBoundsChanges(Object object) {
        if (this.vfCoord == null) {
            this.implGeom.setValidVertexCount(0);
        } else {
            int n = this.vfCoord.getNumPoints();
            float[] fArray = this.vfCoord.getPointRef();
            this.implGeom.setVertices(3, fArray, n / 3);
        }
    }

    public void updateNodeDataChanges(Object object) {
        if (this.vfColor == null) {
            this.implGeom.setSingleColor(false, this.unlitColor);
        } else {
            boolean bl = this.vfColor.getNumColorComponents() == 4;
            int n = this.vfColor.getNumColors();
            if (this.tmpColors.length < n) {
                this.tmpColors = new float[n];
            }
            this.vfColor.getColor(this.tmpColors);
            this.implGeom.setColors(bl, this.tmpColors);
        }
    }

    private void init() {
        this.implGeom = new PointArray();
    }
}

