/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.render;

import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.IndexedTriangleArray;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.TriangleArray;
import org.j3d.aviatrix3d.VertexGeometry;
import org.j3d.geom.GeometryData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.GeometryHolder;
import org.web3d.vrml.renderer.common.nodes.GeometryUtils;
import org.web3d.vrml.renderer.common.nodes.render.BaseTriangleSet;
import org.web3d.vrml.renderer.ogl.nodes.OGLGeometryNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;

public class OGLTriangleSet
extends BaseTriangleSet
implements OGLGeometryNodeType,
NodeUpdateListener {
    private VertexGeometry implGeom;
    private float[][] texCoords;
    private int[] texTypes;
    private int[] texSetMap;
    private int numTexSets;
    private int numUniqueTexSets;
    private boolean coordChanged;
    private boolean colorChanged;
    private boolean texCoordChanged;
    private boolean normalChanged;
    private boolean indexed;
    private GeometryUtils gutils;
    private int numBuilds;
    private int[] indexes;
    private boolean indexsChanged;

    public OGLTriangleSet() {
        this.init();
    }

    public OGLTriangleSet(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public Geometry getGeometry() {
        return this.implGeom;
    }

    public int getNumSets() {
        int n = 0;
        if (this.vfTexCoord != null) {
            n = this.vfTexCoord.getNumSets();
        }
        return n;
    }

    public String getTexCoordGenMode(int n) {
        String string = null;
        if (this.vfTexCoord != null) {
            string = this.vfTexCoord.getTexCoordGenMode(n);
        }
        return string;
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public void updateNodeBoundsChanges(Object object) {
        if (this.coordChanged) {
            if (this.vfCoord == null) {
                this.implGeom.setValidVertexCount(0);
            } else {
                this.implGeom.setVertices(3, this.geomData.coordinates, this.geomData.vertexCount);
            }
        }
    }

    public void updateNodeDataChanges(Object object) {
        if (this.colorChanged) {
            if (this.vfColor == null) {
                this.implGeom.setColors(false, null);
            } else {
                boolean bl = this.vfColor.getNumColorComponents() == 4;
                this.implGeom.setColors(bl, this.geomData.colors);
            }
            this.colorChanged = false;
        }
        if (this.texCoordChanged) {
            if (this.vfTexCoord == null) {
                this.implGeom.setTextureCoordinates(null, (float[][])null, 0);
            } else {
                this.implGeom.setTextureCoordinates(this.texTypes, this.texCoords, this.numUniqueTexSets);
                this.implGeom.setTextureSetMap(this.texSetMap, this.numTexSets);
            }
            this.texCoordChanged = false;
        }
        if (this.normalChanged) {
            if (this.vfNormal == null) {
                this.implGeom.setNormals(this.geomData.normals);
            } else {
                this.updateNormalArray();
                this.implGeom.setNormals(this.geomData.normals);
            }
            this.normalChanged = false;
        }
    }

    protected void buildImpl() {
        boolean bl = false;
        if (this.vfNormal != null) {
            this.geomData.geometryType = 6;
            if (!this.indexed || this.implGeom == null) {
                this.implGeom = new IndexedTriangleArray();
                OGLUserData oGLUserData = new OGLUserData();
                oGLUserData.geometryData = this.geomData;
                this.implGeom.setUserData((Object)oGLUserData);
                this.indexed = true;
                bl = true;
            }
            if ((this.changeFlags & 1) != 0) {
                this.updateCoordinateArray();
            }
            if ((this.changeFlags & 8) != 0) {
                this.updateColorArray();
            }
            if ((this.changeFlags & 2) != 0) {
                this.updateNormalArray();
            }
            if ((this.changeFlags & 4) != 0) {
                int n;
                int n2;
                int n3 = this.numTexSets = this.vfTexCoord.getNumSets();
                int n4 = this.vfTexCoord.getSize(0);
                int n5 = this.vfTexCoord.getNumTextureComponents();
                int n6 = 0;
                for (n2 = 0; n2 < this.numTexSets; ++n2) {
                    if (n2 == this.vfTexCoord.isShared(n2)) continue;
                    --n3;
                }
                for (n2 = 1; n2 < this.numTexSets; ++n2) {
                    n = this.vfTexCoord.getSize(n2);
                    if (n4 <= n) continue;
                    n4 = n;
                }
                if (n4 < this.geomData.vertexCount * n5) {
                    n4 = this.geomData.vertexCount * n5;
                }
                if (this.texCoords == null || this.texCoords.length != n3) {
                    this.texCoords = new float[n3][];
                }
                if (this.texSetMap == null || this.texSetMap.length != this.numTexSets) {
                    this.texSetMap = new int[this.numTexSets];
                }
                for (n2 = 0; n2 < this.numTexSets; ++n2) {
                    this.texSetMap[n2] = this.vfTexCoord.isShared(n2);
                }
                if (this.texTypes == null || this.texTypes.length != this.numUniqueTexSets) {
                    this.texTypes = new int[this.numUniqueTexSets];
                }
                switch (n5) {
                    case 1: {
                        n6 = 1;
                        break;
                    }
                    case 2: {
                        n6 = 2;
                        break;
                    }
                    case 3: {
                        n6 = 3;
                        break;
                    }
                    case 4: {
                        n6 = 4;
                        break;
                    }
                    default: {
                        System.out.println("Invalid number of texture components " + this.vfTexCoord.getNumTextureComponents());
                    }
                }
                for (n2 = 0; n2 < this.numUniqueTexSets; ++n2) {
                    this.texTypes[n2] = n6;
                }
                n2 = 0;
                for (n = 0; n < this.numTexSets; ++n) {
                    this.texSetMap[n] = this.vfTexCoord.isShared(n);
                    if (this.texSetMap[n] != n2) continue;
                    this.texCoords[n2] = new float[n4];
                    this.vfTexCoord.getPoint(n, this.texCoords[n2++]);
                }
            }
        } else {
            int n;
            int n7;
            int n8;
            OGLUserData oGLUserData;
            this.geomData.geometryType = 1;
            if (this.indexed || this.implGeom == null) {
                this.implGeom = new TriangleArray();
                oGLUserData = new OGLUserData();
                oGLUserData.geometryData = this.geomData;
                this.implGeom.setUserData((Object)oGLUserData);
                this.indexed = false;
                bl = true;
            }
            if (this.gutils == null) {
                this.gutils = new GeometryUtils();
            }
            oGLUserData = new GeometryHolder();
            float f = this.vfNormalPerVertex ? (float)Math.PI : 0.0f;
            if (this.vfCoord == null) {
                return;
            }
            if (this.indexes == null || (this.changeFlags & 1) != 0) {
                n8 = this.vfCoord.getNumPoints() / 3;
                n7 = n8 + n8 / 3;
                if (this.indexes == null || this.indexes.length < n7) {
                    this.indexes = new int[n7];
                }
                n = 0;
                for (int i = 0; i < n8 / 3; ++i) {
                    this.indexes[i * 4] = n++;
                    this.indexes[i * 4 + 1] = n++;
                    this.indexes[i * 4 + 2] = n++;
                    this.indexes[i * 4 + 3] = -1;
                }
            }
            this.gutils.generateTriangleArrays(this.changeFlags, false, true, this.vfCoord, this.vfColor, this.vfNormal, this.vfTexCoord, this.indexes, this.indexes.length, this.indexes, this.indexes, this.indexes, this.vfCcw, true, this.vfColorPerVertex, this.vfNormalPerVertex, f, bl, (GeometryHolder)oGLUserData);
            if (((GeometryHolder)oGLUserData).coordinates == null) {
                return;
            }
            this.gutils.copyData((GeometryHolder)oGLUserData, this.geomData);
            this.texCoords = ((GeometryHolder)oGLUserData).textureCoordinates;
            this.numTexSets = ((GeometryHolder)oGLUserData).numTexSets;
            this.numUniqueTexSets = ((GeometryHolder)oGLUserData).numUniqueTexSets;
            if (this.vfTexCoord == null) {
                if (this.implGeom.isLive()) {
                    this.texTypes = null;
                    this.texCoords = null;
                }
            } else {
                n8 = 0;
                n7 = this.vfTexCoord.getNumTextureComponents();
                switch (n7) {
                    case 1: {
                        n8 = 1;
                        break;
                    }
                    case 2: {
                        n8 = 2;
                        break;
                    }
                    case 3: {
                        n8 = 3;
                        break;
                    }
                    case 4: {
                        n8 = 4;
                        break;
                    }
                    default: {
                        System.out.println("Invalid number of texture components " + this.vfTexCoord.getNumTextureComponents());
                    }
                }
                if (this.texSetMap == null || this.texSetMap.length != this.numTexSets) {
                    this.texSetMap = new int[this.numTexSets];
                }
                for (n = 0; n < this.numTexSets; ++n) {
                    this.texSetMap[n] = this.vfTexCoord.isShared(n);
                }
                if (this.texTypes == null || this.texTypes.length != this.numTexSets) {
                    this.texTypes = new int[this.numTexSets];
                }
                for (n = 0; n < this.numTexSets; ++n) {
                    this.texTypes[n] = n8;
                }
            }
        }
        if (bl) {
            this.coordChanged = true;
            this.colorChanged = true;
            this.normalChanged = true;
            this.texCoordChanged = true;
            if (this.implGeom.isLive()) {
                this.implGeom.boundsChanged((NodeUpdateListener)this);
                this.implGeom.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(null);
                this.updateNodeDataChanges(null);
            }
        } else {
            if ((this.changeFlags & 1) != 0) {
                this.coordChanged = true;
                if (this.implGeom.isLive()) {
                    this.implGeom.boundsChanged((NodeUpdateListener)this);
                } else {
                    this.updateNodeBoundsChanges(this.implGeom);
                }
            }
            if ((this.changeFlags & 1) != 0 && this.vfNormal == null || (this.changeFlags & 2) != 0) {
                this.normalChanged = true;
                if (this.implGeom.isLive()) {
                    this.implGeom.dataChanged((NodeUpdateListener)this);
                } else {
                    this.updateNodeDataChanges(this.implGeom);
                }
            }
            if ((this.changeFlags & 4) != 0) {
                if (this.vfTexCoord == null) {
                    if (this.implGeom.isLive()) {
                        this.texTypes = null;
                        this.texCoords = null;
                        this.texCoordChanged = true;
                        this.implGeom.dataChanged((NodeUpdateListener)this);
                    } else {
                        this.implGeom.setTextureCoordinates(null, (float[][])null);
                    }
                } else {
                    this.texCoordChanged = true;
                    if (this.implGeom.isLive()) {
                        this.implGeom.dataChanged((NodeUpdateListener)this);
                    } else {
                        this.updateNodeDataChanges(this.implGeom);
                    }
                }
            }
            if ((this.changeFlags & 8) != 0) {
                this.colorChanged = true;
                if (this.implGeom.isLive()) {
                    this.implGeom.dataChanged((NodeUpdateListener)this);
                } else {
                    this.updateNodeDataChanges(this.implGeom);
                }
            }
        }
        this.changeFlags = 0;
        if (this.isStatic || this.numBuilds < 1) {
            if (this.gutils != null) {
                this.gutils.reset();
                this.gutils = null;
                this.indexes = null;
            }
            if (this.inSetup) {
                this.texCoords = null;
                this.texTypes = null;
                this.texSetMap = null;
            }
        }
        ++this.numBuilds;
    }

    private void init() {
        this.geomData = new GeometryData();
        this.coordChanged = false;
        this.colorChanged = false;
        this.normalChanged = false;
        this.texCoordChanged = false;
    }
}

