/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.render;

import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.TriangleArray;
import org.j3d.aviatrix3d.TriangleStripArray;
import org.j3d.aviatrix3d.VertexGeometry;
import org.j3d.geom.GeometryData;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.GeometryHolder;
import org.web3d.vrml.renderer.common.nodes.GeometryUtils;
import org.web3d.vrml.renderer.common.nodes.render.BaseTriangleStripSet;
import org.web3d.vrml.renderer.ogl.nodes.OGLGeometryNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;

public class OGLTriangleStripSet
extends BaseTriangleStripSet
implements OGLGeometryNodeType,
NodeUpdateListener {
    private VertexGeometry implGeom;
    private float[][] texCoords;
    private int[] texTypes;
    private int[] texSetMap;
    private int numTexSets;
    private int numUniqueTexSets;
    private boolean coordChanged;
    private boolean stripsChanged;
    private boolean colorChanged;
    private boolean texCoordChanged;
    private boolean normalChanged;
    private boolean indexed;
    private GeometryUtils gutils;
    private int numBuilds;
    private int[] indexes;

    public OGLTriangleStripSet() {
        this.init();
    }

    public OGLTriangleStripSet(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public Geometry getGeometry() {
        return this.implGeom;
    }

    public int getNumSets() {
        int n = 0;
        if (this.vfTexCoord != null) {
            n = this.vfTexCoord.getNumSets();
        }
        return n;
    }

    public String getTexCoordGenMode(int n) {
        String string = null;
        if (this.vfTexCoord != null) {
            string = this.vfTexCoord.getTexCoordGenMode(n);
        }
        return string;
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public void updateNodeBoundsChanges(Object object) {
        if (this.coordChanged) {
            if (this.vfCoord == null) {
                this.implGeom.setValidVertexCount(0);
            } else {
                this.implGeom.setVertices(3, this.geomData.coordinates, this.geomData.vertexCount);
            }
        }
        if (this.stripsChanged) {
            if (this.indexed) {
                TriangleStripArray triangleStripArray = (TriangleStripArray)this.implGeom;
                triangleStripArray.setStripCount(this.vfStripCount, this.numStripCount);
            }
            this.stripsChanged = false;
        }
    }

    public void updateNodeDataChanges(Object object) {
        if (this.colorChanged) {
            if (this.vfColor == null) {
                this.implGeom.setColors(false, null);
            } else {
                boolean bl = this.vfColor.getNumColorComponents() == 4;
                this.implGeom.setColors(bl, this.geomData.colors);
            }
            this.colorChanged = false;
        }
        if (this.texCoordChanged) {
            if (this.vfTexCoord == null) {
                this.implGeom.setTextureCoordinates(null, (float[][])null, 0);
            } else {
                this.implGeom.setTextureCoordinates(this.texTypes, this.texCoords, this.numUniqueTexSets);
                this.implGeom.setTextureSetMap(this.texSetMap, this.numTexSets);
            }
            this.texCoordChanged = false;
        }
        if (this.normalChanged) {
            if (this.vfNormal == null) {
                this.implGeom.setNormals(this.geomData.normals);
            } else {
                this.updateNormalArray();
                this.implGeom.setNormals(this.geomData.normals);
            }
            this.normalChanged = false;
        }
    }

    protected void buildImpl() {
        boolean bl = false;
        if (this.vfNormal != null) {
            this.geomData.geometryType = 3;
            if (!this.indexed || this.implGeom == null) {
                this.implGeom = new TriangleStripArray();
                OGLUserData oGLUserData = new OGLUserData();
                oGLUserData.geometryData = this.geomData;
                this.implGeom.setUserData((Object)oGLUserData);
                this.indexed = true;
                bl = true;
            }
            if ((this.changeFlags & 1) != 0) {
                this.updateCoordinateArray();
            }
            if ((this.changeFlags & 8) != 0) {
                this.updateColorArray();
            }
            if ((this.changeFlags & 2) != 0) {
                this.updateNormalArray();
            }
            if ((this.changeFlags & 4) != 0) {
                int n;
                int n2 = this.numTexSets = this.vfTexCoord.getNumSets();
                int n3 = this.vfTexCoord.getSize(0);
                int n4 = this.vfTexCoord.getNumTextureComponents();
                int n5 = 0;
                for (n = 0; n < this.numTexSets; ++n) {
                    if (n == this.vfTexCoord.isShared(n)) continue;
                    --n2;
                }
                for (n = 1; n < this.numTexSets; ++n) {
                    int n6 = this.vfTexCoord.getSize(n);
                    if (n3 <= n6) continue;
                    n3 = n6;
                }
                if (n3 < this.geomData.vertexCount * n4) {
                    n3 = this.geomData.vertexCount * n4;
                }
                if (this.texCoords == null || this.texCoords.length != this.numTexSets) {
                    this.texCoords = new float[this.numTexSets][];
                }
                if (this.texSetMap == null || this.texSetMap.length != this.numTexSets) {
                    this.texSetMap = new int[this.numTexSets];
                }
                for (n = 0; n < this.numTexSets; ++n) {
                    this.texSetMap[n] = this.vfTexCoord.isShared(n);
                }
                if (this.texTypes == null || this.texTypes.length != this.numUniqueTexSets) {
                    this.texTypes = new int[this.numUniqueTexSets];
                }
                switch (n4) {
                    case 1: {
                        n5 = 1;
                        break;
                    }
                    case 2: {
                        n5 = 2;
                        break;
                    }
                    case 3: {
                        n5 = 3;
                        break;
                    }
                    case 4: {
                        n5 = 4;
                        break;
                    }
                    default: {
                        System.out.println("Invalid number of texture components " + this.vfTexCoord.getNumTextureComponents());
                    }
                }
                for (n = 0; n < this.numUniqueTexSets; ++n) {
                    this.texTypes[n] = n5;
                }
                for (n = 0; n < this.numTexSets; ++n) {
                    this.texSetMap[n] = this.vfTexCoord.isShared(n);
                    if (this.texSetMap[n] != n) continue;
                    this.texCoords[n] = new float[n3];
                    this.vfTexCoord.getPoint(n, this.texCoords[n]);
                }
            }
        } else {
            int n;
            int n7;
            OGLUserData oGLUserData;
            this.geomData.geometryType = 1;
            if (this.indexed || this.implGeom == null) {
                this.implGeom = new TriangleArray();
                oGLUserData = new OGLUserData();
                oGLUserData.geometryData = this.geomData;
                this.implGeom.setUserData((Object)oGLUserData);
                this.indexed = false;
                bl = true;
            }
            if (this.gutils == null) {
                this.gutils = new GeometryUtils();
            }
            oGLUserData = new GeometryHolder();
            float f = this.vfNormalPerVertex ? (float)Math.PI : 0.0f;
            if (this.stripsChanged) {
                n7 = 0;
                for (n = 0; n < this.numStripCount; ++n) {
                    n7 += (this.vfStripCount[n] - 2) * 4;
                }
                if (this.indexes == null || this.indexes.length < n7) {
                    this.indexes = new int[n7];
                }
                n = 0;
                int n8 = 0;
                int n9 = 0;
                for (int i = 0; i < this.numStripCount; ++i) {
                    n9 = 0;
                    for (int j = 0; j < this.vfStripCount[i] - 2; ++j) {
                        if (n9 == 0) {
                            this.indexes[n++] = n8;
                            this.indexes[n++] = n8 + 1;
                            this.indexes[n++] = n8 + 2;
                            this.indexes[n++] = -1;
                            ++n9;
                        } else {
                            this.indexes[n++] = n8;
                            this.indexes[n++] = n8 + 2;
                            this.indexes[n++] = n8 + 1;
                            this.indexes[n++] = -1;
                            n9 = 0;
                        }
                        ++n8;
                    }
                    n8 += 2;
                }
            }
            this.gutils.generateTriangleArrays(this.changeFlags, false, true, this.vfCoord, this.vfColor, this.vfNormal, this.vfTexCoord, this.indexes, this.indexes.length, this.indexes, this.indexes, this.indexes, this.vfCcw, true, this.vfColorPerVertex, this.vfNormalPerVertex, f, bl, (GeometryHolder)oGLUserData);
            if (((GeometryHolder)oGLUserData).coordinates == null) {
                return;
            }
            this.gutils.copyData((GeometryHolder)oGLUserData, this.geomData);
            this.texCoords = ((GeometryHolder)oGLUserData).textureCoordinates;
            this.numTexSets = ((GeometryHolder)oGLUserData).numTexSets;
            this.numUniqueTexSets = ((GeometryHolder)oGLUserData).numUniqueTexSets;
            if (this.vfTexCoord == null) {
                if (this.implGeom.isLive()) {
                    this.texTypes = null;
                    this.texCoords = null;
                }
            } else {
                int n10;
                n7 = 0;
                n = this.vfTexCoord.getNumTextureComponents();
                switch (n) {
                    case 1: {
                        n7 = 1;
                        break;
                    }
                    case 2: {
                        n7 = 2;
                        break;
                    }
                    case 3: {
                        n7 = 3;
                        break;
                    }
                    case 4: {
                        n7 = 4;
                        break;
                    }
                    default: {
                        System.out.println("Invalid number of texture components " + this.vfTexCoord.getNumTextureComponents());
                    }
                }
                if (this.texSetMap == null || this.texSetMap.length != this.numTexSets) {
                    this.texSetMap = new int[this.numTexSets];
                }
                for (n10 = 0; n10 < this.numTexSets; ++n10) {
                    this.texSetMap[n10] = this.vfTexCoord.isShared(n10);
                }
                if (this.texTypes == null || this.texTypes.length != this.numTexSets) {
                    this.texTypes = new int[this.numTexSets];
                }
                for (n10 = 0; n10 < this.numTexSets; ++n10) {
                    this.texTypes[n10] = n7;
                }
            }
        }
        if (bl) {
            this.stripsChanged = true;
            this.coordChanged = true;
            this.colorChanged = true;
            this.normalChanged = true;
            this.texCoordChanged = true;
            if (this.implGeom.isLive()) {
                this.implGeom.boundsChanged((NodeUpdateListener)this);
                this.implGeom.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(null);
                this.updateNodeDataChanges(null);
            }
        } else {
            if ((this.changeFlags & 1) != 0) {
                this.coordChanged = true;
                if (this.implGeom.isLive()) {
                    this.implGeom.boundsChanged((NodeUpdateListener)this);
                } else {
                    this.updateNodeBoundsChanges(this.implGeom);
                }
            }
            if ((this.changeFlags & 1) != 0 && this.vfNormal == null || (this.changeFlags & 2) != 0) {
                this.normalChanged = true;
                if (this.implGeom.isLive()) {
                    this.implGeom.dataChanged((NodeUpdateListener)this);
                } else {
                    this.updateNodeDataChanges(this.implGeom);
                }
            }
            if ((this.changeFlags & 4) != 0) {
                if (this.vfTexCoord == null) {
                    if (this.implGeom.isLive()) {
                        this.texTypes = null;
                        this.texCoords = null;
                        this.texCoordChanged = true;
                        this.implGeom.dataChanged((NodeUpdateListener)this);
                    } else {
                        this.implGeom.setTextureCoordinates(null, (float[][])null);
                    }
                } else {
                    this.texCoordChanged = true;
                    if (this.implGeom.isLive()) {
                        this.implGeom.dataChanged((NodeUpdateListener)this);
                    } else {
                        this.updateNodeDataChanges(this.implGeom);
                    }
                }
            }
            if ((this.changeFlags & 8) != 0) {
                this.colorChanged = true;
                if (this.implGeom.isLive()) {
                    this.implGeom.dataChanged((NodeUpdateListener)this);
                } else {
                    this.updateNodeDataChanges(this.implGeom);
                }
            }
        }
        this.changeFlags = 0;
        if (this.isStatic || this.numBuilds < 1) {
            if (this.gutils != null) {
                this.gutils.reset();
                this.gutils = null;
                this.indexes = null;
            }
            if (this.inSetup) {
                this.texCoords = null;
                this.texTypes = null;
                this.texSetMap = null;
            }
        }
        ++this.numBuilds;
    }

    protected void setStripCount(int[] nArray, int n) throws InvalidFieldValueException {
        super.setStripCount(nArray, n);
        this.stripsChanged = true;
        if (!this.inSetup) {
            this.buildImpl();
        }
    }

    private void init() {
        this.geomData = new GeometryData();
        this.stripsChanged = false;
        this.coordChanged = false;
        this.colorChanged = false;
        this.normalChanged = false;
        this.texCoordChanged = false;
    }
}

