/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.shape;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.ImageTextureComponent2D;
import org.j3d.aviatrix3d.ImageTextureComponent3D;
import org.j3d.aviatrix3d.LineAttributes;
import org.j3d.aviatrix3d.Material;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.PolygonAttributes;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.TexCoordGeneration;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.Texture2D;
import org.j3d.aviatrix3d.Texture3D;
import org.j3d.aviatrix3d.TextureAttributes;
import org.j3d.aviatrix3d.TextureComponent;
import org.j3d.aviatrix3d.TextureComponent2D;
import org.j3d.aviatrix3d.TextureSource;
import org.j3d.aviatrix3d.TextureUnit;
import org.j3d.renderer.aviatrix3d.texture.AVTextureCache;
import org.j3d.renderer.aviatrix3d.texture.AVTextureCacheFactory;
import org.j3d.texture.TextureCache;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLComposedTextureNodeType;
import org.web3d.vrml.nodes.VRMLMultiTextureNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLTexture2DNodeType;
import org.web3d.vrml.nodes.VRMLTexture3DNodeType;
import org.web3d.vrml.nodes.VRMLTextureListener;
import org.web3d.vrml.nodes.VRMLTextureNodeType;
import org.web3d.vrml.nodes.VRMLTextureProperties2DNodeType;
import org.web3d.vrml.renderer.common.nodes.shape.BaseAppearance;
import org.web3d.vrml.renderer.common.nodes.shape.TextureStage;
import org.web3d.vrml.renderer.ogl.nodes.OGLAppearanceNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLMaterialNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLTextureConstConverter;
import org.web3d.vrml.renderer.ogl.nodes.OGLTextureCoordinateTransformNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLTextureNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLTextureTransformListener;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;

public class OGLAppearance
extends BaseAppearance
implements OGLAppearanceNodeType,
OGLTextureTransformListener,
NodeUpdateListener,
FrameStateListener {
    private static final String TEXTURE_CREATE_FAIL_MSG = "Failed for an unknown reason during the creation of the base texture image in OGLAppearance.createTexture(). URL is: ";
    private static final String NESTED_MULTITEXTURE_ERR = "Discovered a nested MultiTexture node while processing a MultiTexture node. This is not legal. See 19775-1 18.4.3 paragraph 2 for more information";
    private Appearance oglImplNode;
    private PolygonAttributes implPA;
    private TextureAttributes[] texAttrs;
    private TextureUnit[] texUnits;
    private HashMap texGenMap;
    private static HashMap texGenModeMap = new HashMap(3);
    private ArrayList listeners;
    private Texture[] texObjs;
    private VRMLTextureNodeType[] vrmlTexs;
    private int[] modes;
    private int[] functions;
    private int[] sources;
    private boolean materialChanged;
    private boolean fillPropsChanged;
    private boolean linePropsChanged;
    private boolean textureUnitsChanged;
    private boolean textureTransformChanged;
    private HashMap changedTransforms;
    private HashMap changedTexCoordGeneration;
    private boolean textureChanged;
    private boolean savedSolidState;
    private boolean savedCCWState;
    private boolean texUnitChanged;
    private ArrayList[] texUnitsChanged;
    private int tucIdx;
    private boolean lightingState;
    private boolean localColor;
    private boolean localColorAlpha;
    boolean lightingOverride;

    public OGLAppearance() {
        this.init();
    }

    public OGLAppearance(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void allEventsComplete() {
        if (this.materialChanged || this.linePropsChanged || this.fillPropsChanged) {
            this.oglImplNode.dataChanged((NodeUpdateListener)this);
        } else {
            int n = this.tucIdx;
            this.tucIdx = this.tucIdx == 0 ? 1 : 0;
            int n2 = this.texUnitsChanged[n].size();
            for (int i = 0; i < n2; ++i) {
                SceneGraphObject sceneGraphObject = (SceneGraphObject)this.texUnitsChanged[n].get(i);
                if (sceneGraphObject.isLive()) {
                    sceneGraphObject.dataChanged((NodeUpdateListener)this);
                } else {
                    this.updateNodeDataChanges(sceneGraphObject);
                }
                this.texUnitChanged = true;
            }
        }
    }

    public void setMaterial(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setMaterial(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        this.materialChanged = true;
        if (this.oglImplNode.isLive()) {
            this.oglImplNode.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.oglImplNode);
        }
    }

    public void setTexture(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLTextureNodeType vRMLTextureNodeType = this.vfTexture;
        super.setTexture(vRMLNodeType);
        if (vRMLTextureNodeType != null) {
            vRMLTextureNodeType.removeTextureListener((VRMLTextureListener)this);
        }
        if (this.vfTexture != null) {
            this.vfTexture.addTextureListener((VRMLTextureListener)this);
        }
        if (this.inSetup) {
            return;
        }
        this.textureChanged = true;
        if (this.oglImplNode.isLive()) {
            this.oglImplNode.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.oglImplNode);
        }
    }

    public void setTextureTransform(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        OGLTextureCoordinateTransformNodeType oGLTextureCoordinateTransformNodeType = (OGLTextureCoordinateTransformNodeType)this.vfTextureTransform;
        super.setTextureTransform(vRMLNodeType);
        OGLTextureCoordinateTransformNodeType oGLTextureCoordinateTransformNodeType2 = (OGLTextureCoordinateTransformNodeType)this.vfTextureTransform;
        if (oGLTextureCoordinateTransformNodeType2 != null) {
            oGLTextureCoordinateTransformNodeType2.addTransformListener(this);
        }
        if (oGLTextureCoordinateTransformNodeType != null) {
            oGLTextureCoordinateTransformNodeType.removeTransformListener(this);
        }
        if (this.inSetup) {
            return;
        }
        this.textureTransformChanged = true;
        if (this.oglImplNode.isLive()) {
            this.oglImplNode.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.oglImplNode);
        }
    }

    public void setLineProperties(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setLineProperties(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        this.linePropsChanged = true;
        if (this.oglImplNode.isLive()) {
            this.oglImplNode.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.oglImplNode);
        }
    }

    public void setFillProperties(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setFillProperties(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        this.fillPropsChanged = true;
        if (this.oglImplNode.isLive()) {
            this.oglImplNode.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.oglImplNode);
        }
    }

    public Appearance getAppearance() {
        return this.oglImplNode;
    }

    public void setTexCoordGenMode(int n, String string) {
        this.texGenMap.put(new Integer(n), string);
        if (this.inSetup) {
            return;
        }
        Integer n2 = (Integer)texGenModeMap.get(string);
        if (n2 != null) {
            TexCoordGeneration texCoordGeneration = new TexCoordGeneration();
            texCoordGeneration.setParameter(8192, 9472, n2.intValue(), null);
            texCoordGeneration.setParameter(8193, 9472, n2.intValue(), null);
            if (this.vfTexture != null && this.vfTexture.getTextureType() == 1) {
                texCoordGeneration.setParameter(8194, 9472, n2.intValue(), null);
            }
            this.stages[n].texCoordGeneration = texCoordGeneration;
            this.changedTexCoordGeneration.put(this.texUnits[n], this.stages[n]);
            if (this.texUnits[n].isLive()) {
                this.texUnits[n].dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.texUnits[n]);
            }
        } else {
            this.stages[n].texCoordGeneration = null;
            this.changedTexCoordGeneration.put(this.texUnits[n], this.stages[n]);
            if (this.texUnits[n].isLive()) {
                this.texUnits[n].dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.texUnits[n]);
            }
        }
    }

    public void setSolid(boolean bl) {
        this.savedSolidState = bl;
        if (this.implPA.isLive()) {
            this.implPA.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implPA);
        }
    }

    public void setLightingEnabled(boolean bl) {
        this.lightingState = bl;
        if (this.vfMaterial != null && !this.lightingOverride) {
            ((OGLMaterialNodeType)this.vfMaterial).setLightingEnable(bl);
        }
    }

    public void setLocalColor(boolean bl, boolean bl2) {
        this.localColor = bl;
        this.localColorAlpha = bl2;
        if (this.vfMaterial != null) {
            ((OGLMaterialNodeType)this.vfMaterial).setLocalColor(bl, bl2);
        }
    }

    public void setCCW(boolean bl) {
        this.savedCCWState = bl;
        if (this.implPA.isLive()) {
            this.implPA.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implPA);
        }
    }

    public void textureTransformChanged(OGLVRMLNode oGLVRMLNode, Matrix4f[] matrix4fArray, boolean[] blArray) {
        int n = matrix4fArray.length;
        this.insureStageSize(n, false);
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            this.changedTransforms.put(this.texUnits[i], this.stages[i]);
            this.stages[i].transform = matrix4fArray[i];
            if (this.texUnits[i].isLive()) {
                this.texUnits[i].dataChanged((NodeUpdateListener)this);
                continue;
            }
            this.updateNodeDataChanges(this.texUnits[i]);
        }
    }

    public void textureImageChanged(int n, VRMLNodeType vRMLNodeType, RenderedImage renderedImage, String string) {
        super.textureImageChanged(n, vRMLNodeType, renderedImage, string);
        if (n < this.numStages && this.vrmlTexs != null) {
            int n2 = this.vfTexture.getTextureType();
            switch (n2) {
                case 0: 
                case 2: {
                    this.texObjs[n] = this.createTexture(this.stages[n], string, this.vrmlTexs[n].getTextureType());
                    this.texUnitsChanged[this.tucIdx].add(this.texUnits[n]);
                    ((OGLTextureNodeType)this.vfTexture).setTexture(n, this.texObjs[n]);
                    this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                    break;
                }
                case 1: {
                    this.texObjs[0] = this.createTexture(this.stages[0], string, n2);
                    this.texUnitsChanged[this.tucIdx].add(this.texUnits[0]);
                    ((OGLTextureNodeType)this.vfTexture).setTexture(0, this.texObjs[0]);
                    this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                }
            }
        } else {
            this.createTextureUnits();
        }
    }

    public void textureImageChanged(int n, VRMLNodeType[] vRMLNodeTypeArray, RenderedImage[] renderedImageArray, String[] stringArray) {
        super.textureImageChanged(n, vRMLNodeTypeArray, renderedImageArray, stringArray);
        if (n <= this.numStages) {
            int n2 = this.vfTexture.getTextureType();
            if (n2 == 1) {
                this.stages[0].mode = this.getMode(renderedImageArray[0], true);
                this.texObjs[0] = this.createTexture(this.stages[0], null, n2);
                this.texUnits[0].setTexture(this.texObjs[0]);
                ((OGLTextureNodeType)this.vfTexture).setTexture(0, this.texObjs[0]);
            } else {
                for (int i = 0; i < n; ++i) {
                    this.stages[i].mode = this.getMode(renderedImageArray[i], i == 0);
                    this.texObjs[i] = this.createTexture(this.stages[i], stringArray[i], this.vrmlTexs[i].getTextureType());
                    this.texUnits[i].setTexture(this.texObjs[i]);
                    ((OGLTextureNodeType)this.vfTexture).setTexture(i, this.texObjs[i]);
                }
            }
        } else {
            this.createTextureUnits();
        }
    }

    public void textureImageChanged(int n, VRMLNodeType vRMLNodeType, Buffer buffer, String string) {
    }

    public void textureImageChanged(int n, VRMLNodeType[] vRMLNodeTypeArray, Buffer[] bufferArray, String[] stringArray) {
    }

    public void textureParamsChanged(int n, int n2, int n3, int n4, float f, float[] fArray) {
        super.textureParamsChanged(n, n2, n3, n4, f, fArray);
    }

    public void textureParamsChanged(int n, int[] nArray, int[] nArray2, int[] nArray3, float f, float[] fArray) {
        super.textureParamsChanged(n, nArray, nArray2, nArray3, f, fArray);
        if (n <= this.numStages) {
            for (int i = 0; i < n; ++i) {
                this.stages[i].mode = nArray[i];
                this.setTextureMode(i, this.stages[i], this.texAttrs[i]);
            }
        } else {
            this.createTextureUnits();
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.oglImplNode;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        OGLMaterialNodeType oGLMaterialNodeType = (OGLMaterialNodeType)this.vfMaterial;
        if (this.vfMaterial != null) {
            oGLMaterialNodeType.setLightingEnable(this.lightingState);
            oGLMaterialNodeType.setLocalColor(this.localColor, this.localColorAlpha);
        }
        Material material = oGLMaterialNodeType == null ? null : oGLMaterialNodeType.getMaterial();
        this.oglImplNode.setMaterial(material);
        if (this.vfLineProperties != null) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfLineProperties;
            LineAttributes lineAttributes = (LineAttributes)oGLVRMLNode.getSceneGraphObject();
            this.oglImplNode.setLineAttributes(lineAttributes);
        }
        this.createTextureTransform();
        this.createTextureUnits();
        this.materialChanged = false;
        this.fillPropsChanged = false;
        this.linePropsChanged = false;
        this.textureUnitsChanged = false;
        this.textureTransformChanged = false;
        this.textureChanged = false;
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            return;
        }
        super.notifyExternProtoLoaded(n, vRMLNodeType);
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        switch (n) {
            case 1: {
                if (this.oglImplNode.isLive()) {
                    this.materialChanged = true;
                    this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                    break;
                }
                Material material = (Material)oGLVRMLNode.getSceneGraphObject();
                this.oglImplNode.setMaterial(material);
                break;
            }
            case 2: {
                this.createTextureUnits();
                break;
            }
            case 3: {
                this.createTextureTransform();
                break;
            }
            case 4: {
                if (this.oglImplNode.isLive()) {
                    this.linePropsChanged = true;
                    this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                    break;
                }
                LineAttributes lineAttributes = (LineAttributes)oGLVRMLNode.getSceneGraphObject();
                this.oglImplNode.setLineAttributes(lineAttributes);
                break;
            }
            case 5: {
                if (!this.oglImplNode.isLive()) break;
                this.fillPropsChanged = true;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            }
        }
    }

    public void updateNodeBoundsChanges(Object object) {
    }

    public void updateNodeDataChanges(Object object) {
        if (object == this.oglImplNode) {
            Object object2;
            OGLMaterialNodeType oGLMaterialNodeType;
            if (this.materialChanged) {
                this.materialChanged = false;
                oGLMaterialNodeType = (OGLMaterialNodeType)this.vfMaterial;
                object2 = oGLMaterialNodeType == null ? null : oGLMaterialNodeType.getMaterial();
                this.oglImplNode.setMaterial((Material)object2);
            }
            if (this.textureChanged) {
                this.textureChanged = false;
                this.createTextureUnits();
            }
            if (this.textureTransformChanged) {
                this.textureTransformChanged = false;
                this.createTextureTransform();
            }
            if (this.textureUnitsChanged) {
                this.textureUnitsChanged = false;
                this.oglImplNode.setTextureUnits(this.texUnits, this.numStages);
            }
            if (this.linePropsChanged) {
                this.linePropsChanged = false;
                oGLMaterialNodeType = null;
                if (this.vfLineProperties != null) {
                    object2 = (OGLVRMLNode)this.vfLineProperties;
                    oGLMaterialNodeType = (LineAttributes)object2.getSceneGraphObject();
                }
                this.oglImplNode.setLineAttributes((LineAttributes)oGLMaterialNodeType);
            }
            if (this.fillPropsChanged) {
                this.fillPropsChanged = false;
            }
        } else if (object == this.implPA) {
            if (this.savedSolidState) {
                this.implPA.setCulledFace(1029);
                this.implPA.setTwoSidedLighting(false);
            } else {
                this.implPA.setCulledFace(0);
                this.implPA.setTwoSidedLighting(true);
            }
            this.implPA.setCCW(this.savedCCWState);
        } else if (object instanceof TextureUnit) {
            TextureStage textureStage;
            if (this.texUnitChanged) {
                int n = this.tucIdx == 0 ? 1 : 0;
                for (int i = 0; i < this.numStages; ++i) {
                    if (this.texUnits[i] != object) continue;
                    this.texUnits[i].setTexture(this.texObjs[i]);
                    break;
                }
                this.texUnitsChanged[n].remove(0);
                if (this.texUnitsChanged[n].size() == 0) {
                    this.texUnitChanged = false;
                }
            }
            if ((textureStage = (TextureStage)this.changedTransforms.get(object)) != null) {
                TextureUnit textureUnit = (TextureUnit)object;
                textureUnit.setTextureTransform((Matrix4f)textureStage.transform);
                this.changedTransforms.remove(object);
            }
            if ((textureStage = (TextureStage)this.changedTexCoordGeneration.get(object)) != null) {
                TextureUnit textureUnit = (TextureUnit)object;
                textureUnit.setTexCoordGeneration((TexCoordGeneration)textureStage.texCoordGeneration);
                this.changedTexCoordGeneration.remove(object);
            }
        }
    }

    private void init() {
        this.lightingState = true;
        this.localColor = false;
        this.localColorAlpha = false;
        this.savedSolidState = true;
        this.savedCCWState = true;
        this.lightingOverride = false;
        this.oglImplNode = new Appearance();
        this.implPA = new PolygonAttributes();
        this.texGenMap = new HashMap(2);
        this.changedTransforms = new HashMap();
        this.changedTexCoordGeneration = new HashMap();
        this.oglImplNode.setPolygonAttributes(this.implPA);
        if (useTextureCache) {
            AVTextureCache aVTextureCache = AVTextureCacheFactory.getCache((int)3);
            this.setTextureCache((TextureCache)aVTextureCache);
        }
        this.listeners = new ArrayList(1);
        this.numStages = 0;
        this.texUnitsChanged = new ArrayList[2];
        this.texUnitsChanged[0] = new ArrayList(1);
        this.texUnitsChanged[1] = new ArrayList(1);
        this.tucIdx = 0;
    }

    private void createTextureUnits() {
        int n;
        this.numStages = 0;
        if (this.vfTexture != null) {
            switch (this.vfTexture.getTextureType()) {
                case 0: {
                    VRMLComposedTextureNodeType vRMLComposedTextureNodeType;
                    ++this.numStages;
                    this.vrmlTexs = new VRMLTextureNodeType[this.numStages];
                    this.modes = new int[this.numStages];
                    this.sources = new int[this.numStages];
                    this.functions = new int[this.numStages];
                    this.vrmlTexs[this.numStages - 1] = this.vfTexture;
                    this.modes[this.numStages - 1] = this.getMode(((VRMLTexture2DNodeType)this.vfTexture).getImage(), true);
                    if (this.modes[this.numStages - 1] != 1) break;
                    Object object = (OGLMaterialNodeType)this.vfMaterial;
                    Material material = vRMLComposedTextureNodeType = object == null ? null : object.getMaterial();
                    if (vRMLComposedTextureNodeType != null && this.vfMaterial.getTransparency() == 0.0f) {
                        vRMLComposedTextureNodeType.setLightingEnabled(false);
                        this.lightingOverride = true;
                        break;
                    }
                    if (vRMLComposedTextureNodeType != null && this.lightingState) {
                        vRMLComposedTextureNodeType.setLightingEnabled(true);
                    }
                    this.lightingOverride = false;
                    break;
                }
                case 2: {
                    Object object = (VRMLMultiTextureNodeType)this.vfTexture;
                    this.numStages += object.getNumberTextures();
                    this.vrmlTexs = new VRMLTextureNodeType[this.numStages];
                    this.modes = new int[this.numStages];
                    this.sources = new int[this.numStages];
                    this.functions = new int[this.numStages];
                    object.getTextures(0, this.vrmlTexs);
                    object.getTextureParams(0, this.modes, this.functions, this.sources);
                    break;
                }
                case 1: {
                    VRMLComposedTextureNodeType vRMLComposedTextureNodeType = (VRMLComposedTextureNodeType)this.vfTexture;
                    this.vrmlTexs = new VRMLTextureNodeType[this.numStages + vRMLComposedTextureNodeType.getNumberTextures()];
                    ++this.numStages;
                    this.modes = new int[this.numStages];
                    this.sources = new int[this.numStages];
                    this.functions = new int[this.numStages];
                    vRMLComposedTextureNodeType.getTextures(0, this.vrmlTexs);
                    this.modes[this.numStages - 1] = 1;
                    break;
                }
                case 4: {
                    ++this.numStages;
                    this.vrmlTexs = new VRMLTextureNodeType[this.numStages];
                    this.modes = new int[this.numStages];
                    this.sources = new int[this.numStages];
                    this.functions = new int[this.numStages];
                    this.vrmlTexs[this.numStages - 1] = this.vfTexture;
                    this.modes[this.numStages - 1] = 1;
                    break;
                }
            }
        }
        this.texObjs = new Texture[this.numStages];
        this.texUnits = new TextureUnit[this.numStages];
        this.texAttrs = new TextureAttributes[this.numStages];
        this.insureStageSize(this.numStages, true);
        for (int i = n = 0; i < this.numStages; ++i) {
            TextureStage textureStage = this.stages[i];
            TexCoordGeneration texCoordGeneration = null;
            boolean bl = false;
            if (this.vfTextureProperties != null) {
                VRMLTextureProperties2DNodeType vRMLTextureProperties2DNodeType = this.vfTextureProperties;
                textureStage.boundaryModeS = vRMLTextureProperties2DNodeType.getBoundaryModeS();
                textureStage.boundaryModeT = vRMLTextureProperties2DNodeType.getBoundaryModeT();
                textureStage.boundaryColor = new float[4];
                vRMLTextureProperties2DNodeType.getBoundaryColor(textureStage.boundaryColor);
                textureStage.minFilter = vRMLTextureProperties2DNodeType.getMinificationFilter();
                textureStage.magFilter = vRMLTextureProperties2DNodeType.getMagnificationFilter();
            }
            textureStage.yUp = this.vrmlTexs[i].getYUp();
            int n2 = this.vrmlTexs[i].getTextureType();
            switch (n2) {
                case 2: {
                    this.errorReporter.warningReport(NESTED_MULTITEXTURE_ERR, null);
                    break;
                }
                case 0: {
                    Object object;
                    n2 = this.vrmlTexs[i].getTextureType();
                    if ((textureStage.images == null || textureStage.images.length == 0) && (object = ((VRMLTexture2DNodeType)this.vrmlTexs[i]).getImage()) != null) {
                        textureStage.images = this.processImage(0, (RenderedImage)object, null);
                    }
                    textureStage.mode = this.modes[i];
                    if (this.vfTextureProperties == null) {
                        object = (VRMLTexture2DNodeType)this.vrmlTexs[i];
                        textureStage.boundaryModeS = object.getRepeatS() ? 0 : 3;
                        int n3 = textureStage.boundaryModeT = object.getRepeatT() ? 0 : 3;
                    }
                    if ((object = (String)this.texGenMap.get(new Integer(n))) == null) break;
                    Object object2 = (Integer)texGenModeMap.get(object);
                    if (object2 != null) {
                        texCoordGeneration = new TexCoordGeneration();
                        texCoordGeneration.setParameter(8192, 9472, ((Integer)object2).intValue(), null);
                        texCoordGeneration.setParameter(8193, 9472, ((Integer)object2).intValue(), null);
                        textureStage.texCoordGeneration = texCoordGeneration;
                        break;
                    }
                    System.out.println("TexCoordGen mode not found: " + object2);
                    textureStage.texCoordGeneration = null;
                    break;
                }
                case 1: {
                    Object object2;
                    textureStage.mode = this.modes[i];
                    if (this.vfTextureProperties != null) {
                        object2 = this.vfTextureProperties;
                    } else {
                        object2 = (VRMLTexture3DNodeType)this.vfTexture;
                        textureStage.boundaryModeS = object2.getRepeatS() ? 0 : 3;
                        textureStage.boundaryModeT = object2.getRepeatT() ? 0 : 3;
                        textureStage.boundaryModeR = object2.getRepeatR() ? 0 : 3;
                        textureStage.depth = object2.getDepth();
                    }
                    Object object = (String)this.texGenMap.get(new Integer(n));
                    if (object == null) break;
                    object2 = (Integer)texGenModeMap.get(object);
                    if (object2 != null) {
                        texCoordGeneration = new TexCoordGeneration();
                        texCoordGeneration.setParameter(8192, 9472, ((Integer)object2).intValue(), null);
                        texCoordGeneration.setParameter(8193, 9472, ((Integer)object2).intValue(), null);
                        texCoordGeneration.setParameter(8194, 9472, ((Integer)object2).intValue(), null);
                        textureStage.texCoordGeneration = texCoordGeneration;
                        break;
                    }
                    System.out.println("TexCoordGen mode not found: " + object2);
                    textureStage.texCoordGeneration = null;
                    break;
                }
                case 4: {
                    bl = true;
                    Object object2 = (OGLVRMLNode)this.vfTexture;
                    this.texObjs[i] = (Texture)object2.getSceneGraphObject();
                    break;
                }
            }
            if (!bl) {
                this.texObjs[i] = this.createTexture(textureStage, this.urls[i], n2);
                ((OGLTextureNodeType)this.vfTexture).setTexture(i, this.texObjs[i]);
            }
            this.texAttrs[i] = this.createTextureAttributes(i, textureStage);
            this.texUnits[i] = new TextureUnit(this.texObjs[i], this.texAttrs[i], texCoordGeneration);
            if (textureStage.transform == null) continue;
            this.texUnits[i].setTextureTransform((Matrix4f)textureStage.transform);
        }
        this.oglImplNode.setTextureUnits(this.texUnits, this.numStages);
    }

    private void createTextureTransform() {
        if (this.vfTextureTransform != null) {
            Matrix4f[] matrix4fArray = ((OGLTextureCoordinateTransformNodeType)this.vfTextureTransform).getTransformMatrix();
            int n = matrix4fArray.length;
            this.insureStageSize(n, false);
            for (int i = 0; i < n; ++i) {
                this.stages[i].transform = matrix4fArray[i];
            }
        }
    }

    private Texture createTexture(TextureStage textureStage, String string, int n) {
        VRMLTextureProperties2DNodeType vRMLTextureProperties2DNodeType;
        Texture texture = null;
        if (useTextureCache && this.cache.checkTexture(string)) {
            try {
                texture = ((AVTextureCache)this.cache).fetchTexture(string);
                Boolean bl = (Boolean)alphaMap.get(texture);
                if (bl == null) {
                    System.out.println("*** No alpha map entry for: " + string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return texture;
        }
        boolean bl = textureStage.images == null || textureStage.images.length < 1 || textureStage.images[0] == null;
        int n2 = 0;
        if (this.vfTextureProperties != null) {
            vRMLTextureProperties2DNodeType = this.vfTextureProperties;
            textureStage.generateMipMaps = vRMLTextureProperties2DNodeType.getGenerateMipMaps();
            textureStage.boundaryModeS = vRMLTextureProperties2DNodeType.getBoundaryModeS();
            textureStage.boundaryModeT = vRMLTextureProperties2DNodeType.getBoundaryModeT();
            textureStage.minFilter = vRMLTextureProperties2DNodeType.getMinificationFilter();
            textureStage.magFilter = vRMLTextureProperties2DNodeType.getMagnificationFilter();
            textureStage.anisotropicMode = vRMLTextureProperties2DNodeType.getAnisotropicMode();
            textureStage.anisotropicDegree = vRMLTextureProperties2DNodeType.getAnisotropicDegree();
        } else {
            switch (n) {
                case 0: {
                    vRMLTextureProperties2DNodeType = (VRMLTexture2DNodeType)this.vrmlTexs[textureStage.stageNumber];
                    textureStage.boundaryModeS = vRMLTextureProperties2DNodeType.getRepeatS() ? 0 : 3;
                    textureStage.boundaryModeT = vRMLTextureProperties2DNodeType.getRepeatT() ? 0 : 3;
                    break;
                }
                case 1: {
                    VRMLTexture3DNodeType vRMLTexture3DNodeType = (VRMLTexture3DNodeType)this.vrmlTexs[textureStage.stageNumber];
                    textureStage.boundaryModeS = vRMLTexture3DNodeType.getRepeatS() ? 0 : 3;
                    textureStage.boundaryModeT = vRMLTexture3DNodeType.getRepeatT() ? 0 : 3;
                    int n3 = textureStage.boundaryModeR = vRMLTexture3DNodeType.getRepeatR() ? 0 : 3;
                }
            }
            if (anisotropicDegree > 1) {
                textureStage.anisotropicMode = 1;
                textureStage.anisotropicDegree = anisotropicDegree;
            }
        }
        boolean bl2 = false;
        try {
            switch (n) {
                case 2: {
                    break;
                }
                case 0: {
                    texture = new Texture2D();
                    int n4 = OGLTextureConstConverter.convertAnisotropicMode(textureStage.anisotropicMode);
                    texture.setAnisotropicFilterMode(n4);
                    texture.setAnisotropicFilterDegree(textureStage.anisotropicDegree);
                    n4 = OGLTextureConstConverter.convertBoundary(textureStage.boundaryModeS);
                    texture.setBoundaryModeS(n4);
                    n4 = OGLTextureConstConverter.convertBoundary(textureStage.boundaryModeT);
                    ((Texture2D)texture).setBoundaryModeT(n4);
                    n4 = OGLTextureConstConverter.convertMinFilter(textureStage.minFilter);
                    texture.setMinFilter(n4);
                    n4 = OGLTextureConstConverter.convertMagFilter(textureStage.magFilter);
                    texture.setMagFilter(n4);
                    if (bl) break;
                    int n5 = this.getFormat(textureStage.images[0]);
                    TextureComponent2D[] textureComponent2DArray = new TextureComponent2D[]{new ImageTextureComponent2D(n5, textureStage.images)};
                    n2 = this.getTextureFormat((TextureComponent)textureComponent2DArray[0]);
                    int n6 = textureStage.images.length;
                    for (int i = 0; i < n6; ++i) {
                        if (textureStage.images[i] instanceof BufferedImage) {
                            ((BufferedImage)textureStage.images[i]).flush();
                        }
                        textureStage.images[i] = null;
                    }
                    textureStage.images = null;
                    if (!textureStage.generateMipMaps && !useMipMaps) {
                        texture.setSources(0, n2, (TextureSource[])textureComponent2DArray, 1);
                    } else {
                        texture.setSources(1, n2, (TextureSource[])textureComponent2DArray, 1);
                    }
                    textureComponent2DArray[0].clearLocalData();
                    break;
                }
                case 1: {
                    int n7;
                    texture = new Texture3D();
                    int n8 = OGLTextureConstConverter.convertAnisotropicMode(textureStage.anisotropicMode);
                    texture.setAnisotropicFilterMode(1);
                    texture.setAnisotropicFilterDegree(textureStage.anisotropicDegree);
                    n8 = OGLTextureConstConverter.convertBoundary(textureStage.boundaryModeS);
                    texture.setBoundaryModeS(n8);
                    n8 = OGLTextureConstConverter.convertBoundary(textureStage.boundaryModeT);
                    ((Texture3D)texture).setBoundaryModeT(n8);
                    n8 = OGLTextureConstConverter.convertBoundary(textureStage.boundaryModeR);
                    ((Texture3D)texture).setBoundaryModeR(n8);
                    n8 = OGLTextureConstConverter.convertMinFilter(textureStage.minFilter);
                    texture.setMinFilter(n8);
                    n8 = OGLTextureConstConverter.convertMagFilter(textureStage.magFilter);
                    texture.setMagFilter(n8);
                    if (textureStage.images.length < textureStage.depth) {
                        bl = true;
                    }
                    if (!bl) {
                        n7 = this.getFormat(textureStage.images[0]);
                        for (int i = 0; i < textureStage.depth; ++i) {
                            if (textureStage.images[i] == null) {
                                bl = true;
                            }
                            if (this.getFormat(textureStage.images[i]) == n7) continue;
                            bl = true;
                        }
                    }
                    if (bl) break;
                    n7 = this.getFormat(textureStage.images[0]);
                    int n9 = textureStage.images[0].getWidth();
                    int n10 = textureStage.images[0].getHeight();
                    ImageTextureComponent3D[] imageTextureComponent3DArray = new ImageTextureComponent3D[]{new ImageTextureComponent3D(n7, textureStage.images, textureStage.yUp)};
                    for (int i = 0; i < textureStage.depth; ++i) {
                        if (!this.containsAlpha(textureStage.images[i])) continue;
                        bl2 = true;
                    }
                    n2 = this.getTextureFormat((TextureComponent)imageTextureComponent3DArray[0]);
                    texture.setSources(0, n2, (TextureSource[])imageTextureComponent3DArray, 1);
                    textureStage.images = null;
                }
            }
        }
        catch (Exception exception) {
            this.errorReporter.errorReport(TEXTURE_CREATE_FAIL_MSG + string, exception);
            return texture;
        }
        if (useTextureCache && string != null) {
            alphaMap.put(texture, new Boolean(bl2));
            ((AVTextureCache)this.cache).registerTexture(texture, string);
        }
        return texture;
    }

    private TextureAttributes createTextureAttributes(int n, TextureStage textureStage) {
        TextureAttributes textureAttributes = new TextureAttributes();
        this.setTextureMode(n, textureStage, textureAttributes);
        return textureAttributes;
    }

    private void setTextureMode(int n, TextureStage textureStage, TextureAttributes textureAttributes) {
        switch (textureStage.mode) {
            case 1: {
                textureAttributes.setTextureMode(7681);
                break;
            }
            case 0: {
                textureAttributes.setTextureMode(8448);
                break;
            }
            case 2: {
                textureAttributes.setTextureMode(8448);
                textureAttributes.setCombineScale(false, 2.0f);
                break;
            }
            case 3: {
                textureAttributes.setTextureMode(8448);
                textureAttributes.setCombineScale(false, 4.0f);
                break;
            }
            case 18: {
                textureAttributes.setTextureMode(34160);
                textureAttributes.setCombineMode(false, 34478);
                textureAttributes.setCombineMode(true, 7681);
                textureAttributes.setCombineSource(false, 0, 5890);
                break;
            }
            case 4: {
                textureAttributes.setTextureMode(34160);
                textureAttributes.setCombineMode(false, 260);
                textureAttributes.setCombineMode(true, 7681);
                break;
            }
            case 5: {
                textureAttributes.setTextureMode(34160);
                textureAttributes.setCombineMode(false, 34164);
                break;
            }
            case 6: {
                textureAttributes.setTextureMode(34160);
                textureAttributes.setCombineMode(false, 34164);
                textureAttributes.setCombineScale(false, 2.0f);
                break;
            }
            case 7: {
                textureAttributes.setTextureMode(34160);
                textureAttributes.setCombineMode(false, 34023);
                break;
            }
            case 15: {
                if (this.texObjs[n] == null) break;
                this.texUnits[n].setTexture(null);
                break;
            }
            default: {
                System.out.println("Unknown TextureConstants.Mode: " + textureStage.mode);
            }
        }
    }

    protected int getTextureFormat(TextureComponent textureComponent) {
        int n = 6407;
        switch (textureComponent.getFormat(0)) {
            case 6: {
                n = 32841;
                break;
            }
            case 5: {
                n = 6410;
                break;
            }
            case 1: {
                n = 6407;
                break;
            }
            case 2: {
                n = 6408;
            }
        }
        return n;
    }

    protected int getFormat(RenderedImage renderedImage) {
        int n = 0;
        if (renderedImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)renderedImage;
            boolean bl = false;
            ColorModel colorModel = bufferedImage.getColorModel();
            bl = colorModel.hasAlpha();
            switch (bufferedImage.getType()) {
                case 1: 
                case 4: 
                case 5: 
                case 12: {
                    n = 1;
                    break;
                }
                case 0: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    n = 2;
                    break;
                }
                case 10: 
                case 11: {
                    n = 6;
                    break;
                }
                case 13: {
                    if (bl) {
                        n = 2;
                        break;
                    }
                    n = 1;
                    break;
                }
                default: {
                    System.out.println("Unknown FORMAT for image: " + bufferedImage);
                    break;
                }
            }
        } else {
            System.out.println("RenderedImage assumed to be RGBA");
            n = 2;
        }
        return n;
    }

    protected boolean containsAlpha(RenderedImage renderedImage) {
        boolean bl = false;
        if (renderedImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)renderedImage;
            ColorModel colorModel = bufferedImage.getColorModel();
            bl = colorModel.hasAlpha();
        } else if (renderedImage instanceof RenderedImage) {
            System.out.println("RenderedImage assumed to be RGBA");
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private int getMode(RenderedImage renderedImage, boolean bl) {
        int n;
        if (renderedImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)renderedImage;
            switch (bufferedImage.getType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: {
                    n = 0;
                    bl = true;
                    break;
                }
                case 10: 
                case 11: {
                    n = 0;
                    break;
                }
                default: {
                    System.out.println("Unknown FORMAT for image: " + bufferedImage);
                    n = 0;
                    bl = true;
                    break;
                }
            }
        } else if (renderedImage instanceof RenderedImage) {
            System.out.println("RenderedImage assumed to be RGBA");
            n = 0;
            bl = true;
        } else {
            n = 0;
            bl = true;
        }
        if (bl && this.vfMaterial != null) {
            this.vfMaterial.setIgnoreDiffuse(bl);
        }
        return n;
    }

    static {
        texGenModeMap.put("SPHERE", new Integer(9218));
        texGenModeMap.put("CAMERASPACENORMAL", new Integer(34065));
        texGenModeMap.put("CAMERASPACEREFLECTIONVECTOR", new Integer(34066));
        texGenModeMap.put("CAMERASPACEPOSITION", new Integer(9216));
    }
}

