/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.shape;

import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.PickableObject;
import org.j3d.aviatrix3d.PolygonAttributes;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.SharedNode;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.MaterialColorListener;
import org.web3d.vrml.nodes.VRMLAppearanceNodeType;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.shape.BaseShape;
import org.web3d.vrml.renderer.ogl.nodes.OGLAppearanceNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLGeometryNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLPickableTargetNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLPickingFlagConvertor;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;

public class OGLShape
extends BaseShape
implements OGLVRMLNode,
OGLPickableTargetNodeType,
NodeUpdateListener,
MaterialColorListener {
    private SharedNode implSN;
    private Shape3D impl;
    private Appearance proxyAppearance;
    private PolygonAttributes proxyPolyAttr;
    private boolean geomExternLoaded;
    private boolean appExternLoaded;
    private boolean checkMaterialListener = false;

    public OGLShape() {
    }

    public OGLShape(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public void setTypeConvertor(OGLPickingFlagConvertor oGLPickingFlagConvertor) {
    }

    public PickableObject getPickableObject() {
        return this.impl;
    }

    public void updateNodeBoundsChanges(Object object) {
        Geometry geometry = null;
        if (this.vfGeometry != null) {
            OGLGeometryNodeType oGLGeometryNodeType = (OGLGeometryNodeType)this.vfGeometry;
            geometry = oGLGeometryNodeType.getGeometry();
        }
        this.impl.setGeometry(geometry);
    }

    public void updateNodeDataChanges(Object object) {
        if (object == this.impl) {
            Appearance appearance = null;
            if (this.vfAppearance != null) {
                OGLAppearanceNodeType oGLAppearanceNodeType = (OGLAppearanceNodeType)this.vfAppearance;
                appearance = oGLAppearanceNodeType.getAppearance();
            } else {
                appearance = this.proxyAppearance;
            }
            this.impl.setAppearance(appearance);
        } else if (object == this.proxyPolyAttr) {
            boolean bl = true;
            boolean bl2 = true;
            if (this.vfGeometry != null) {
                bl = this.vfGeometry.isSolid();
                bl2 = this.vfGeometry.isCCW();
            }
            if (bl) {
                this.proxyPolyAttr.setCulledFace(1029);
                this.proxyPolyAttr.setTwoSidedLighting(false);
            } else {
                this.proxyPolyAttr.setCulledFace(0);
                this.proxyPolyAttr.setTwoSidedLighting(true);
            }
            this.proxyPolyAttr.setCCW(bl2);
        }
    }

    public void emissiveColorChanged(float[] fArray) {
        if (this.vfGeometry != null) {
            ((VRMLComponentGeometryNodeType)this.vfGeometry).setUnlitColor(fArray);
        }
    }

    public void allEventsComplete() {
        if (this.checkMaterialListener && this.vfAppearance != null && this.vfGeometry instanceof VRMLComponentGeometryNodeType && ((VRMLComponentGeometryNodeType)this.vfGeometry).requiresUnlitColor()) {
            this.vfAppearance.addMaterialColorListener((MaterialColorListener)this);
            this.checkMaterialListener = false;
        }
        if (this.geomExternLoaded) {
            if (this.impl.isLive()) {
                this.impl.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.impl);
            }
        }
        if (this.appExternLoaded) {
            if (this.impl.isLive()) {
                this.impl.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.impl);
            }
        }
    }

    public void setAppearance(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (!(vRMLNodeType instanceof OGLAppearanceNodeType) && !(vRMLNodeType instanceof VRMLProtoInstance)) {
            throw new InvalidFieldValueException("Node does not describe a Appearance object");
        }
        if (this.vfAppearance != null && this.vfGeometry instanceof VRMLComponentGeometryNodeType && ((VRMLComponentGeometryNodeType)this.vfGeometry).requiresUnlitColor()) {
            this.vfAppearance.removeMaterialColorListener((MaterialColorListener)this);
        }
        super.setAppearance(vRMLNodeType);
        this.checkForProxy();
        if (this.impl != null) {
            if (this.impl.isLive()) {
                this.impl.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.impl);
            }
        }
        if (!this.inSetup) {
            this.checkMaterialListener = true;
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    public void setGeometry(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType != null && !(vRMLNodeType instanceof OGLGeometryNodeType) && !(vRMLNodeType instanceof VRMLProtoInstance)) {
            throw new InvalidFieldValueException("Node does not describe a Geometry object");
        }
        if (this.vfAppearance != null && this.vfGeometry instanceof VRMLComponentGeometryNodeType && ((VRMLComponentGeometryNodeType)this.vfGeometry).requiresUnlitColor()) {
            this.vfAppearance.removeMaterialColorListener((MaterialColorListener)this);
        }
        super.setGeometry(vRMLNodeType);
        if (this.impl != null) {
            if (this.impl.isLive()) {
                this.impl.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.impl);
            }
        }
        if (!this.inSetup) {
            this.checkMaterialListener = true;
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            return;
        }
        boolean bl = false;
        switch (n) {
            case 2: {
                int n2 = vRMLNodeType.getPrimaryType();
                switch (n2) {
                    case 21: 
                    case 58: {
                        this.vfGeometry = (OGLGeometryNodeType)vRMLNodeType;
                        bl = true;
                        break;
                    }
                    case 38: {
                        int[] nArray = vRMLNodeType.getSecondaryType();
                        for (int i = 0; i < nArray.length; ++i) {
                            if (nArray[i] != 21 && nArray[i] != 58) continue;
                            bl = true;
                            break;
                        }
                        this.pGeometry = (VRMLProtoInstance)vRMLNodeType;
                        this.vfGeometry = (VRMLGeometryNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                    }
                }
                if (!bl) {
                    throw new InvalidFieldValueException("Proto does not describe a Geometry object");
                }
                if (this.impl.isLive()) {
                    this.geomExternLoaded = true;
                } else {
                    this.updateNodeBoundsChanges(this.impl);
                }
                this.checkMaterialListener = true;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                break;
            }
            case 1: {
                int n3 = vRMLNodeType.getPrimaryType();
                switch (n3) {
                    case 2: {
                        bl = true;
                        break;
                    }
                    case 38: {
                        int[] nArray = vRMLNodeType.getSecondaryType();
                        for (int i = 0; i < nArray.length; ++i) {
                            if (nArray[i] != 2) continue;
                            bl = true;
                            break;
                        }
                        this.pAppearance = (VRMLProtoInstance)vRMLNodeType;
                        this.vfAppearance = (VRMLAppearanceNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                    }
                }
                if (!bl) {
                    throw new InvalidFieldValueException("Proto does not describe a Appearance object");
                }
                if (this.impl.isLive()) {
                    this.appExternLoaded = true;
                } else {
                    this.updateNodeBoundsChanges(this);
                }
                this.checkMaterialListener = true;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                break;
            }
            default: {
                System.out.println("OGLShape: Unknown field for notifyExternProtoLoaded");
            }
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implSN;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.impl = new Shape3D();
        if (this.vfBboxSize[0] != -1.0f && this.vfBboxSize[1] != -1.0f && this.vfBboxSize[2] != -1.0f) {
            float[] fArray = new float[]{this.vfBboxCenter[0] - this.vfBboxSize[0] / 2.0f, this.vfBboxCenter[1] - this.vfBboxSize[1] / 2.0f, this.vfBboxCenter[2] - this.vfBboxSize[2] / 2.0f};
            float[] fArray2 = new float[]{this.vfBboxCenter[0] + this.vfBboxSize[0] / 2.0f, this.vfBboxCenter[1] + this.vfBboxSize[1] / 2.0f, this.vfBboxCenter[2] + this.vfBboxSize[2] / 2.0f};
            BoundingBox boundingBox = new BoundingBox(fArray, fArray2);
            this.impl.setBounds((BoundingVolume)boundingBox);
        }
        this.implSN = new SharedNode();
        this.implSN.setChild((Node)this.impl);
        this.createGeometry();
        this.createAppearance();
        if (this.vfAppearance != null && this.vfGeometry instanceof VRMLComponentGeometryNodeType && ((VRMLComponentGeometryNodeType)this.vfGeometry).requiresUnlitColor()) {
            this.vfAppearance.addMaterialColorListener((MaterialColorListener)this);
            this.checkMaterialListener = false;
        }
    }

    private void createAppearance() {
        OGLAppearanceNodeType oGLAppearanceNodeType = (OGLAppearanceNodeType)this.vfAppearance;
        if (oGLAppearanceNodeType == null) {
            this.checkForProxy();
            this.impl.setAppearance(this.proxyAppearance);
            return;
        }
        if (this.vfGeometry != null) {
            OGLGeometryNodeType oGLGeometryNodeType = (OGLGeometryNodeType)this.vfGeometry;
            int n = oGLGeometryNodeType.getNumSets();
            for (int i = 0; i < n; ++i) {
                String string = oGLGeometryNodeType.getTexCoordGenMode(i);
                if (string == null) continue;
                oGLAppearanceNodeType.setTexCoordGenMode(i, string);
            }
        }
        this.impl.setAppearance(oGLAppearanceNodeType.getAppearance());
    }

    private void createGeometry() {
        OGLGeometryNodeType oGLGeometryNodeType = (OGLGeometryNodeType)this.vfGeometry;
        if (oGLGeometryNodeType == null) {
            this.impl.setGeometry(null);
            return;
        }
        Geometry geometry = oGLGeometryNodeType.getGeometry();
        if (geometry != null) {
            this.impl.setGeometry(geometry);
        }
    }

    private void checkForProxy() {
        if (this.vfAppearance == null) {
            this.proxyPolyAttr = new PolygonAttributes();
            this.proxyAppearance = new Appearance();
            this.proxyAppearance.setPolygonAttributes(this.proxyPolyAttr);
            boolean bl = true;
            boolean bl2 = true;
            if (this.vfGeometry != null) {
                bl = this.vfGeometry.isSolid();
                bl2 = this.vfGeometry.isCCW();
            }
            if (bl) {
                this.proxyPolyAttr.setCulledFace(1029);
                this.proxyPolyAttr.setTwoSidedLighting(false);
            } else {
                this.proxyPolyAttr.setCulledFace(0);
                this.proxyPolyAttr.setTwoSidedLighting(true);
            }
            this.proxyPolyAttr.setCCW(bl2);
        }
    }
}

