/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.texture;

import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Texture;
import org.j3d.renderer.aviatrix3d.texture.AVTextureCache;
import org.j3d.renderer.aviatrix3d.texture.AVTextureCacheFactory;
import org.j3d.util.ImageUtils;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.texture.BaseImageTexture;
import org.web3d.vrml.renderer.ogl.nodes.OGLTextureNodeType;

public class OGLImageTexture
extends BaseImageTexture
implements OGLTextureNodeType {
    private static AVTextureCache cache = AVTextureCacheFactory.getCache((int)3);
    private Texture texture;

    public OGLImageTexture() {
    }

    public OGLImageTexture(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public void setUrl(String[] stringArray, int n) {
        super.setUrl(stringArray, n);
        if (n == 0 && !this.inSetup) {
            this.fireTextureImageChanged(0, this, null, null);
        }
    }

    public void setContent(String string, Object object) throws IllegalArgumentException {
        if (object == null) {
            return;
        }
        if (cache.checkTexture(this.loadedURI)) {
            this.fireTextureImageChanged(0, this, null, this.loadedURI);
            return;
        }
        if (object instanceof BufferedImage) {
            this.implImage = (BufferedImage)object;
        } else if (object instanceof ImageProducer) {
            this.implImage = ImageUtils.createBufferedImage((ImageProducer)object);
            if (this.implImage == null) {
                System.out.println("Failed to create buffered image for: " + this.loadedURI);
                this.fireTextureImageChanged(0, this, null, null);
                return;
            }
        } else {
            System.out.println("Unknown content type: " + object + " URL: " + this.loadedURI);
            this.fireTextureImageChanged(0, this, null, null);
            return;
        }
        this.fireTextureImageChanged(0, this, this.implImage, this.loadedURI);
        this.implImage = null;
        this.loadState = 3;
        this.fireContentStateChanged();
    }

    public String getCacheString(int n) {
        return this.loadedURI;
    }

    public void setTexture(int n, Texture texture) {
        this.texture = texture;
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.texture;
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        super.setValue(n, stringArray, n2);
        if (n2 == 0) {
            this.fireTextureImageChanged(0, this, null, null);
        }
    }
}

