/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.texture;

import java.util.ArrayList;
import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.texture.BaseMultiTextureTransform;
import org.web3d.vrml.renderer.ogl.nodes.OGLTextureCoordinateTransformNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLTextureTransformListener;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;

public class OGLMultiTextureTransform
extends BaseMultiTextureTransform
implements OGLTextureCoordinateTransformNodeType,
OGLTextureTransformListener {
    private static final String TX_SEND_ERROR = "There was an exception generation sending a texture transform listener event in OGLMultiTextureTransform";
    private ArrayList listenerList;
    private boolean[] changeFlags;

    public OGLMultiTextureTransform() {
        this.init();
    }

    public OGLMultiTextureTransform(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public SceneGraphObject getSceneGraphObject() {
        return null;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.changeFlags = new boolean[this.vfTextureTransform.size()];
    }

    public void textureTransformChanged(OGLVRMLNode oGLVRMLNode, Matrix4f[] matrix4fArray, boolean[] blArray) {
        this.fireTextureTransformChanged(oGLVRMLNode, this.getTransformMatrix());
    }

    public Matrix4f[] getTransformMatrix() {
        OGLTextureCoordinateTransformNodeType[] oGLTextureCoordinateTransformNodeTypeArray = new OGLTextureCoordinateTransformNodeType[this.vfTextureTransform.size()];
        this.vfTextureTransform.toArray(oGLTextureCoordinateTransformNodeTypeArray);
        Matrix4f[] matrix4fArray = new Matrix4f[oGLTextureCoordinateTransformNodeTypeArray.length];
        for (int i = 0; i < oGLTextureCoordinateTransformNodeTypeArray.length; ++i) {
            Matrix4f[] matrix4fArray2 = oGLTextureCoordinateTransformNodeTypeArray[i].getTransformMatrix();
            matrix4fArray[i] = matrix4fArray2[0];
        }
        return matrix4fArray;
    }

    public void addTransformListener(OGLTextureTransformListener oGLTextureTransformListener) {
        if (!this.listenerList.contains(oGLTextureTransformListener)) {
            this.listenerList.add(oGLTextureTransformListener);
        }
    }

    public void removeTransformListener(OGLTextureTransformListener oGLTextureTransformListener) {
        this.listenerList.remove(oGLTextureTransformListener);
    }

    protected void addTextureTransformNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.addTextureTransformNode(vRMLNodeType);
        ((OGLTextureCoordinateTransformNodeType)vRMLNodeType).addTransformListener(this);
        if (!this.inSetup && this.changeFlags.length < this.vfTextureTransform.size()) {
            this.changeFlags = new boolean[this.vfTextureTransform.size()];
        }
    }

    protected void fireTextureTransformChanged(OGLVRMLNode oGLVRMLNode, Matrix4f[] matrix4fArray) {
        int n = this.vfTextureTransform.indexOf(oGLVRMLNode);
        this.changeFlags[n] = true;
        int n2 = this.listenerList.size();
        for (int i = 0; i < n2; ++i) {
            try {
                OGLTextureTransformListener oGLTextureTransformListener = (OGLTextureTransformListener)this.listenerList.get(i);
                oGLTextureTransformListener.textureTransformChanged(this, matrix4fArray, this.changeFlags);
                continue;
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(TX_SEND_ERROR, exception);
            }
        }
        this.changeFlags[n] = false;
    }

    private void init() {
        this.listenerList = new ArrayList();
    }
}

