/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.texture;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Texture;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.texture.BasePixelTexture;
import org.web3d.vrml.renderer.ogl.nodes.OGLTextureNodeType;

public class OGLPixelTexture
extends BasePixelTexture
implements OGLTextureNodeType {
    private int texHeight;
    private int texWidth;
    private int tcFormat;
    private int texType;
    private Texture texture;

    public OGLPixelTexture() {
    }

    public OGLPixelTexture(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public void setTexture(int n, Texture texture) {
        this.texture = texture;
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.texture;
    }

    protected void processImageData() {
        if (this.vfImage == null) {
            return;
        }
        int n = this.vfImage[0];
        int n2 = this.vfImage[1];
        int n3 = this.vfImage[2];
        boolean bl = false;
        DataBufferInt dataBufferInt = null;
        if (n * n2 != this.vfImageLen - 3) {
            throw new InvalidFieldValueException("Incorrect number of pixels. Expecting " + n * n2 + " and got " + (this.vfImageLen - 3) + ".");
        }
        if (n3 != 0) {
            int[] nArray;
            int n4;
            switch (n3) {
                case 1: {
                    n4 = 10;
                    this.tcFormat = 6;
                    this.texType = 32841;
                    nArray = new int[]{255};
                    break;
                }
                case 2: {
                    n4 = 2;
                    nArray = new int[]{-16777216, 0xFF0000, 65280, 255};
                    bl = true;
                    int n5 = this.vfImageLen - 3;
                    int[] nArray2 = new int[n5];
                    for (int i = 0; i < n5; ++i) {
                        int n6 = this.vfImage[i + 3] & 0xFF00;
                        nArray2[i] = n6 << 16 | n6 << 8 | this.vfImage[i + 3];
                    }
                    dataBufferInt = new DataBufferInt(nArray2, n5, 0);
                    break;
                }
                case 3: {
                    n4 = 1;
                    this.tcFormat = 1;
                    this.texType = 6407;
                    nArray = new int[]{0xFF0000, 65280, 255};
                    break;
                }
                case 4: {
                    n4 = 2;
                    this.tcFormat = 2;
                    this.texType = 6408;
                    nArray = new int[]{-16777216, 0xFF0000, 65280, 255};
                    bl = true;
                    break;
                }
                default: {
                    this.errorReporter.warningReport("PixelTexture Unsupported #components: " + n3, null);
                    this.implImage = null;
                    if (!this.inSetup) {
                        this.fireTextureImageChanged(0, this, null, null);
                    }
                    return;
                }
            }
            if (dataBufferInt == null) {
                dataBufferInt = new DataBufferInt(this.vfImage, this.vfImageLen - 3, 3);
            }
            WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n, n2, n, nArray, null);
            this.implImage = new BufferedImage(n, n2, n4);
            ((BufferedImage)this.implImage).setData(writableRaster);
        } else {
            this.implImage = null;
        }
        if (!this.inSetup) {
            this.fireTextureImageChanged(0, this, this.implImage, null);
        }
    }
}

