/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.texture;

import java.util.ArrayList;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.texture.BaseTextureTransform3D;
import org.web3d.vrml.renderer.ogl.nodes.OGLTextureCoordinateTransformNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLTextureTransformListener;

public class OGLTextureTransform3D
extends BaseTextureTransform3D
implements OGLTextureCoordinateTransformNodeType {
    private static final String TX_SEND_ERROR = "There was an exception generation sending a texture transform listener event in OGLTextureTransform";
    private static final boolean[] UPDATE_FLAGS = new boolean[]{true};
    private Matrix4f oglMatrix;
    private ArrayList listenerList;
    private Vector3f v1;
    private Vector3f v2;
    private Vector3f v3;
    private Matrix4f T;
    private Matrix4f C;
    private Matrix4f R;
    private Matrix4f S;
    private AxisAngle4f al;
    private Matrix4f[] changedTransforms;

    public OGLTextureTransform3D() {
        this.init();
    }

    public OGLTextureTransform3D(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public SceneGraphObject getSceneGraphObject() {
        return null;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.updateTransform();
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        super.setValue(n, f);
        if (!this.inSetup) {
            this.updateTransform();
            this.fireTransformChanged();
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        super.setValue(n, fArray, n2);
        if (!this.inSetup) {
            this.updateTransform();
            this.fireTransformChanged();
        }
    }

    public Matrix4f[] getTransformMatrix() {
        return this.changedTransforms;
    }

    public void addTransformListener(OGLTextureTransformListener oGLTextureTransformListener) {
        if (!this.listenerList.contains(oGLTextureTransformListener)) {
            this.listenerList.add(oGLTextureTransformListener);
        }
    }

    public void removeTransformListener(OGLTextureTransformListener oGLTextureTransformListener) {
        this.listenerList.remove(oGLTextureTransformListener);
    }

    private void updateTransform() {
        this.v1.set(this.vfTranslation[0], this.vfTranslation[1], this.vfTranslation[2]);
        this.T.set(this.v1);
        this.v2.set(this.vfCenter[0], this.vfCenter[1], this.vfCenter[2]);
        this.C.set(this.v2);
        this.al.set(this.vfOrientation);
        this.R.setRotation(this.al);
        this.S.m00 = this.vfScale[0];
        this.S.m11 = this.vfScale[1];
        this.S.m22 = this.vfScale[2];
        this.S.m33 = 1.0f;
        this.oglMatrix.setIdentity();
        this.oglMatrix.mul(this.T);
        this.oglMatrix.mul(this.C);
        this.oglMatrix.mul(this.R);
        this.oglMatrix.mul(this.S);
        this.v2.negate();
        this.C.set(this.v2);
        this.oglMatrix.mul(this.C);
    }

    private void fireTransformChanged() {
        int n = this.listenerList.size();
        for (int i = 0; i < n; ++i) {
            OGLTextureTransformListener oGLTextureTransformListener = (OGLTextureTransformListener)this.listenerList.get(i);
            try {
                if (this.changedTransforms == null) {
                    this.changedTransforms = new Matrix4f[]{this.oglMatrix};
                }
                oGLTextureTransformListener.textureTransformChanged(this, this.changedTransforms, UPDATE_FLAGS);
                continue;
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(TX_SEND_ERROR, exception);
            }
        }
    }

    private void init() {
        this.listenerList = new ArrayList(1);
        this.oglMatrix = new Matrix4f();
        this.changedTransforms = new Matrix4f[1];
        this.changedTransforms[0] = this.oglMatrix;
        this.v1 = new Vector3f();
        this.v2 = new Vector3f();
        this.v3 = new Vector3f();
        this.T = new Matrix4f();
        this.C = new Matrix4f();
        this.R = new Matrix4f();
        this.S = new Matrix4f();
        this.al = new AxisAngle4f();
    }
}

