/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.netcdf;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Vector;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.netcdf.ImcField;
import pt.lsts.neptus.types.coord.LocationType;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;

public class NetcdfTimeSeriesExporter {
    protected LsfIndex index;
    protected Vector<ImcField> scalarsToExport = new Vector();
    protected double startTime;
    protected double endTime;

    public NetcdfTimeSeriesExporter(LsfIndex index, Vector<ImcField> ImcFieldsToExport) {
        this.index = index;
        this.scalarsToExport = ImcFieldsToExport;
        this.startTime = Math.ceil(index.getStartTime());
        this.endTime = Math.floor(index.getEndTime());
    }

    public void export(File outputFile) throws Exception {
        NetcdfFileWriteable file = new NetcdfFileWriteable(outputFile.getAbsolutePath(), true);
        Dimension timeDim = file.addDimension("time", (int)(this.endTime - this.startTime));
        Vector<LocationType> locations = new Vector<LocationType>();
        LinkedHashMap scalars = new LinkedHashMap();
        LinkedHashMap<String, Integer> lsfIndexes = new LinkedHashMap<String, Integer>();
        file.addVariable("latitude", DataType.DOUBLE, new Dimension[]{timeDim});
        file.addVariable("longitude", DataType.DOUBLE, new Dimension[]{timeDim});
        file.addVariable("depth", DataType.DOUBLE, new Dimension[]{timeDim});
        scalars.put("latitude", new Vector());
        scalars.put("longitude", new Vector());
        scalars.put("depth", new Vector());
        file.addVariableAttribute("latitude", "units", "degrees_north");
        file.addVariableAttribute("longitude", "units", "degrees_east");
        file.addVariableAttribute("depth", "units", "meters");
        for (ImcField f : this.scalarsToExport) {
            file.addVariable(f.getVarName(), DataType.DOUBLE, new Dimension[]{timeDim});
            scalars.put(f.getVarName(), new Vector());
            lsfIndexes.put(f.getVarName(), 0);
        }
        for (ImcField f : this.scalarsToExport) {
            if (this.index.getDefinitions().getType(f.getMessage()).getFieldUnits(f.getField()) == null) continue;
            file.addVariableAttribute(f.getVarName(), "units", this.index.getDefinitions().getType(f.getMessage()).getFieldUnits(f.getField()));
        }
        int stateId = this.index.getDefinitions().getMessageId("EstimatedState");
        int curIndex = 0;
        for (double time = this.startTime; time < this.endTime && (curIndex = this.index.getMessageAtOrAfer(stateId, 255, curIndex, time)) != -1; time += 1.0) {
            IMCMessage m = this.index.getMessage(curIndex);
            double lat = Math.toDegrees(m.getDouble("lat"));
            double lon = Math.toDegrees(m.getDouble("lon"));
            LocationType loc = new LocationType(lat, lon);
            loc.translatePosition(m.getDouble("x"), m.getDouble("y"), 0.0);
            locations.add(loc);
            loc.convertToAbsoluteLatLonDepth();
            ((Vector)scalars.get("latitude")).add(loc.getLatitudeDegs());
            ((Vector)scalars.get("longitude")).add(loc.getLongitudeDegs());
            ((Vector)scalars.get("depth")).add(m.getDouble("depth"));
            for (ImcField f : this.scalarsToExport) {
                int idx = this.index.getMessageAtOrAfer(this.index.getDefinitions().getMessageId(f.getMessage()), this.index.getEntityId(f.getEntity()), ((Integer)lsfIndexes.get(f.getVarName())).intValue(), time);
                lsfIndexes.put(f.getVarName(), idx);
                try {
                    if (idx != -1) {
                        ((Vector)scalars.get(f.getVarName())).add(this.index.getMessage(idx).getDouble(f.getField()));
                        continue;
                    }
                    ((Vector)scalars.get(f.getVarName())).add(0.0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        NeptusLog.pub().info((Object)("<###> " + scalars));
    }

    public static void main(String[] args) throws Exception {
        Vector<ImcField> fields = new Vector<ImcField>();
        fields.add(new ImcField("Temperature", "value", "CTD"));
        fields.add(new ImcField("Conductivity", "value", "CTD"));
        fields.add(new ImcField("Salinity", "value", "CTD"));
        LsfIndex index = new LsfIndex(new File("/home/zp/Desktop/logs/20121123/134346_rows_1mps_-3m/Data.lsf"));
        NetcdfTimeSeriesExporter exporter = new NetcdfTimeSeriesExporter(index, fields);
        exporter.export(new File("x.x"));
    }
}

