/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import mil.navy.nps.dis.EntityID;
import mil.navy.nps.dis.EntityStatePdu;

public class AwtEspduSender
extends Applet
implements ActionListener {
    protected static boolean m_fStandAlone = false;
    public static final boolean DEBUG = false;
    public static final String DEFAULT_MCAST = "224.2.181.145";
    public static final String DEFAULT_PORT = "62040";
    public static final String DEFAULT_FREQUENCY = "1";
    public static final String DEFAULT_MARKING = "AUV";
    public static final String DEFAULT_UNICAST_DEST_PORT = "8006";
    public static final String DEFAULT_UNICAST_DEST_ADDR = "localhost";
    public static final String DEFAULT_TIMELIMIT = "1";
    public static final int MAX_PACKET_SIZE = 1500;
    public static final String DATA_LAYOUT = "# EntityXLocation EntityYLocation EntityZLocation velocityX velocityY velocityZ Psi Theta Phi AngVelX AngVelY AngVelZ\n 4   14  1.5 3   0   0   0   -.1 0   0   0   0 \n 7   14  1.75    3   0   .25 0   -.1 0   0   0   0 \n10   14  2   3   0   .25 0   -.1 0   0   0   0 \n13   14  2.25    3   0   .25 0   -.1 0   0   0   0 \n16   14  2.5 3   0   .25 0   -.1 0   0   0   0 \n19   14  2.75    3   0   .25 0   -.1 0   0   0   0 \n22   14  3   3   0   .25 0   -.1 0   0   0   0 \n25   14  3.25    3   0   .25 0   -.1 0   0   0   0 \n28   14  3.5 3   0   .25 0   -.1 0   0   0   0 \n31   14  3.75    3   0   .25 0   -.1 0   0   0   0 \n34   14  4   1   1   .25 0.785   -.1 0   0   0   0 \n35   15  4.25    0   1   .25 1.5708  -.1 0   0   0   0 \n35   16  4.5 0   1   .25 1.5708  -.1 0   0   0   0 \n35   17  4.75    -1  1   .25 2.355   -.1 0   0   0   0 \n34   18  5   -3  0   0   3.1416  .1  0   0   0   0 \n31   18  4.75    -3  0   -.25    3.1416  .1  0   0   0   0 \n28   18  4.5 -3  0   -.25    3.1416  .1  0   0   0   0 \n25   18  4.25    -3  0   -.25    3.1416  .1  0   0   0   0 \n22   18  4   -3  0   -.25    3.1416  .1  0   0   0   0 \n19   18  3.75    -3  0   -.25    3.1416  .1  0   0   0   0 \n16   18  3.5 -3  0   -.25    3.1416  .1  0   0   0   0 \n13   18  3.25    -3  0   -.25    3.1416  .1  0   0   0   0 \n10   18  3   -3  0   -.25    3.1416  .1  0   0   0   0 \n7    18  2.75    -3  0   -.25    3.9221  .1  0   0   0   0 \n4    18  2.5 -1  -1  -.25    4.7124  .1  0   0   0   0 \n3    17  2.25    0   -1  -.25    4.7124  .1  0   0   0   0 \n3    16  2   0   -1  -.25    4.7124  .1  0   0   0   0 \n3    15  1.75    1   -1  -.25    5.497   .1  0   0   0   0 \n";
    public static final int MAX_TRANSMIT_TIME = 432000000;
    public static final short HIGH_BYTE_MASK = -256;
    public static final short LOW_BYTE_MASK = 255;
    protected static boolean sendingPDUs = false;
    protected static TextArea espduData;
    protected static SocketWriteUI socketWriteUI;
    protected static EspduDataUI espduDataUI;
    protected static TextField frequency;
    protected static TextField packetsSent;
    protected static TextField timeLimit;
    protected static Button startButton;
    protected static Button stopButton;
    DatagramSocket socket;
    InetAddress destinationAddress;

    public static void debug(String pDebugMessage) {
    }

    public AwtEspduSender() {
        Panel espduFieldsRegion = new Panel();
        Panel sessionInfoRegion = new Panel();
        Panel coordinateInputRegion = new Panel();
        GridLayout espduFieldsLayout = new GridLayout(5, 2);
        GridLayout sessionInfoLayout = new GridLayout(3, 2);
        GridLayout overallLayout = new GridLayout(4, 1);
        socketWriteUI = new SocketWriteUI();
        espduDataUI = new EspduDataUI();
        sessionInfoRegion.setLayout(sessionInfoLayout);
        sessionInfoRegion.add(new Label("Send Interval (sec):"));
        frequency = new TextField("1", 5);
        sessionInfoRegion.add(frequency);
        sessionInfoRegion.add(new Label("Packets Sent"));
        packetsSent = new TextField("0", 5);
        sessionInfoRegion.add(packetsSent);
        sessionInfoRegion.add(new Label("Time Limit (Hrs)"));
        timeLimit = new TextField("1", 5);
        sessionInfoRegion.add(timeLimit);
        this.add(socketWriteUI);
        this.add(espduDataUI);
        this.add(sessionInfoRegion);
        espduData = new TextArea(10, 70);
        espduData.insert(DATA_LAYOUT, 0);
        espduData.insert("\n", DATA_LAYOUT.length());
        coordinateInputRegion.add(espduData);
        this.add(coordinateInputRegion);
        startButton = new Button("Start");
        startButton.addActionListener(this);
        stopButton = new Button("Stop");
        stopButton.setEnabled(false);
        stopButton.addActionListener(this);
        this.add(startButton);
        this.add(stopButton);
    }

    public static void main(String[] args) {
        AwtEspduSenderFrame frame = new AwtEspduSenderFrame("EspduSender");
        frame.show();
        frame.setVisible(false);
        frame.setSize(frame.getInsets().left + frame.getInsets().right + 520, frame.getInsets().top + frame.getInsets().bottom + 500);
        AwtEspduSender applet_EspduSender = new AwtEspduSender();
        frame.add("Center", applet_EspduSender);
        m_fStandAlone = true;
        applet_EspduSender.init();
        applet_EspduSender.start();
        frame.show();
    }

    public String getAppletInfo() {
        return "Name: AwtEspduSender\r\nAuthor: Don McGregor\r\n";
    }

    public void init() {
        this.setSize(400, 500);
        espduData.setCaretPosition(DATA_LAYOUT.length() + 1);
    }

    public void destroy() {
    }

    public void start() {
    }

    public void stop() {
    }

    public short[] fieldValue(String pFieldString) {
        StringTokenizer tokenizer;
        String dottedDecimal;
        short[] shortArray = new short[4];
        try {
            InetAddress internetAddress = pFieldString.equalsIgnoreCase("localHost") ? InetAddress.getLocalHost() : InetAddress.getByName(pFieldString);
            dottedDecimal = internetAddress.getHostAddress();
        }
        catch (UnknownHostException unkhe) {
            tokenizer = new StringTokenizer(pFieldString, ".");
            dottedDecimal = tokenizer.countTokens() != 4 ? "0.0.0.0" : pFieldString;
        }
        tokenizer = new StringTokenizer(dottedDecimal, ".");
        for (int idx = 0; idx < 4; ++idx) {
            try {
                String token = tokenizer.nextToken();
                shortArray[idx] = Integer.valueOf(token).shortValue();
                continue;
            }
            catch (NumberFormatException nfe) {
                shortArray[idx] = 0;
            }
        }
        return shortArray;
    }

    public void sendPDUs() {
        InetAddress destinationAddress = null;
        long currentTime = System.currentTimeMillis();
        String mcastAddressValue = socketWriteUI.getBeanMcastAddress();
        int portValue = socketWriteUI.getBeanPort();
        int unicastDestPortValue = socketWriteUI.getBeanUnicastDestPort();
        String unicastDestAddrValue = socketWriteUI.getBeanUnicastDestAddress();
        int ttlByteValue = socketWriteUI.getBeanTTL();
        float timeLimitValue = Float.valueOf(timeLimit.getText()).floatValue();
        if (timeLimitValue > 4.32E8f) {
            timeLimitValue = 4.32E8f;
        }
        long endTime = currentTime + (long)((double)timeLimitValue * 60.0 * 60.0 * 1000.0);
        int siteValue = espduDataUI.getBeanSiteID();
        int applicationValue = espduDataUI.getBeanApplicationID();
        int entityValue = espduDataUI.getBeanEntityID();
        String markingValue = espduDataUI.getBeanMarking();
        int exerciseIDValue = espduDataUI.getBeanExerciseID();
        float frequencyValue = Float.valueOf(frequency.getText()).floatValue();
        try {
            boolean usingMulticast;
            if (socketWriteUI.getBeanIsMulticast()) {
                usingMulticast = true;
                this.socket = new MulticastSocket(portValue);
                destinationAddress = InetAddress.getByName(mcastAddressValue);
                ((MulticastSocket)this.socket).joinGroup(destinationAddress);
                ((MulticastSocket)this.socket).setTimeToLive(ttlByteValue);
            } else {
                this.socket = new DatagramSocket(portValue);
                destinationAddress = InetAddress.getByName(unicastDestAddrValue);
                usingMulticast = false;
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        EntityStatePdu espdu = new EntityStatePdu();
        espdu.setMarking(markingValue);
        espdu.setExerciseID(exerciseIDValue);
        EntityID entityIDObject = new EntityID(siteValue, applicationValue, entityValue);
        espdu.setEntityID(entityIDObject);
        EntityStatePdu.setExemplar(espdu);
        String valueString = espduData.getText();
        int totalPacketsSent = 0;
        while (sendingPDUs) {
            currentTime = System.currentTimeMillis();
            if (currentTime > endTime) {
                ActionEvent psuedoStopPress = new ActionEvent(stopButton, 1, "Timeout psuedo-button press");
                this.actionPerformed(psuedoStopPress);
                break;
            }
            espdu = EntityStatePdu.getExemplar();
            StringTokenizer lineTokenizer = new StringTokenizer(valueString, "\r\n");
            while (lineTokenizer.hasMoreTokens() && sendingPDUs) {
                String token;
                float[] pduValues = new float[12];
                int valueCount = 0;
                String lineString = lineTokenizer.nextToken();
                StringTokenizer itemTokenizer = new StringTokenizer(lineString);
                valueCount = 0;
                while (itemTokenizer.hasMoreTokens() && (token = itemTokenizer.nextToken()).indexOf(35) == -1) {
                    float value = Float.valueOf(token).floatValue();
                    if (++valueCount > 12) break;
                    pduValues[valueCount - 1] = value;
                }
                if (valueCount == 0) continue;
                espdu.setEntityLocationX(pduValues[0]);
                espdu.setEntityLocationY(pduValues[1]);
                espdu.setEntityLocationZ(pduValues[2]);
                espdu.setEntityLinearVelocityX(pduValues[3]);
                espdu.setEntityLinearVelocityY(pduValues[4]);
                espdu.setEntityLinearVelocityZ(pduValues[5]);
                espdu.setEntityOrientationPsi(pduValues[6]);
                espdu.setEntityOrientationTheta(pduValues[7]);
                espdu.setEntityOrientationPhi(pduValues[8]);
                espdu.setEntityAngularVelocityY(pduValues[9]);
                espdu.setEntityAngularVelocityX(pduValues[10]);
                espdu.setEntityAngularVelocityZ(pduValues[11]);
                byte[] buffer = new byte[1500];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                espdu.serialize(dos);
                byte[] disData = baos.toByteArray();
                DatagramPacket packet = new DatagramPacket(disData, disData.length, destinationAddress, unicastDestPortValue);
                try {
                    this.socket.send(packet);
                }
                catch (Exception e) {
                    System.out.println(e);
                    e.printStackTrace();
                }
                packetsSent.setText(Integer.toString(++totalPacketsSent));
                System.out.println("sent PDU" + sendingPDUs);
                try {
                    Thread.sleep((int)frequencyValue * 1000);
                }
                catch (InterruptedException ie) {
                    System.out.println("Troubled sleep");
                }
            }
            valueString = espduData.getText();
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        SenderThread sendingThread = new SenderThread(this);
        if (source == startButton) {
            sendingPDUs = true;
            sendingThread.start();
            startButton.setEnabled(false);
            stopButton.setEnabled(true);
        }
        if (source == stopButton) {
            System.out.println("Got stop button press");
            sendingPDUs = false;
            startButton.setEnabled(true);
            stopButton.setEnabled(false);
        }
    }
}

