/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import mil.navy.nps.dis.DatumSpecification;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.dis.SimulationManagementFamily;
import mil.navy.nps.util.UnsignedInt;

public class ActionRequestPdu
extends SimulationManagementFamily {
    protected UnsignedInt requestID = new UnsignedInt();
    protected UnsignedInt actionID = new UnsignedInt();
    protected DatumSpecification datumInformation = new DatumSpecification();
    public static final int sizeOf = 8;
    protected static ActionRequestPdu exemplar;

    public ActionRequestPdu() {
        super.setPduType((short)16);
    }

    public String pduName() {
        return new String("Action Request PDU");
    }

    public void serialize(DataOutputStream outputStream) {
        super.serialize(outputStream);
        this.requestID.serialize(outputStream);
        this.actionID.serialize(outputStream);
        this.datumInformation.serialize(outputStream);
    }

    public void deSerialize(DataInputStream inputStream) {
        super.deSerialize(inputStream);
        this.requestID.deSerialize(inputStream);
        this.actionID.deSerialize(inputStream);
        this.datumInformation.deSerialize(inputStream);
    }

    public Object clone() {
        ActionRequestPdu newPdu = (ActionRequestPdu)super.clone();
        newPdu.setRequestID(this.requestID.longValue());
        newPdu.setActionID(this.actionID.longValue());
        newPdu.setDatumInformation(this.getDatumInformation());
        return newPdu;
    }

    public int length() {
        int currentLength = 0;
        currentLength = super.length() + 8 + this.datumInformation.length();
        return currentLength;
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer buf = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println();
        printStream.println("Action Request PDU");
        if (superclassIndent > 0) {
            --superclassIndent;
        }
        super.printValues(superclassIndent, printStream);
        printStream.println(buf + "requestID: " + this.requestID.longValue());
        printStream.println(buf + "actionID : " + this.actionID.longValue());
        this.datumInformation.printValues(indentLevel, printStream);
    }

    public ActionRequestPdu getExemplar() {
        return (ActionRequestPdu)exemplar.clone();
    }

    public void setExemplar(ActionRequestPdu newExemplar) {
        exemplar = newExemplar;
    }

    public UnsignedInt getRequestID() {
        return (UnsignedInt)this.requestID.clone();
    }

    public void setRequestID(long pRequestID) {
        this.requestID = new UnsignedInt(pRequestID);
    }

    public UnsignedInt getActionID() {
        return (UnsignedInt)this.actionID.clone();
    }

    public void setActionID(long pActionID) {
        this.actionID = new UnsignedInt(pActionID);
    }

    public DatumSpecification getDatumInformation() {
        return (DatumSpecification)this.datumInformation.clone();
    }

    public void setDatumInformation(DatumSpecification pDatumSpecification) {
        this.datumInformation = pDatumSpecification;
    }
}

