/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import mil.navy.nps.dis.DatumSpecification;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.dis.SimulationManagementFamily;
import mil.navy.nps.util.UnsignedInt;

public class ActionResponsePdu
extends SimulationManagementFamily {
    protected UnsignedInt requestID = new UnsignedInt();
    protected UnsignedInt requestStatus = new UnsignedInt();
    protected DatumSpecification datumInformation = new DatumSpecification();
    public static final int sizeOf = 8;
    protected static ActionResponsePdu exemplar;

    public ActionResponsePdu() {
        super.setPduType((short)17);
    }

    public String pduName() {
        return new String("Action Response PDU");
    }

    public void serialize(DataOutputStream outputStream) {
        super.serialize(outputStream);
        this.requestID.serialize(outputStream);
        this.requestStatus.serialize(outputStream);
        this.datumInformation.serialize(outputStream);
    }

    public void deSerialize(DataInputStream inputStream) {
        super.deSerialize(inputStream);
        this.requestID.deSerialize(inputStream);
        this.requestStatus.deSerialize(inputStream);
        this.datumInformation.deSerialize(inputStream);
    }

    public Object clone() {
        ActionResponsePdu newPdu = (ActionResponsePdu)super.clone();
        newPdu.setRequestID(this.requestID.longValue());
        newPdu.setRequestStatus(this.requestStatus.longValue());
        newPdu.setDatumInformation(this.getDatumInformation());
        return newPdu;
    }

    public int length() {
        int currentLength = 0;
        currentLength = super.length() + 8 + this.datumInformation.length();
        return currentLength;
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer buf = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println();
        printStream.println("Action Response PDU");
        if (superclassIndent > 0) {
            --superclassIndent;
        }
        super.printValues(superclassIndent, printStream);
        printStream.println(buf + "requestID     : " + this.requestID.longValue());
        printStream.println(buf + "requestStatus : " + this.requestStatus.longValue());
        this.datumInformation.printValues(indentLevel, printStream);
    }

    public ActionResponsePdu getExemplar() {
        return (ActionResponsePdu)exemplar.clone();
    }

    public void setExemplar(ActionResponsePdu newExemplar) {
        exemplar = newExemplar;
    }

    public UnsignedInt getRequestID() {
        return (UnsignedInt)this.requestID.clone();
    }

    public void setRequestID(long pRequestID) {
        this.requestID = new UnsignedInt(pRequestID);
    }

    public UnsignedInt getRequestStatus() {
        return (UnsignedInt)this.requestStatus.clone();
    }

    public void setRequestStatus(long pRequestStatus) {
        this.requestStatus = new UnsignedInt(pRequestStatus);
    }

    public DatumSpecification getDatumInformation() {
        return (DatumSpecification)this.datumInformation.clone();
    }

    public void setDatumInformation(DatumSpecification pDatumSpecification) {
        this.datumInformation = pDatumSpecification;
    }
}

