/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import mil.navy.nps.dis.EntityCoordinate;
import mil.navy.nps.dis.EntityID;
import mil.navy.nps.dis.EventID;
import mil.navy.nps.dis.LinearVelocity;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.util.UnsignedByte;

public class CollisionPdu
extends ProtocolDataUnit {
    protected EntityID issuingEntityID = new EntityID();
    protected EntityID collidingEntityID = new EntityID();
    protected EventID eventID = new EventID();
    protected UnsignedByte collisionType = new UnsignedByte();
    protected LinearVelocity velocity = new LinearVelocity();
    protected float mass = 0.0f;
    protected EntityCoordinate location = new EntityCoordinate();
    public static final int sizeOf = 60;

    public CollisionPdu() {
        super.setPduType((short)4);
    }

    public Object clone() {
        CollisionPdu newCollisionPdu = (CollisionPdu)super.clone();
        newCollisionPdu.setIssuingEntityID(this.getIssuingEntityID());
        newCollisionPdu.setCollidingEntityID(this.getCollidingEntityID());
        newCollisionPdu.setEventID(this.getEventID());
        newCollisionPdu.setCollisionType(this.getCollisionType());
        newCollisionPdu.setLinearVelocity(this.getLinearVelocity());
        newCollisionPdu.setMass(this.getMass());
        newCollisionPdu.setLocation(this.getLocation());
        return newCollisionPdu;
    }

    public void serialize(DataOutputStream outputStream) {
        UnsignedByte padding = new UnsignedByte(0);
        super.serialize(outputStream);
        this.issuingEntityID.serialize(outputStream);
        this.collidingEntityID.serialize(outputStream);
        this.eventID.serialize(outputStream);
        this.collisionType.serialize(outputStream);
        padding.serialize(outputStream);
        this.velocity.serialize(outputStream);
        try {
            outputStream.writeFloat(this.mass);
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in CollisionPdu. Error writing to wire.");
        }
        this.location.serialize(outputStream);
    }

    public void deSerialize(DataInputStream inputStream) {
        UnsignedByte padding = new UnsignedByte(0);
        super.deSerialize(inputStream);
        this.issuingEntityID.deSerialize(inputStream);
        this.collidingEntityID.deSerialize(inputStream);
        this.eventID.deSerialize(inputStream);
        this.collisionType.deSerialize(inputStream);
        padding.deSerialize(inputStream);
        this.velocity.deSerialize(inputStream);
        try {
            this.mass = inputStream.readFloat();
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in CollisionPdu. Error reading from wire.");
        }
        this.location.deSerialize(inputStream);
    }

    public int length() {
        return 60;
    }

    public String pduName() {
        return new String("Collision PDU");
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println();
        printStream.println("Collision PDU-");
        if (superclassIndent > 0) {
            --superclassIndent;
        }
        super.printValues(superclassIndent, printStream);
        this.issuingEntityID.printValues(indentLevel, printStream);
        this.collidingEntityID.printValues(indentLevel, printStream);
        this.eventID.printValues(indentLevel, printStream);
        printStream.println(indent + "Collision type: " + this.collisionType.intValue());
        this.velocity.printValues(indentLevel, printStream);
        printStream.println(indent + "Mass: " + this.mass);
        this.location.printValues(indentLevel, printStream);
    }

    public EntityID getIssuingEntityID() {
        return (EntityID)this.issuingEntityID.clone();
    }

    public void setIssuingEntityID(EntityID pIssuingEntityID) {
        this.issuingEntityID = pIssuingEntityID;
    }

    public EntityID getCollidingEntityID() {
        return (EntityID)this.collidingEntityID.clone();
    }

    public void setCollidingEntityID(EntityID pCollidingEntityID) {
        this.collidingEntityID = pCollidingEntityID;
    }

    public EventID getEventID() {
        return (EventID)this.eventID.clone();
    }

    public void setEventID(EventID pEventID) {
        this.eventID = pEventID;
    }

    public UnsignedByte getCollisionType() {
        return (UnsignedByte)this.collisionType.clone();
    }

    public void setCollisionType(UnsignedByte pCollisionType) {
        this.collisionType = pCollisionType;
    }

    public LinearVelocity getLinearVelocity() {
        return (LinearVelocity)this.velocity.clone();
    }

    public void setLinearVelocity(LinearVelocity pLinearVelocity) {
        this.velocity = pLinearVelocity;
    }

    public void setLinearVelocity(float x, float y, float z) {
        this.velocity = new LinearVelocity(x, y, z);
    }

    public float getMass() {
        return this.mass;
    }

    public void setMass(float pMass) {
        this.mass = pMass;
    }

    public EntityCoordinate getLocation() {
        return (EntityCoordinate)this.location.clone();
    }

    public void setLocation(EntityCoordinate pLocation) {
        this.location = pLocation;
    }

    public void setLocation(float x, float y, float z) {
        this.location = new EntityCoordinate(x, y, z);
    }
}

