/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import mil.navy.nps.dis.DatumSpecification;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.dis.SimulationManagementFamily;
import mil.navy.nps.util.UnsignedInt;

public class DataPdu
extends SimulationManagementFamily {
    protected UnsignedInt requestID = new UnsignedInt();
    protected DatumSpecification datumInformation = new DatumSpecification();
    public static final int sizeOf = 8;
    protected static DataPdu exemplar;

    public DataPdu() {
        super.setPduType((short)20);
    }

    public String pduName() {
        return new String("Data PDU");
    }

    public void serialize(DataOutputStream outputStream) {
        super.serialize(outputStream);
        this.requestID.serialize(outputStream);
        try {
            outputStream.writeInt(0);
        }
        catch (Exception e) {
            DataPdu.trace("!!! " + e.getMessage());
        }
        this.datumInformation.serialize(outputStream);
    }

    public void deSerialize(DataInputStream inputStream) {
        super.deSerialize(inputStream);
        this.requestID.deSerialize(inputStream);
        try {
            int i = inputStream.readInt();
        }
        catch (Exception e) {
            DataPdu.trace("!!! " + e.getMessage());
        }
        this.datumInformation.deSerialize(inputStream);
    }

    public Object clone() {
        DataPdu newPdu = (DataPdu)super.clone();
        newPdu.setRequestID(this.requestID.longValue());
        newPdu.setDatumInformation(this.getDatumInformation());
        return newPdu;
    }

    public int length() {
        int currentLength = 0;
        currentLength = super.length() + 8 + this.datumInformation.length();
        return currentLength;
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println();
        printStream.println("Data PDU");
        if (superclassIndent > 0) {
            --superclassIndent;
        }
        super.printValues(superclassIndent, printStream);
        printStream.println(indent + "requestID: " + this.requestID.longValue());
        this.datumInformation.printValues(indentLevel, printStream);
    }

    public DataPdu getExemplar() {
        return (DataPdu)exemplar.clone();
    }

    public void setExemplar(DataPdu newExemplar) {
        exemplar = newExemplar;
    }

    public UnsignedInt getRequestID() {
        return (UnsignedInt)this.requestID.clone();
    }

    public void setRequestID(long pRequestID) {
        this.requestID = new UnsignedInt(pRequestID);
    }

    public DatumSpecification getDatumInformation() {
        return this.datumInformation;
    }

    public void setDatumInformation(DatumSpecification pDatumSpecification) {
        this.datumInformation = pDatumSpecification;
    }
}

