/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import mil.navy.nps.dis.FixedDatum;
import mil.navy.nps.dis.PduElement;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.dis.VariableDatum;
import mil.navy.nps.util.UnsignedInt;

public class DatumSpecification
extends PduElement {
    protected Vector fixedDatumList = new Vector();
    protected Vector variableDatumList = new Vector();
    public static final int sizeOf = 8;

    public void serialize(DataOutputStream outputStream) {
        PduElement aDatum;
        UnsignedInt fixedDatumCount = new UnsignedInt(this.fixedDatumList.size());
        UnsignedInt variableDatumCount = new UnsignedInt(this.variableDatumList.size());
        fixedDatumCount.serialize(outputStream);
        variableDatumCount.serialize(outputStream);
        Enumeration listContents = this.fixedDatumList.elements();
        while (listContents.hasMoreElements()) {
            aDatum = (FixedDatum)listContents.nextElement();
            ((FixedDatum)aDatum).serialize(outputStream);
        }
        listContents = this.variableDatumList.elements();
        while (listContents.hasMoreElements()) {
            aDatum = (VariableDatum)listContents.nextElement();
            ((VariableDatum)aDatum).serialize(outputStream);
        }
    }

    public void deSerialize(DataInputStream inputStream) {
        PduElement aDatum;
        int idx = 0;
        UnsignedInt variableDatumCount = new UnsignedInt(0);
        UnsignedInt fixedDatumCount = new UnsignedInt(0);
        fixedDatumCount.deSerialize(inputStream);
        variableDatumCount.deSerialize(inputStream);
        idx = 0;
        while ((long)idx < fixedDatumCount.longValue()) {
            aDatum = new FixedDatum();
            ((FixedDatum)aDatum).deSerialize(inputStream);
            this.fixedDatumList.addElement(aDatum);
            ++idx;
        }
        idx = 0;
        while ((long)idx < variableDatumCount.longValue()) {
            aDatum = new VariableDatum();
            ((VariableDatum)aDatum).deSerialize(inputStream);
            this.variableDatumList.addElement(aDatum);
            ++idx;
        }
    }

    public Object clone() {
        int idx;
        DatumSpecification newDatumSpecification = (DatumSpecification)super.clone();
        int fixedDatumCount = this.fixedDatumList.size();
        for (idx = 0; idx < fixedDatumCount; ++idx) {
            newDatumSpecification.addFixedDatum(this.fixedDatumAt(idx));
        }
        int variableDatumCount = this.variableDatumList.size();
        for (idx = 0; idx < variableDatumCount; ++idx) {
            newDatumSpecification.addVariableDatum(this.variableDatumAt(idx));
        }
        return newDatumSpecification;
    }

    public int length() {
        int currentLength = 0;
        currentLength = 8 + this.fixedDatumList.size() * 8;
        Enumeration datumEnum = this.variableDatumList.elements();
        while (datumEnum.hasMoreElements()) {
            VariableDatum aDatum = (VariableDatum)datumEnum.nextElement();
            currentLength += aDatum.length();
        }
        return currentLength;
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        PduElement aDatum;
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println(indent + "fixedDatumCount   : " + this.fixedDatumList.size());
        printStream.println(indent + "variableDatumCount: " + this.variableDatumList.size());
        int idx = 1;
        Enumeration datumEnum = this.fixedDatumList.elements();
        while (datumEnum.hasMoreElements()) {
            printStream.println(indent + "FixedDatum: " + idx++);
            aDatum = (FixedDatum)datumEnum.nextElement();
            ((FixedDatum)aDatum).printValues(indentLevel + 4, printStream);
        }
        idx = 1;
        datumEnum = this.variableDatumList.elements();
        while (datumEnum.hasMoreElements()) {
            printStream.println(indent + "VariableDatum: " + idx++);
            aDatum = (VariableDatum)datumEnum.nextElement();
            ((VariableDatum)aDatum).printValues(indentLevel + 4, printStream);
        }
    }

    public int getFixedDatumCount() {
        return this.fixedDatumList.size();
    }

    public int getVariableDatumCount() {
        return this.variableDatumList.size();
    }

    public void addFixedDatum(FixedDatum pDatum) {
        this.fixedDatumList.addElement(pDatum);
    }

    public FixedDatum fixedDatumAt(int pIdx) {
        FixedDatum aDatum = (FixedDatum)this.fixedDatumList.elementAt(pIdx);
        return (FixedDatum)aDatum.clone();
    }

    public void dropFixedDatum() {
        this.fixedDatumList = new Vector();
    }

    public void addVariableDatum(VariableDatum pDatum) {
        this.variableDatumList.addElement(pDatum);
    }

    public VariableDatum variableDatumAt(int pIdx) {
        VariableDatum aDatum = (VariableDatum)this.variableDatumList.elementAt(pIdx);
        return (VariableDatum)aDatum.clone();
    }

    public void dropVariableDatum() {
        this.variableDatumList = new Vector();
    }
}

