/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import mil.navy.nps.dis.ArticulationParameter;
import mil.navy.nps.dis.BurstDescriptor;
import mil.navy.nps.dis.EntityCoordinate;
import mil.navy.nps.dis.EntityID;
import mil.navy.nps.dis.EventID;
import mil.navy.nps.dis.LinearVelocity;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.dis.WorldCoordinate;
import mil.navy.nps.util.UnsignedByte;
import mil.navy.nps.util.UnsignedShort;

public class DetonationPdu
extends ProtocolDataUnit {
    protected EntityID firingEntityID = new EntityID();
    protected EntityID targetEntityID = new EntityID();
    protected EntityID munitionID = new EntityID();
    protected EventID eventID = new EventID();
    protected LinearVelocity velocity = new LinearVelocity(0.0f, 0.0f, 0.0f);
    protected WorldCoordinate locationInWorldCoordinate = new WorldCoordinate(0.0, 0.0, 0.0);
    protected BurstDescriptor burstDescription = new BurstDescriptor();
    protected EntityCoordinate locationInEntityCoordinates = new EntityCoordinate(0.0f, 0.0f, 0.0f);
    protected UnsignedByte detonationResult = new UnsignedByte(0);
    protected Vector articulationParameters = new Vector();
    public static final int sizeOf = 104;

    public DetonationPdu() {
        super.setPduType((short)3);
    }

    public Object clone() {
        DetonationPdu newDetonationPdu = (DetonationPdu)super.clone();
        int idx = 0;
        newDetonationPdu.setFiringEntityID(this.getFiringEntityID());
        newDetonationPdu.setTargetEntityID(this.getTargetEntityID());
        newDetonationPdu.setMunitionID(this.getMunitionID());
        newDetonationPdu.setEventID(this.getEventID());
        newDetonationPdu.setVelocity(this.getVelocity());
        newDetonationPdu.setLocationInWorldCoordinate(this.getLocationInWorldCoordinate());
        newDetonationPdu.setBurstDescription(this.getBurstDescription());
        newDetonationPdu.setDetonationResult(this.getDetonationResult());
        for (idx = 0; idx < this.articulationParameters.size(); ++idx) {
            newDetonationPdu.addArticulationParameter(this.getArticulationParameterAt(idx));
        }
        return newDetonationPdu;
    }

    public void serialize(DataOutputStream outputStream) {
        UnsignedShort padding = new UnsignedShort(0);
        super.serialize(outputStream);
        this.firingEntityID.serialize(outputStream);
        this.targetEntityID.serialize(outputStream);
        this.munitionID.serialize(outputStream);
        this.eventID.serialize(outputStream);
        this.velocity.serialize(outputStream);
        this.locationInWorldCoordinate.serialize(outputStream);
        this.burstDescription.serialize(outputStream);
        this.locationInEntityCoordinates.serialize(outputStream);
        this.detonationResult.serialize(outputStream);
        UnsignedByte parameterCount = new UnsignedByte(this.articulationParameters.size());
        parameterCount.serialize(outputStream);
        padding.serialize(outputStream);
        for (int idx = 0; idx < this.articulationParameters.size(); ++idx) {
            ArticulationParameter aParameter = (ArticulationParameter)this.articulationParameters.elementAt(idx);
            aParameter.serialize(outputStream);
        }
    }

    public void deSerialize(DataInputStream inputStream) {
        int idx = 0;
        UnsignedByte articulationParameterCount = new UnsignedByte();
        UnsignedShort padding = new UnsignedShort(0);
        super.deSerialize(inputStream);
        this.firingEntityID.deSerialize(inputStream);
        this.targetEntityID.deSerialize(inputStream);
        this.munitionID.deSerialize(inputStream);
        this.eventID.deSerialize(inputStream);
        this.velocity.deSerialize(inputStream);
        this.locationInWorldCoordinate.deSerialize(inputStream);
        this.burstDescription.deSerialize(inputStream);
        this.locationInEntityCoordinates.deSerialize(inputStream);
        this.detonationResult.deSerialize(inputStream);
        articulationParameterCount.deSerialize(inputStream);
        padding.deSerialize(inputStream);
        for (idx = 0; idx < articulationParameterCount.intValue(); ++idx) {
            ArticulationParameter aParameter = new ArticulationParameter();
            aParameter.deSerialize(inputStream);
            this.articulationParameters.addElement(aParameter);
        }
    }

    public int length() {
        return 104 + this.articulationParameters.size() * 16;
    }

    public String pduName() {
        return new String("Detonation PDU");
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println();
        printStream.println("Detonation PDU-");
        if (superclassIndent > 0) {
            --superclassIndent;
        }
        super.printValues(superclassIndent, printStream);
        this.firingEntityID.printValues(indentLevel, printStream);
        this.targetEntityID.printValues(indentLevel, printStream);
        this.munitionID.printValues(indentLevel, printStream);
        this.eventID.printValues(indentLevel, printStream);
        this.velocity.printValues(indentLevel, printStream);
        this.locationInWorldCoordinate.printValues(indentLevel, printStream);
        this.burstDescription.printValues(indentLevel, printStream);
        this.locationInEntityCoordinates.printValues(indentLevel, printStream);
        printStream.println(indent + "detonationResult: " + this.detonationResult.intValue());
        printStream.println(indent + "Parameter count: " + this.articulationParameters.size());
        for (int idx = 0; idx < this.articulationParameters.size(); ++idx) {
            ArticulationParameter aParam = (ArticulationParameter)this.articulationParameters.elementAt(idx);
            aParam.printValues(indentLevel + 4, printStream);
        }
    }

    public ArticulationParameter getArticulationParameterAt(int pIdx) {
        ArticulationParameter aParameter = (ArticulationParameter)this.articulationParameters.elementAt(pIdx);
        return (ArticulationParameter)aParameter.clone();
    }

    public void addArticulationParameter(ArticulationParameter pParameter) {
        this.articulationParameters.addElement(pParameter);
    }

    public EntityID getFiringEntityID() {
        return (EntityID)this.firingEntityID.clone();
    }

    public void setFiringEntityID(EntityID pFiringEntityID) {
        this.firingEntityID = pFiringEntityID;
    }

    public EntityID getTargetEntityID() {
        return (EntityID)this.targetEntityID.clone();
    }

    public void setTargetEntityID(EntityID pTargetEntityID) {
        this.targetEntityID = pTargetEntityID;
    }

    public EntityID getMunitionID() {
        return (EntityID)this.munitionID.clone();
    }

    public void setMunitionID(EntityID pMunitionID) {
        this.munitionID = pMunitionID;
    }

    public EventID getEventID() {
        return (EventID)this.eventID.clone();
    }

    public void setEventID(EventID pEventID) {
        this.eventID = pEventID;
    }

    public LinearVelocity getVelocity() {
        return (LinearVelocity)this.velocity.clone();
    }

    public void setVelocity(LinearVelocity pVelocity) {
        this.velocity = pVelocity;
    }

    public void setVelocity(float x, float y, float z) {
        this.velocity = new LinearVelocity(x, y, z);
    }

    public WorldCoordinate getLocationInWorldCoordinate() {
        return (WorldCoordinate)this.locationInWorldCoordinate.clone();
    }

    public void setLocationInWorldCoordinate(WorldCoordinate pLocation) {
        this.locationInWorldCoordinate = pLocation;
    }

    public void setLocationInWorldCoordinate(double x, double y, double z) {
        this.locationInWorldCoordinate = new WorldCoordinate(x, y, z);
    }

    public BurstDescriptor getBurstDescription() {
        return (BurstDescriptor)this.burstDescription.clone();
    }

    public void setBurstDescription(BurstDescriptor pBurstDescription) {
        this.burstDescription = pBurstDescription;
    }

    public EntityCoordinate getLocationInEntityCoordinates() {
        return (EntityCoordinate)this.locationInEntityCoordinates.clone();
    }

    public void setLocationInEntityCoordinates(EntityCoordinate pLocationInEntityCoordinates) {
        this.locationInEntityCoordinates = pLocationInEntityCoordinates;
    }

    public void setLocationInEntityCoordinates(float x, float y, float z) {
        this.locationInEntityCoordinates = new EntityCoordinate(x, y, z);
    }

    public UnsignedByte getDetonationResult() {
        return (UnsignedByte)this.detonationResult.clone();
    }

    public void setDetonationResult(UnsignedByte pDetonationResult) {
        this.detonationResult = pDetonationResult;
    }

    public void setDetonationResult(int pDetonationResult) {
        this.detonationResult = new UnsignedByte(pDetonationResult);
    }
}

