/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import mil.navy.nps.dis.DatumSpecification;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.dis.SimulationManagementFamily;
import mil.navy.nps.util.UnsignedInt;

public class EventReportPdu
extends SimulationManagementFamily {
    protected UnsignedInt eventType = new UnsignedInt();
    protected DatumSpecification datumInformation = new DatumSpecification();
    public static final int sizeOf = 8;
    protected static EventReportPdu exemplar;

    public EventReportPdu() {
        super.setPduType((short)21);
    }

    public String pduName() {
        return new String("Event Report PDU");
    }

    public void serialize(DataOutputStream outputStream) {
        super.serialize(outputStream);
        this.eventType.serialize(outputStream);
        try {
            outputStream.writeInt(0);
        }
        catch (Exception e) {
            EventReportPdu.trace(e.getMessage());
        }
        this.datumInformation.serialize(outputStream);
    }

    public void deSerialize(DataInputStream inputStream) {
        super.deSerialize(inputStream);
        this.eventType.deSerialize(inputStream);
        try {
            int i = inputStream.readInt();
        }
        catch (Exception e) {
            EventReportPdu.trace(e.getMessage());
        }
        this.datumInformation.deSerialize(inputStream);
    }

    public Object clone() {
        EventReportPdu newPdu = (EventReportPdu)super.clone();
        newPdu.setEventType(this.eventType.longValue());
        newPdu.setDatumInformation(this.getDatumInformation());
        return newPdu;
    }

    public int length() {
        int currentLength = 0;
        currentLength = super.length() + 8 + this.datumInformation.length();
        return currentLength;
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println();
        printStream.println("Event Report PDU");
        if (superclassIndent > 0) {
            --superclassIndent;
        }
        super.printValues(superclassIndent, printStream);
        printStream.println(indent + "eventType: " + this.eventType.longValue());
        this.datumInformation.printValues(indentLevel, printStream);
    }

    public EventReportPdu getExemplar() {
        return (EventReportPdu)exemplar.clone();
    }

    public void setExemplar(EventReportPdu newExemplar) {
        exemplar = newExemplar;
    }

    public UnsignedInt getEventType() {
        return (UnsignedInt)this.eventType.clone();
    }

    public void setEventType(long pEventType) {
        this.eventType = new UnsignedInt(pEventType);
    }

    public DatumSpecification getDatumInformation() {
        return (DatumSpecification)this.datumInformation.clone();
    }

    public void setDatumInformation(DatumSpecification pDatumSpecification) {
        this.datumInformation = pDatumSpecification;
    }
}

