/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import mil.navy.nps.dis.BurstDescriptor;
import mil.navy.nps.dis.EntityID;
import mil.navy.nps.dis.EventID;
import mil.navy.nps.dis.LinearVelocity;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.dis.WorldCoordinate;
import mil.navy.nps.util.UnsignedInt;

public class FirePdu
extends ProtocolDataUnit {
    protected EntityID firingEntityID = new EntityID();
    protected EntityID targetEntityID = new EntityID();
    protected EntityID munitionID = new EntityID();
    protected EventID eventID = new EventID();
    protected UnsignedInt fireMissionIndex = new UnsignedInt(0);
    protected WorldCoordinate locationInWorldCoordinate = new WorldCoordinate(0.0, 0.0, 0.0);
    protected BurstDescriptor burstDescriptor = new BurstDescriptor();
    protected LinearVelocity velocity = new LinearVelocity(0.0f, 0.0f, 0.0f);
    protected float range = 0.0f;
    public static final int sizeOf = 96;

    public FirePdu() {
        super.setPduType((short)2);
    }

    public Object clone() {
        FirePdu newFirePdu = new FirePdu();
        newFirePdu.setFiringEntityID(this.getFiringEntityID());
        newFirePdu.setTargetEntityID(this.getTargetEntityID());
        newFirePdu.setMunitionID(this.getMunitionID());
        newFirePdu.setEventID(this.getEventID());
        newFirePdu.setFireMissionIndex(this.getFireMissionIndex());
        newFirePdu.setLocationInWorldCoordinate(this.getLocationInWorldCoordinate());
        newFirePdu.setBurstDescriptor(this.getBurstDescriptor());
        newFirePdu.setVelocity(this.getVelocity());
        newFirePdu.setRange(this.getRange());
        return newFirePdu;
    }

    public void serialize(DataOutputStream outputStream) {
        super.serialize(outputStream);
        try {
            this.firingEntityID.serialize(outputStream);
            this.targetEntityID.serialize(outputStream);
            this.munitionID.serialize(outputStream);
            this.eventID.serialize(outputStream);
            this.fireMissionIndex.serialize(outputStream);
            this.locationInWorldCoordinate.serialize(outputStream);
            this.burstDescriptor.serialize(outputStream);
            this.velocity.serialize(outputStream);
            outputStream.writeFloat(this.range);
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in FirePdu. Error writing to wire.");
        }
    }

    public void deSerialize(DataInputStream inputStream) {
        super.deSerialize(inputStream);
        try {
            this.firingEntityID.deSerialize(inputStream);
            this.targetEntityID.deSerialize(inputStream);
            this.munitionID.deSerialize(inputStream);
            this.eventID.deSerialize(inputStream);
            this.fireMissionIndex.deSerialize(inputStream);
            this.locationInWorldCoordinate.deSerialize(inputStream);
            this.burstDescriptor.deSerialize(inputStream);
            this.velocity.deSerialize(inputStream);
            this.range = inputStream.readFloat();
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in FirePdu. Error reading from wire.");
        }
    }

    public int length() {
        return 96;
    }

    public String pduName() {
        return new String("Fire PDU");
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println();
        printStream.println("Fire PDU-");
        if (superclassIndent > 0) {
            --superclassIndent;
        }
        super.printValues(superclassIndent, printStream);
        this.firingEntityID.printValues(indentLevel, printStream);
        this.targetEntityID.printValues(indentLevel, printStream);
        this.munitionID.printValues(indentLevel, printStream);
        this.eventID.printValues(indentLevel, printStream);
        printStream.println(indent + "fireMissionIndex: " + this.fireMissionIndex.longValue());
        this.locationInWorldCoordinate.printValues(indentLevel, printStream);
        this.burstDescriptor.printValues(indentLevel, printStream);
        this.velocity.printValues(indentLevel, printStream);
        printStream.println(indent + "range: " + this.range);
    }

    public EntityID getFiringEntityID() {
        return (EntityID)this.firingEntityID.clone();
    }

    public void setFiringEntityID(EntityID pFiringEntityID) {
        this.firingEntityID = pFiringEntityID;
    }

    public EntityID getTargetEntityID() {
        return (EntityID)this.targetEntityID.clone();
    }

    public void setTargetEntityID(EntityID pTargetEntityID) {
        this.targetEntityID = pTargetEntityID;
    }

    public EntityID getMunitionID() {
        return (EntityID)this.munitionID.clone();
    }

    public void setMunitionID(EntityID pMunitionID) {
        this.munitionID = pMunitionID;
    }

    public EventID getEventID() {
        return (EventID)this.eventID.clone();
    }

    public void setEventID(EventID pEventID) {
        this.eventID = pEventID;
    }

    public UnsignedInt getFireMissionIndex() {
        return (UnsignedInt)this.fireMissionIndex.clone();
    }

    public void setFireMissionIndex(UnsignedInt pFireMissionIndex) {
        this.fireMissionIndex = pFireMissionIndex;
    }

    public void setFireMissionIndex(int pFireMissionIndex) {
        this.fireMissionIndex = new UnsignedInt(pFireMissionIndex);
    }

    public WorldCoordinate getLocationInWorldCoordinate() {
        return (WorldCoordinate)this.locationInWorldCoordinate.clone();
    }

    public void setLocationInWorldCoordinate(WorldCoordinate pWorldCoordinate) {
        this.locationInWorldCoordinate = pWorldCoordinate;
    }

    public void setLocationInWorldCoordinate(double pX, double pY, double pZ) {
        this.locationInWorldCoordinate = new WorldCoordinate(pX, pY, pZ);
    }

    public BurstDescriptor getBurstDescriptor() {
        return (BurstDescriptor)this.burstDescriptor.clone();
    }

    public void setBurstDescriptor(BurstDescriptor pBurstDescriptor) {
        this.burstDescriptor = pBurstDescriptor;
    }

    public LinearVelocity getVelocity() {
        return (LinearVelocity)this.velocity.clone();
    }

    public void setVelocity(LinearVelocity pVelocity) {
        this.velocity = pVelocity;
    }

    public void setVelocity(float pX, float pY, float pZ) {
        this.velocity = new LinearVelocity(pX, pY, pZ);
    }

    public float getRange() {
        return this.range;
    }

    public void setRange(float pRange) {
        this.range = pRange;
    }
}

