/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import mil.navy.nps.dis.PduElement;
import mil.navy.nps.dis.ProtocolDataUnit;

public class LinearAcceleration
extends PduElement {
    protected float x;
    protected float y;
    protected float z;
    public final int sizeOf = 12;

    public LinearAcceleration() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public LinearAcceleration(float pX, float pY, float pZ) {
        this.x = pX;
        this.y = pY;
        this.z = pZ;
    }

    public Object clone() {
        LinearAcceleration newAcceleration = new LinearAcceleration(this.x, this.y, this.z);
        return newAcceleration;
    }

    public void serialize(DataOutputStream outputStream) {
        try {
            outputStream.writeFloat(this.x);
            outputStream.writeFloat(this.y);
            outputStream.writeFloat(this.z);
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in Acceleration. Error writing to wire.");
        }
    }

    public void deSerialize(DataInputStream pInputStream) {
        try {
            this.x = pInputStream.readFloat();
            this.y = pInputStream.readFloat();
            this.z = pInputStream.readFloat();
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in Acceleration. Error reading from wire.");
        }
    }

    public int length() {
        return 12;
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println(indent + "acceleration x: " + this.x);
        printStream.println(indent + "acceleration y: " + this.y);
        printStream.println(indent + "acceleration z: " + this.z);
    }

    public void setValues(float pX, float pY, float pZ) {
        this.x = pX;
        this.y = pY;
        this.z = pZ;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float pX) {
        this.x = pX;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float pY) {
        this.y = pY;
    }

    public float getZ() {
        return this.z;
    }

    public void setZ(float pZ) {
        this.z = pZ;
    }
}

