/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.util.GregorianCalendar;
import mil.navy.nps.dis.CollisionPdu;
import mil.navy.nps.dis.CommentPdu;
import mil.navy.nps.dis.CreateEntityPdu;
import mil.navy.nps.dis.DataPdu;
import mil.navy.nps.dis.DetonationPdu;
import mil.navy.nps.dis.EntityStatePdu;
import mil.navy.nps.dis.FirePdu;
import mil.navy.nps.dis.PduElement;
import mil.navy.nps.dis.RadioCommunicationsFamily;
import mil.navy.nps.dis.ReceiverPdu;
import mil.navy.nps.dis.RemoveEntityPdu;
import mil.navy.nps.dis.RtpHeader;
import mil.navy.nps.dis.SignalPdu;
import mil.navy.nps.dis.SimulationManagementFamily;
import mil.navy.nps.dis.TransmitterPdu;
import mil.navy.nps.disEnumerations.PduTypeField;
import mil.navy.nps.util.UnsignedByte;
import mil.navy.nps.util.UnsignedInt;
import mil.navy.nps.util.UnsignedShort;

public abstract class ProtocolDataUnit
extends PduElement {
    private RtpHeader rtpHeader;
    private boolean rtpHeaderEnabled = true;
    public static final boolean DEBUG = false;
    private static long simulationStartTime = 0L;
    protected UnsignedByte protocolVersion;
    protected UnsignedByte exerciseID;
    protected UnsignedByte pduType;
    protected UnsignedByte protocolFamily;
    protected UnsignedInt timestamp;
    protected long timeReceived;
    public static final int sizeOf = 12;

    public boolean getRtpHeaderEnabled() {
        return this.rtpHeaderEnabled;
    }

    public void setRtpHeaderEnabled(boolean pRtpHeaderEnabled) {
        this.rtpHeaderEnabled = pRtpHeaderEnabled;
    }

    protected static void debug(String pDiagnostic) {
    }

    protected static void trace(String pDiagnostic) {
        System.out.println("ProtocolDataUnit: " + pDiagnostic);
    }

    public ProtocolDataUnit() {
        if (this.rtpHeaderEnabled) {
            this.rtpHeader = new RtpHeader();
        }
        this.protocolVersion = new UnsignedByte(5);
        this.exerciseID = new UnsignedByte(1);
        this.pduType = new UnsignedByte(42);
        this.protocolFamily = new UnsignedByte(0);
        if (this instanceof SimulationManagementFamily) {
            this.protocolFamily = new UnsignedByte(5);
        }
        if (this instanceof RadioCommunicationsFamily) {
            this.protocolFamily = new UnsignedByte(4);
        }
        if (this instanceof DetonationPdu || this instanceof FirePdu) {
            this.protocolFamily = new UnsignedByte(2);
        }
        if (this instanceof CollisionPdu || this instanceof EntityStatePdu) {
            this.protocolFamily = new UnsignedByte(1);
        }
        this.makeTimestampCurrent();
    }

    public Object clone() {
        ProtocolDataUnit newPdu = (ProtocolDataUnit)super.clone();
        newPdu.setProtocolVersion(this.getProtocolVersion());
        newPdu.setExerciseID(this.getExerciseID());
        newPdu.setPduType(this.getPduType());
        newPdu.setProtocolFamily(this.getProtocolFamily());
        newPdu.makeTimestampCurrent();
        return newPdu;
    }

    public static StringBuffer getPaddingOfLength(int pIndent) {
        StringBuffer buf = new StringBuffer();
        for (int idx = 0; idx < pIndent; ++idx) {
            buf.append(' ');
        }
        return buf;
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer buf = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        printStream.println(buf + "protocolVersion: " + this.protocolVersion.intValue());
        printStream.println(buf + "exerciseID: " + this.exerciseID.intValue());
        printStream.println(buf + "pduType: " + this.pduType.intValue());
        printStream.println(buf + "protocolFamily: " + this.protocolFamily.intValue());
        printStream.println(buf + "timestamp: " + this.timestamp.longValue());
        printStream.println(buf + "length: " + this.length());
    }

    public void makeTimestampCurrent() {
        long currentTime = System.currentTimeMillis();
        this.timestamp = new UnsignedInt(currentTime -= simulationStartTime);
    }

    public double getVRMLTimestamp() {
        long pduTimestamp = this.timestamp.longValue();
        pduTimestamp = simulationStartTime + pduTimestamp;
        return pduTimestamp;
    }

    public static void setSimulationStartTime(long pStartTime) {
        simulationStartTime = pStartTime;
    }

    public abstract String pduName();

    public String toString() {
        return this.pduName();
    }

    public UnsignedByte getProtocolVersion() {
        return (UnsignedByte)this.protocolVersion.clone();
    }

    public void setProtocolVersion(UnsignedByte pProtocolVersion) {
        this.protocolVersion = pProtocolVersion;
    }

    public void setProtocolVersion(int pProtocolVersion) {
        this.protocolVersion = new UnsignedByte(pProtocolVersion);
    }

    public UnsignedByte getExerciseID() {
        return (UnsignedByte)this.exerciseID.clone();
    }

    public void setExerciseID(UnsignedByte pExerciseID) {
        this.exerciseID = pExerciseID;
    }

    public void setExerciseID(int pExerciseID) {
        this.exerciseID = new UnsignedByte(pExerciseID);
    }

    public UnsignedByte getPduType() {
        return (UnsignedByte)this.pduType.clone();
    }

    public int getPduTypeValue() {
        return this.pduType.intValue();
    }

    public void setPduType(UnsignedByte pPduType) {
        this.pduType = pPduType;
    }

    public void setPduType(short pPduType) {
        this.pduType = new UnsignedByte(pPduType);
    }

    public UnsignedByte getProtocolFamily() {
        return (UnsignedByte)this.protocolFamily.clone();
    }

    public void setProtocolFamily(UnsignedByte pProtocolFamily) {
        this.protocolFamily = pProtocolFamily;
    }

    public void setProtocolFamily(int pProtocolFamily) {
        this.protocolFamily = new UnsignedByte(pProtocolFamily);
    }

    public UnsignedInt getTimestamp() {
        return (UnsignedInt)this.timestamp.clone();
    }

    public long getTimestampValue() {
        return this.timestamp.longValue();
    }

    public void setTimestamp(UnsignedInt pTimestamp) {
        this.timestamp = pTimestamp;
    }

    public void setTimestamp(long pTimestamp) {
        this.timestamp = new UnsignedInt(pTimestamp);
    }

    public int length() {
        return 12;
    }

    public void serialize(DataOutputStream outputStream) {
        UnsignedShort padding = new UnsignedShort(0);
        UnsignedShort length = new UnsignedShort(this.length());
        ProtocolDataUnit.debug("serializing in PDU");
        if (this.rtpHeaderEnabled) {
            this.rtpHeader.prepareToSend(this);
            this.rtpHeader.serialize(outputStream);
        }
        this.protocolVersion.serialize(outputStream);
        this.exerciseID.serialize(outputStream);
        this.pduType.serialize(outputStream);
        this.protocolFamily.serialize(outputStream);
        this.timestamp.serialize(outputStream);
        length.serialize(outputStream);
        padding.serialize(outputStream);
        ProtocolDataUnit.debug("exiting serialize in ProtocolDataUnit");
    }

    public void deSerialize(DataInputStream inputStream) {
        int temp;
        int firstByte;
        try {
            firstByte = inputStream.readByte();
            inputStream.reset();
        }
        catch (IOException ioException) {
            throw new RuntimeException("deSerialize:  Exception in ProtocolDataUnit. Error resetting stream.");
        }
        this.setRtpHeaderEnabled(false);
        ProtocolDataUnit.debug("deSerialize:  firstByte=" + firstByte + ", RtpHeader.RTP_VERSION * 64 = " + 128);
        int n = temp = firstByte < 0 ? 255 + firstByte + 1 : firstByte;
        if (temp == 128) {
            this.setRtpHeaderEnabled(true);
            this.rtpHeader.deSerialize(inputStream);
        }
        this.protocolVersion.deSerialize(inputStream);
        this.exerciseID.deSerialize(inputStream);
        this.pduType.deSerialize(inputStream);
        this.protocolFamily.deSerialize(inputStream);
        this.timestamp.deSerialize(inputStream);
        try {
            inputStream.readInt();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Exception in UnsignedByte. Error deSerializing from stream.");
        }
    }

    public static ProtocolDataUnit datagramToPdu(DatagramPacket pDatagramPacket) {
        byte[] byteArray = pDatagramPacket.getData();
        return ProtocolDataUnit.byteArrayToPdu(byteArray);
    }

    /*
     * WARNING - void declaration
     */
    public static ProtocolDataUnit byteArrayToPdu(byte[] pByteArray) {
        void var1_9;
        UnsignedByte pduType = new UnsignedByte();
        ProtocolDataUnit.debug("translating a byte array into a PDU");
        byte[] initialBuf = pByteArray;
        ByteArrayInputStream initialByteStream = new ByteArrayInputStream(initialBuf);
        DataInputStream initialDataStream = new DataInputStream(initialByteStream);
        UnsignedByte firstByte = new UnsignedByte();
        firstByte.deSerialize(initialDataStream);
        ProtocolDataUnit.debug("byteArrayToPdu: firstByte=" + firstByte + ", RtpHeader.RTP_VERSION * 64 = " + 128);
        int offset = 0;
        offset = firstByte.intValue() == 128 ? 13 : 1;
        try {
            initialDataStream.skipBytes(offset);
            pduType.deSerialize(initialDataStream);
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in ProtocolDataUnit. Error instantiating from datagram.");
        }
        try {
            initialDataStream.reset();
        }
        catch (IOException ioException) {
            throw new RuntimeException("byteArrayToPdu:  Exception in ProtocolDataUnit. Error resetting stream.");
        }
        ProtocolDataUnit.debug("Got PDU of type " + pduType + ", " + PduTypeField.toString(pduType.shortValue()));
        switch (pduType.shortValue()) {
            case 4: {
                ProtocolDataUnit.debug("got a packet with PduTypeField.COLLISION, instantiating a CollisionPdu");
                ProtocolDataUnit newPdu = new CollisionPdu();
                break;
            }
            case 22: {
                ProtocolDataUnit.debug("got a packet with PduTypeField.COMMENT, instantiating a CommentPdu");
                ProtocolDataUnit newPdu = new CommentPdu();
                break;
            }
            case 11: {
                ProtocolDataUnit.debug("got a packet with PduTypeField.CREATEENTITY, instantiating a CreateEntityPdu");
                ProtocolDataUnit newPdu = new CreateEntityPdu();
                break;
            }
            case 20: {
                ProtocolDataUnit.debug("got a packet with PduTypeField.DATA, instantiating a DataPdu");
                ProtocolDataUnit newPdu = new DataPdu();
                break;
            }
            case 3: {
                ProtocolDataUnit.debug("got a packet with PduTypeField.DETONATION, instantiating a DetonationPdu");
                ProtocolDataUnit newPdu = new DetonationPdu();
                break;
            }
            case 1: {
                ProtocolDataUnit.debug("got a packet with PduTypeField.ENTITYSTATE, instantiating an EntityStatePdu (ESPDU)");
                ProtocolDataUnit newPdu = new EntityStatePdu();
                break;
            }
            case 2: {
                ProtocolDataUnit.debug("got a packet with PduTypeField.FIRE, instantiating a FirePdu");
                ProtocolDataUnit newPdu = new FirePdu();
                break;
            }
            case 27: {
                ProtocolDataUnit.debug("got a packet with PduTypeField.RECEIVER, instantiating a ReceiverPdu");
                ProtocolDataUnit newPdu = new ReceiverPdu();
                break;
            }
            case 12: {
                ProtocolDataUnit.debug("got a packet with PduTypeField.REMOVEENTITY, instantiating a RemoveEntityPdu");
                ProtocolDataUnit newPdu = new RemoveEntityPdu();
                break;
            }
            case 26: {
                ProtocolDataUnit.debug("got a packet with PduTypeField.SIGNAL, instantiating a SignalPdu");
                ProtocolDataUnit newPdu = new SignalPdu();
                break;
            }
            case 25: {
                ProtocolDataUnit.debug("got a packet with PduTypeField.TRANSMITTER, instantiating a TransmitterPdu");
                ProtocolDataUnit newPdu = new TransmitterPdu();
                break;
            }
            default: {
                ProtocolDataUnit.trace("Unrecognized PDU type received in packet: " + pduType.shortValue() + ", " + PduTypeField.toString(pduType.shortValue()));
                ProtocolDataUnit.printPacketContents(pByteArray);
                return null;
            }
        }
        var1_9.deSerialize(initialDataStream);
        ProtocolDataUnit.debug("translated a datagram into a PDU");
        return var1_9;
    }

    private static void printPacketContents(byte[] pByteArray) {
        System.out.print("Packet contents: ");
        for (int idx = 0; idx < pByteArray.length; ++idx) {
            System.out.print(pByteArray[idx] + " ");
        }
        System.out.println();
    }

    public long getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(long pTimeReceived) {
        this.timeReceived = pTimeReceived;
    }

    public void stampTimeReceived() {
        this.timeReceived = System.currentTimeMillis();
    }

    static {
        GregorianCalendar currentDate = new GregorianCalendar();
        int year = currentDate.get(1) - 1900;
        int month = currentDate.get(2);
        int date = currentDate.get(5);
        GregorianCalendar midnight = new GregorianCalendar();
        midnight.set(year + 1900, month, date, 0, 0, 0);
        simulationStartTime = midnight.getTime().getTime();
    }
}

