/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import mil.navy.nps.dis.PduElement;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.util.UnsignedByte;
import mil.navy.nps.util.UnsignedInt;
import mil.navy.nps.util.UnsignedShort;

public class RtpHeader
extends PduElement {
    private static long mySSRC = (long)(Math.random() * 2.147483647E9);
    private static int nextSequenceNumber = (int)(Math.random() * 65535.0);
    public static final int RTP_VERSION = 2;
    public static final int RTP_PADDING = 0;
    public static final int RTP_EXTENSION = 0;
    public static final int RTP_CSRC_COUNT = 0;
    public static final int RTP_MARKER = 0;
    public static final int RTP_PAYLOAD_TYPE_FOR_DIS = 111;
    public static final int sizeOf = 12;
    private UnsignedShort sequenceNumber = new UnsignedShort();
    private UnsignedInt timestamp = new UnsignedInt();
    private UnsignedInt SSRC = new UnsignedInt();

    public UnsignedShort getSequenceNumber() {
        return (UnsignedShort)this.sequenceNumber.clone();
    }

    public UnsignedInt getTimestamp() {
        return (UnsignedInt)this.timestamp.clone();
    }

    public UnsignedInt getSSRC() {
        return (UnsignedInt)this.SSRC.clone();
    }

    public void setSequenceNumber(UnsignedShort pSequenceNumber) {
        this.sequenceNumber = pSequenceNumber;
    }

    public void setTimestamp(UnsignedInt pTimestamp) {
        this.timestamp = pTimestamp;
    }

    public void setSSRC(UnsignedInt pSSRC) {
        this.SSRC = pSSRC;
    }

    private void incrementSequenceNumber() {
        if (++nextSequenceNumber > 65535) {
            nextSequenceNumber = 0;
        }
    }

    public void prepareToSend(ProtocolDataUnit pdu) {
        this.sequenceNumber = new UnsignedShort(nextSequenceNumber);
        this.incrementSequenceNumber();
        this.timestamp = pdu.getTimestamp();
        this.SSRC = new UnsignedInt(mySSRC);
    }

    public int length() {
        return 12;
    }

    public void serialize(DataOutputStream outputStream) {
        UnsignedByte firstByte = new UnsignedByte(128);
        UnsignedByte secondByte = new UnsignedByte(111);
        firstByte.serialize(outputStream);
        secondByte.serialize(outputStream);
        this.sequenceNumber.serialize(outputStream);
        this.timestamp.serialize(outputStream);
        this.SSRC.serialize(outputStream);
    }

    public void deSerialize(DataInputStream inputStream) {
        UnsignedByte firstByte = new UnsignedByte(0);
        UnsignedByte secondByte = new UnsignedByte(0);
        firstByte.deSerialize(inputStream);
        secondByte.deSerialize(inputStream);
        this.sequenceNumber.deSerialize(inputStream);
        this.timestamp.deSerialize(inputStream);
        this.SSRC.deSerialize(inputStream);
    }

    public Object clone() {
        RtpHeader newHeader = (RtpHeader)super.clone();
        newHeader.setSequenceNumber(this.getSequenceNumber());
        newHeader.setTimestamp(this.getTimestamp());
        newHeader.setSSRC(this.getSSRC());
        return newHeader;
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer buf = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        printStream.println(buf + "sequenceNumber: " + this.sequenceNumber.intValue());
        printStream.println(buf + "timestamp: " + this.timestamp.longValue());
        printStream.println(buf + "SSRC: " + this.SSRC.longValue());
    }
}

