/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import mil.navy.nps.dis.ClockTime;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.dis.SimulationManagementFamily;
import mil.navy.nps.util.UnsignedInt;

public class StartResumePdu
extends SimulationManagementFamily {
    protected ClockTime realWorldTime;
    protected ClockTime simulationTime;
    protected UnsignedInt requestID;
    public static final int sizeOf = 44;
    protected static StartResumePdu exemplar;

    public StartResumePdu() {
        this.setPduType((short)13);
        this.realWorldTime = new ClockTime();
        this.simulationTime = new ClockTime();
        this.requestID = new UnsignedInt();
    }

    public void serialize(DataOutputStream outputStream) {
        super.serialize(outputStream);
        this.realWorldTime.serialize(outputStream);
        this.simulationTime.serialize(outputStream);
        this.requestID.serialize(outputStream);
    }

    public void deSerialize(DataInputStream inputStream) {
        super.deSerialize(inputStream);
        this.realWorldTime.deSerialize(inputStream);
        this.simulationTime.deSerialize(inputStream);
        this.requestID.deSerialize(inputStream);
    }

    public Object clone() {
        StartResumePdu newPdu = (StartResumePdu)super.clone();
        newPdu.setRealWorldTime(this.getRealWorldTime());
        newPdu.setSimulationTime(this.getSimulationTime());
        newPdu.setRequestID(this.getRequestID());
        return newPdu;
    }

    public int length() {
        return 44;
    }

    public String pduName() {
        return new String("Start Resume PDU");
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println();
        printStream.println("Start Resume PDU");
        if (superclassIndent > 0) {
            --superclassIndent;
        }
        super.printValues(superclassIndent, printStream);
        printStream.println(indent + "Real-World Time");
        this.realWorldTime.printValues(indentLevel + 1, printStream);
        printStream.println(indent + "Simulation Time");
        this.simulationTime.printValues(indentLevel + 1, printStream);
        printStream.println(indent + "Request ID: " + this.requestID.longValue());
    }

    public StartResumePdu getExemplar() {
        return (StartResumePdu)exemplar.clone();
    }

    public void setExemplar(StartResumePdu newExemplar) {
        exemplar = newExemplar;
    }

    public ClockTime getRealWorldTime() {
        return (ClockTime)this.realWorldTime.clone();
    }

    public void setRealWorldTime(ClockTime pRealWorldTime) {
        this.realWorldTime = pRealWorldTime;
    }

    public ClockTime getSimulationTime() {
        return (ClockTime)this.simulationTime.clone();
    }

    public void setSimulationTime(ClockTime pSimulationTime) {
        this.simulationTime = pSimulationTime;
    }

    public UnsignedInt getRequestID() {
        return (UnsignedInt)this.requestID.clone();
    }

    public void setRequestID(UnsignedInt pRequestID) {
        this.requestID = pRequestID;
    }

    public void setRequestID(long pRequestID) {
        this.requestID = new UnsignedInt(pRequestID);
    }
}

