/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import mil.navy.nps.dis.EntityCoordinate;
import mil.navy.nps.dis.EntityID;
import mil.navy.nps.dis.ModulationType;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.dis.RadioCommunicationsFamily;
import mil.navy.nps.dis.RadioEntityType;
import mil.navy.nps.dis.WorldCoordinate;
import mil.navy.nps.util.UnsignedByte;
import mil.navy.nps.util.UnsignedInt;
import mil.navy.nps.util.UnsignedLong;
import mil.navy.nps.util.UnsignedShort;

public class TransmitterPdu
extends RadioCommunicationsFamily {
    protected EntityID entityID = new EntityID();
    protected UnsignedShort radioID = new UnsignedShort(0);
    protected RadioEntityType radioEntityType = new RadioEntityType();
    protected UnsignedByte transmitState = new UnsignedByte(0);
    protected UnsignedByte inputSource = new UnsignedByte(0);
    protected UnsignedShort padding1 = new UnsignedShort(0);
    protected WorldCoordinate antennaLocation = new WorldCoordinate();
    protected EntityCoordinate relativeAntennaLocation = new EntityCoordinate();
    protected UnsignedShort antennaPatternType = new UnsignedShort(0);
    protected UnsignedShort antennaPatternLength = new UnsignedShort(0);
    protected UnsignedLong frequency = new UnsignedLong(0);
    protected UnsignedInt transmitFrequencyBandwidth = new UnsignedInt(0);
    protected UnsignedInt power = new UnsignedInt(0);
    protected ModulationType modulationType = new ModulationType();
    protected UnsignedShort cryptoSytem = new UnsignedShort(0);
    protected UnsignedShort cryptoKeyId = new UnsignedShort(0);
    protected UnsignedByte lengthOfModulationParameters = new UnsignedByte(0);
    protected UnsignedShort padding2 = new UnsignedShort(0);
    protected UnsignedByte padding3 = new UnsignedByte(0);
    public static final int sizeOf = 832;

    public TransmitterPdu() {
        super.setPduType((short)25);
    }

    public Object clone() {
        TransmitterPdu newTransmitterPdu = (TransmitterPdu)super.clone();
        newTransmitterPdu.setEntityID(this.getEntityID());
        newTransmitterPdu.setRadioID(this.getRadioID());
        newTransmitterPdu.setRadioEntityType(this.getRadioEntityType());
        newTransmitterPdu.setTransmitState(this.getTransmitState());
        newTransmitterPdu.setInputSource(this.getInputSource());
        newTransmitterPdu.setAntennaLocation(this.getAntennaLocation());
        newTransmitterPdu.setRelativeAntennaLocation(this.getRelativeAntennaLocation());
        newTransmitterPdu.setAntennaPatternType(this.getAntennaPatternType());
        newTransmitterPdu.setAntennaPatternLength(this.getAntennaPatternLength());
        newTransmitterPdu.setFrequency(this.getFrequency());
        newTransmitterPdu.setTransmitFrequencyBandwidth(this.getTransmitFrequencyBandwidth());
        newTransmitterPdu.setPower(this.getPower());
        newTransmitterPdu.setModulationType(this.getModulationType());
        newTransmitterPdu.setCryptoSytem(this.getCryptoSytem());
        newTransmitterPdu.setCryptoKeyId(this.getCryptoKeyId());
        newTransmitterPdu.setLengthOfModulationParameters(this.getLengthOfModulationParameters());
        return newTransmitterPdu;
    }

    public void serialize(DataOutputStream outputStream) {
        super.serialize(outputStream);
        try {
            this.entityID.serialize(outputStream);
            this.radioID.serialize(outputStream);
            this.radioEntityType.serialize(outputStream);
            this.transmitState.serialize(outputStream);
            this.inputSource.serialize(outputStream);
            this.padding1.serialize(outputStream);
            this.antennaLocation.serialize(outputStream);
            this.relativeAntennaLocation.serialize(outputStream);
            this.antennaPatternType.serialize(outputStream);
            this.antennaPatternLength.serialize(outputStream);
            this.frequency.serialize(outputStream);
            this.transmitFrequencyBandwidth.serialize(outputStream);
            this.power.serialize(outputStream);
            this.modulationType.serialize(outputStream);
            this.cryptoSytem.serialize(outputStream);
            this.cryptoKeyId.serialize(outputStream);
            this.lengthOfModulationParameters.serialize(outputStream);
            this.padding2.serialize(outputStream);
            this.padding3.serialize(outputStream);
        }
        catch (Exception someError) {
            throw new RuntimeException("Exception in TransmitterPdu.serialize, error writing to wire.\n" + someError);
        }
    }

    public void deSerialize(DataInputStream inputStream) {
        super.deSerialize(inputStream);
        try {
            this.entityID.deSerialize(inputStream);
            this.radioID.deSerialize(inputStream);
            this.radioEntityType.deSerialize(inputStream);
            this.transmitState.deSerialize(inputStream);
            this.inputSource.deSerialize(inputStream);
            this.padding1.deSerialize(inputStream);
            this.antennaLocation.deSerialize(inputStream);
            this.relativeAntennaLocation.deSerialize(inputStream);
            this.antennaPatternType.deSerialize(inputStream);
            this.antennaPatternLength.deSerialize(inputStream);
            this.frequency.deSerialize(inputStream);
            this.transmitFrequencyBandwidth.deSerialize(inputStream);
            this.power.deSerialize(inputStream);
            this.modulationType.deSerialize(inputStream);
            this.cryptoSytem.deSerialize(inputStream);
            this.cryptoKeyId.deSerialize(inputStream);
            this.lengthOfModulationParameters.deSerialize(inputStream);
            this.padding2.deSerialize(inputStream);
            this.padding3.deSerialize(inputStream);
        }
        catch (Exception someError) {
            throw new RuntimeException("Exception in TransmitterPdu.deSerialize, error reading from wire.\n" + someError);
        }
    }

    public int length() {
        return 832;
    }

    public String pduName() {
        return new String("Transmitter PDU");
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println();
        printStream.println("Transmitter PDU-");
        if (superclassIndent > 0) {
            --superclassIndent;
        }
        super.printValues(superclassIndent, printStream);
        this.entityID.printValues(indentLevel, printStream);
        printStream.println(indent + "radioID: " + this.radioID);
        printStream.println(indent + "radioEntityType: " + this.radioEntityType);
        printStream.println(indent + "transmitState: " + this.transmitState);
        printStream.println(indent + "inputSource: " + this.inputSource);
        printStream.println(indent + "padding1: " + this.padding1);
        printStream.println(indent + "antennaLocation: " + this.antennaLocation);
        printStream.println(indent + "relativeAntennaLocation : " + this.relativeAntennaLocation);
        printStream.println(indent + "antennaPatternType: " + this.antennaPatternType);
        printStream.println(indent + "antennaPatternLength: " + this.antennaPatternLength);
        printStream.println(indent + "frequency: " + this.frequency);
        printStream.println(indent + "transmitFrequencyBandwidth: " + this.transmitFrequencyBandwidth);
        printStream.println(indent + "power: " + this.power);
        printStream.println(indent + "modulationType: " + this.modulationType);
        printStream.println(indent + "cryptoSytem: " + this.cryptoSytem);
        printStream.println(indent + "cryptoKeyId: " + this.cryptoKeyId);
        printStream.println(indent + "lengthOfModulationParameters: " + this.lengthOfModulationParameters);
        printStream.println(indent + "padding2: " + this.padding2);
        printStream.println(indent + "padding3: " + this.padding3);
    }

    public EntityID getEntityID() {
        return (EntityID)this.entityID.clone();
    }

    public void setEntityID(EntityID pEntityID) {
        this.entityID = pEntityID;
    }

    public void setEntityID(short pSiteID, short pApplicationID, short pEntityID) {
        this.entityID = new EntityID(pSiteID, pApplicationID, pEntityID);
    }

    public UnsignedShort getRadioID() {
        return (UnsignedShort)this.radioID.clone();
    }

    public void setRadioID(UnsignedShort pRadioID) {
        this.radioID = pRadioID;
    }

    public RadioEntityType getRadioEntityType() {
        return (RadioEntityType)this.radioEntityType.clone();
    }

    public void setRadioEntityType(RadioEntityType pRadioEntityType) {
        this.radioEntityType = pRadioEntityType;
        System.out.println("set a new radio entity type of " + this.radioEntityType);
    }

    public UnsignedByte getTransmitState() {
        return (UnsignedByte)this.transmitState.clone();
    }

    public void setTransmitState(UnsignedByte pTransmitState) {
        this.transmitState = pTransmitState;
    }

    public UnsignedByte getInputSource() {
        return (UnsignedByte)this.inputSource.clone();
    }

    public void setInputSource(UnsignedByte pInputSource) {
        this.inputSource = pInputSource;
    }

    public WorldCoordinate getAntennaLocation() {
        return (WorldCoordinate)this.antennaLocation.clone();
    }

    public void setAntennaLocation(WorldCoordinate pAntennaLocation) {
        this.antennaLocation = pAntennaLocation;
    }

    public void setAntennaLocation(double pX, double pY, double pZ) {
        this.antennaLocation = new WorldCoordinate(pX, pY, pZ);
    }

    public EntityCoordinate getRelativeAntennaLocation() {
        return (EntityCoordinate)this.relativeAntennaLocation.clone();
    }

    public void setRelativeAntennaLocation(EntityCoordinate pRelativeAntennaLocation) {
        this.relativeAntennaLocation = pRelativeAntennaLocation;
    }

    public UnsignedShort getAntennaPatternType() {
        return (UnsignedShort)this.antennaPatternType.clone();
    }

    public void setAntennaPatternType(UnsignedShort pAntennaPatternType) {
        this.antennaPatternType = pAntennaPatternType;
    }

    public UnsignedShort getAntennaPatternLength() {
        return (UnsignedShort)this.antennaPatternLength.clone();
    }

    public void setAntennaPatternLength(UnsignedShort pAntennaPatternLength) {
        this.antennaPatternLength = pAntennaPatternLength;
    }

    public UnsignedLong getFrequency() {
        return (UnsignedLong)this.frequency.clone();
    }

    public void setFrequency(UnsignedLong pFrequency) {
        this.frequency = pFrequency;
    }

    public UnsignedInt getTransmitFrequencyBandwidth() {
        return (UnsignedInt)this.transmitFrequencyBandwidth.clone();
    }

    public void setTransmitFrequencyBandwidth(UnsignedInt pTransmitFrequencyBandwidth) {
        this.transmitFrequencyBandwidth = pTransmitFrequencyBandwidth;
    }

    public UnsignedInt getPower() {
        return (UnsignedInt)this.power.clone();
    }

    public void setPower(UnsignedInt pPower) {
        this.power = pPower;
    }

    public ModulationType getModulationType() {
        return (ModulationType)this.modulationType.clone();
    }

    public void setModulationType(ModulationType pModulationType) {
        this.modulationType = pModulationType;
    }

    public UnsignedShort getCryptoSytem() {
        return (UnsignedShort)this.cryptoSytem.clone();
    }

    public void setCryptoSytem(UnsignedShort pCryptoSytem) {
        this.cryptoSytem = pCryptoSytem;
    }

    public UnsignedShort getCryptoKeyId() {
        return (UnsignedShort)this.cryptoKeyId.clone();
    }

    public void setCryptoKeyId(UnsignedShort pCryptoKeyId) {
        this.cryptoKeyId = pCryptoKeyId;
    }

    public UnsignedByte getLengthOfModulationParameters() {
        return (UnsignedByte)this.lengthOfModulationParameters.clone();
    }

    public void setLengthOfModulationParameters(UnsignedByte pLengthOfModulationParameters) {
        this.lengthOfModulationParameters = pLengthOfModulationParameters;
    }

    public String toString() {
        String result = "\nEntityID = " + this.entityID + " \nRadioID = " + this.radioID + " \nRadioEntityType = " + this.radioEntityType + " \nTransmitState = " + this.transmitState + "\nInputSource = " + this.inputSource + "\nPadding1 = " + this.padding1 + " \nAntennaLocaction = " + this.antennaLocation + "\nRelativeAntennaLocation = " + this.relativeAntennaLocation + " \nAntennaPatternType = " + this.antennaPatternType + "\nAntennaPatternLength = " + this.antennaPatternLength + " \nFrequency = " + this.frequency + " \nTransmitFrequencyBandwidth = " + this.transmitFrequencyBandwidth + "\nPower = " + this.power;
        return result;
    }
}

