/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import mil.navy.nps.dis.PduElement;
import mil.navy.nps.dis.ProtocolDataUnit;

public class VariableDatum
extends PduElement {
    int variableDatumID = 0;
    int variableDatumLength = 0;
    long[] variableDatumValue = null;
    public static final int sizeOf = 8;
    private static final int BLOCK_LENGTH = 64;

    public Object clone() {
        VariableDatum newVariableDatum = new VariableDatum();
        newVariableDatum.setVariableDatumID(this.variableDatumID);
        newVariableDatum.setVariableDatumLength(this.variableDatumLength);
        newVariableDatum.setVariableDatumValue(this.variableDatumValue);
        return newVariableDatum;
    }

    public void serialize(DataOutputStream outputStream) {
        int idx = 0;
        int blockCount = this.blockCount(this.variableDatumLength);
        try {
            outputStream.writeInt(this.variableDatumID);
            outputStream.writeInt(this.variableDatumLength);
            if (this.variableDatumValue != null && this.variableDatumLength > 0) {
                for (idx = 0; idx < blockCount; ++idx) {
                    outputStream.writeLong(this.variableDatumValue[idx]);
                }
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException("Exception in VariableDatum. Error serializing unit.");
        }
    }

    public void deSerialize(DataInputStream inputStream) {
        int idx = 0;
        try {
            this.variableDatumID = inputStream.readInt();
            this.variableDatumLength = inputStream.readInt();
            if (this.variableDatumLength > 0) {
                int blockCount = this.blockCount(this.variableDatumLength);
                this.variableDatumValue = new long[blockCount];
                for (idx = 0; idx < blockCount; ++idx) {
                    this.variableDatumValue[idx] = inputStream.readLong();
                }
            } else {
                this.variableDatumValue = null;
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException("Exception in VariableDatum. Error deSerializing unit.");
        }
    }

    public int length() {
        if (this.variableDatumLength == 0) {
            return 8;
        }
        return 8 + 8 * this.variableDatumValue.length;
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println(indent + "variableDatumID: " + this.variableDatumID);
        printStream.println(indent + "variableDatumLength: " + this.variableDatumLength);
        for (int idx = 0; idx < this.blockCount(this.variableDatumLength); ++idx) {
            printStream.println("variableDatumValue " + idx + ": " + this.variableDatumValue[idx]);
        }
    }

    private int blockCount(int pBitCount) {
        if (pBitCount > 0) {
            return (pBitCount - 1) / 64 + 1;
        }
        return 0;
    }

    public int getVariableDatumID() {
        return this.variableDatumID;
    }

    public void setVariableDatumID(int pVariableDatumID) {
        this.variableDatumID = pVariableDatumID;
    }

    public int getVariableDatumLength() {
        return this.variableDatumLength;
    }

    public void setVariableDatumLength(int pVariableDatumLength) {
        this.variableDatumLength = pVariableDatumLength;
    }

    public long[] getVariableDatumValue() {
        long[] newVariableDatumValue = new long[this.variableDatumValue.length];
        try {
            System.arraycopy(this.variableDatumValue, 0, newVariableDatumValue, 0, this.variableDatumValue.length);
        }
        catch (ArrayIndexOutOfBoundsException aioobException) {
            throw new RuntimeException("Exception in VariableDatum. Index error copying array.");
        }
        catch (ArrayStoreException asException) {
            throw new RuntimeException("Exception in VariableDatum. Error copying array");
        }
        return newVariableDatumValue;
    }

    public void setVariableDatumValue(long[] pVariableDatumValue) {
        this.variableDatumValue = pVariableDatumValue;
    }
}

