/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.dis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import mil.navy.nps.dis.PduElement;
import mil.navy.nps.dis.ProtocolDataUnit;

public class WorldCoordinate
extends PduElement {
    protected double x;
    protected double y;
    protected double z;
    public final int sizeOf = 24;

    public WorldCoordinate() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public WorldCoordinate(double pX, double pY, double pZ) {
        this.x = pX;
        this.y = pY;
        this.z = pZ;
    }

    public Object clone() {
        WorldCoordinate newWorldCoordinate = new WorldCoordinate(this.x, this.y, this.z);
        return newWorldCoordinate;
    }

    public void serialize(DataOutputStream outputStream) {
        try {
            outputStream.writeDouble(this.x);
            outputStream.writeDouble(this.y);
            outputStream.writeDouble(this.z);
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in WorldPosition. Error writing to wire.");
        }
    }

    public void deSerialize(DataInputStream pInputStream) {
        try {
            this.x = pInputStream.readDouble();
            this.y = pInputStream.readDouble();
            this.z = pInputStream.readDouble();
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in WorldPosition. Error reading from wire.");
        }
    }

    public int length() {
        return 24;
    }

    public void printValues(int indentLevel, PrintStream printStream) {
        StringBuffer indent = ProtocolDataUnit.getPaddingOfLength(indentLevel);
        int superclassIndent = indentLevel;
        printStream.println(indent + "WorldCoordinate x: " + this.x);
        printStream.println(indent + "WorldCoordinate y: " + this.y);
        printStream.println(indent + "WorldCoordinate z: " + this.z);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double pX) {
        this.x = pX;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double pY) {
        this.y = pY;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double pZ) {
        this.z = pZ;
    }
}

