/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.math;

import mil.navy.nps.math.Quaternion;
import mil.navy.nps.math.Vec3f;

public class Matrix3f {
    private float[][] m;

    public Matrix3f() {
        this.m = new float[3][3];
        this.makeNull();
    }

    public Matrix3f(float[][] mat) {
        this.m = new float[3][3];
        this.setMat(mat);
    }

    public Matrix3f(Matrix3f mat) {
        this.m = new float[3][3];
        this.setMat(mat);
    }

    public Matrix3f(Quaternion quat) {
        this.setQuat(quat);
    }

    public Matrix3f(float[] hpr) {
        this.m = new float[3][3];
        this.setEulers(hpr);
    }

    public Matrix3f(float heading, float pitch, float roll) {
        this.m = new float[3][3];
        this.setEulers(heading, pitch, roll);
    }

    public void print() {
        System.out.println("m = " + this.m[0][0] + ", " + this.m[0][1] + ", " + this.m[0][2] + this.m[1][0] + ", " + this.m[1][1] + ", " + this.m[1][2] + this.m[2][0] + ", " + this.m[2][1] + ", " + this.m[2][2]);
    }

    public void setMatValue(int row, int col, float val) {
        if (row < 0 || row > 3 || col < 0 || col > 3) {
            return;
        }
        this.m[row][col] = val;
    }

    public float getMatValue(int row, int col) {
        if (row < 0 || row > 3 || col < 0 || col > 3) {
            return 0.0f;
        }
        return this.m[row][col];
    }

    public void setMat(float[][] mat) {
        this.m[0][0] = mat[0][0];
        this.m[0][1] = mat[0][1];
        this.m[0][2] = mat[0][2];
        this.m[1][0] = mat[1][0];
        this.m[1][1] = mat[1][1];
        this.m[1][2] = mat[1][2];
        this.m[2][0] = mat[2][0];
        this.m[2][1] = mat[2][1];
        this.m[2][2] = mat[2][2];
    }

    public void getMat(float[][] mat) {
        mat[0][0] = this.m[0][0];
        mat[0][1] = this.m[0][1];
        mat[0][2] = this.m[0][2];
        mat[1][0] = this.m[1][0];
        mat[1][1] = this.m[1][1];
        mat[1][2] = this.m[1][2];
        mat[2][0] = this.m[2][0];
        mat[2][1] = this.m[2][1];
        mat[2][2] = this.m[2][2];
    }

    public void setMat(Matrix3f mat) {
        float[][] mat2 = new float[3][3];
        mat.getMat(mat2);
        this.setMat(mat2);
    }

    public void getMat(Matrix3f mat) {
        float[][] mat2 = new float[3][3];
        this.getMat(mat2);
        mat.setMat(mat2);
    }

    public void setQuat(Quaternion quat) {
        quat.getMat3(this.m);
    }

    public void getQuat(Quaternion quat) {
        quat.setMat3(this.m);
    }

    public void setEulers(float[] hpr) {
        this.setEulers(hpr[0], hpr[1], hpr[2]);
    }

    public void getEulers(float[] hpr) {
        float sinr;
        float cosr;
        float sinh;
        float cosh;
        float sinp = -this.m[1][2];
        float cosp = (float)Math.sqrt(1.0f - sinp * sinp);
        if (Math.abs(cosp) > 1.0E-4f) {
            cosh = this.m[2][2] / cosp;
            sinh = this.m[0][2] / cosp;
            cosr = this.m[2][1] / cosp;
            sinr = this.m[1][0] / cosp;
        } else {
            cosh = 1.0f;
            sinh = 0.0f;
            cosr = this.m[0][0];
            sinr = -this.m[0][1];
        }
        hpr[0] = (float)Math.atan2(sinh, cosh);
        hpr[1] = (float)Math.atan2(sinp, cosp);
        hpr[2] = (float)Math.atan2(sinr, cosr);
    }

    public void setEulers(float h, float p, float r) {
        float cosh = (float)Math.cos(h);
        float sinh = (float)Math.sin(h);
        float cosp = (float)Math.cos(p);
        float sinp = (float)Math.sin(p);
        float cosr = (float)Math.cos(r);
        float sinr = (float)Math.sin(r);
        this.m[0][0] = cosh * cosr + sinh * sinp * sinr;
        this.m[0][1] = -cosh * sinr + sinh * sinp * cosr;
        this.m[0][2] = sinh * cosp;
        this.m[1][0] = cosp * sinr;
        this.m[1][1] = sinh * sinr + cosh * sinp * cosr;
        this.m[1][2] = -sinp;
        this.m[2][0] = -sinh * cosr + cosh * sinp * sinr;
        this.m[2][1] = cosp * cosr;
        this.m[2][2] = cosh * cosp;
    }

    public void getEulers(float[] h, float[] p, float[] r) {
        float[] hpr = new float[3];
        this.getEulers(hpr);
        h[0] = hpr[0];
        p[0] = hpr[1];
        r[0] = hpr[2];
    }

    public void makeNull() {
        this.m[0][0] = 0.0f;
        this.m[0][1] = 0.0f;
        this.m[0][2] = 0.0f;
        this.m[1][0] = 0.0f;
        this.m[1][1] = 0.0f;
        this.m[1][2] = 0.0f;
        this.m[2][0] = 0.0f;
        this.m[2][1] = 0.0f;
        this.m[2][2] = 0.0f;
    }

    public void makeIdent() {
        this.m[0][0] = 1.0f;
        this.m[0][1] = 0.0f;
        this.m[0][2] = 0.0f;
        this.m[1][0] = 0.0f;
        this.m[1][1] = 1.0f;
        this.m[1][2] = 0.0f;
        this.m[2][0] = 0.0f;
        this.m[2][1] = 0.0f;
        this.m[2][2] = 1.0f;
    }

    public void xform(Vec3f vec) {
        float[] v = new float[3];
        vec.get(v);
        vec.set(0, v[0] * this.m[0][0] + v[1] * this.m[0][1] + v[2] * this.m[0][2]);
        vec.set(1, v[0] * this.m[1][0] + v[1] * this.m[1][1] + v[2] * this.m[1][2]);
        vec.set(2, v[0] * this.m[2][0] + v[1] * this.m[2][1] + v[2] * this.m[2][2]);
    }

    public void xform(float[] v) {
        float[] tmp_v = new float[]{v[0] * this.m[0][0] + v[1] * this.m[0][1] + v[2] * this.m[0][2], v[0] * this.m[1][0] + v[1] * this.m[1][1] + v[2] * this.m[1][2], v[0] * this.m[2][0] + v[1] * this.m[2][1] + v[2] * this.m[2][2]};
        v[0] = tmp_v[0];
        v[1] = tmp_v[1];
        v[2] = tmp_v[2];
    }
}

