/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.math;

public class Quaternion2 {
    private double w;
    private double x;
    private double y;
    private double z;
    private String name;

    public Quaternion2(String myName, double ww, double xx, double yy, double zz) {
        this.name = new String(myName);
        this.w = ww;
        this.x = xx;
        this.y = yy;
        this.z = zz;
    }

    public Quaternion2(String myName) {
        this.name = new String(myName);
        this.w = 1.0;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Quaternion2() {
        this.name = new String("Quaternion2");
        this.w = 1.0;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public void setQuaternion2(double ww, double xx, double yy, double zz) {
        this.w = ww;
        this.x = xx;
        this.y = yy;
        this.z = zz;
    }

    public double getW() {
        return this.w;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Quaternion2 multiply(Quaternion2 QUAT) {
        Quaternion2 dest = new Quaternion2("Quaternion2 Product");
        dest.w = QUAT.w * this.w - QUAT.x * this.x - QUAT.y * this.y - QUAT.z * this.z;
        dest.x = QUAT.w * this.x + QUAT.x * this.w - QUAT.y * this.z + QUAT.z * this.y;
        dest.y = QUAT.w * this.y + QUAT.y * this.w - QUAT.z * this.x + QUAT.x * this.z;
        dest.z = QUAT.w * this.z + QUAT.z * this.w - QUAT.x * this.y + QUAT.y * this.x;
        return dest;
    }

    public Quaternion2 multiply(double NUM) {
        this.w = NUM * this.w;
        this.x = NUM * this.x;
        this.y = NUM * this.y;
        this.z = NUM * this.z;
        return this;
    }

    public Quaternion2 add(Quaternion2 QUAT) {
        Quaternion2 addTo = new Quaternion2("addition");
        addTo.w = this.w + QUAT.w;
        addTo.x = this.x + QUAT.x;
        addTo.y = this.y + QUAT.y;
        addTo.z = this.z + QUAT.z;
        return addTo;
    }

    public Quaternion2 substract(Quaternion2 QUAT) {
        Quaternion2 s = new Quaternion2("substraction");
        s.w = this.w - QUAT.w;
        s.x = this.x - QUAT.x;
        s.y = this.y - QUAT.y;
        s.z = this.z - QUAT.z;
        return s;
    }

    public Quaternion2 invert() {
        Quaternion2 temp = new Quaternion2("Conjugate");
        temp.w = this.w;
        temp.x = -this.x;
        temp.y = -this.y;
        temp.z = -this.z;
        return temp;
    }

    public Quaternion2 rotate(Quaternion2 QUAT4) {
        Quaternion2 temp = new Quaternion2("Rotation");
        temp = this.multiply(QUAT4.multiply(this.invert()));
        return temp;
    }

    public Quaternion2 toBody(Quaternion2 QUAT) {
        Quaternion2 temp = new Quaternion2("to Body");
        temp = this.invert().multiply(QUAT.multiply(this));
        return temp;
    }

    public double dotProduct(Quaternion2 QUAT5) {
        double dotproduct = this.w * QUAT5.w + this.x * QUAT5.x + this.y * QUAT5.y + this.z * QUAT5.z;
        return dotproduct;
    }

    public void normalize() {
        double sq = Math.sqrt(this.dotProduct(this));
        this.x /= sq;
        this.y /= sq;
        this.z /= sq;
        this.w /= sq;
    }

    public Quaternion2 toAxisAngles() {
        Quaternion2 axisAngle = new Quaternion2("To Axis Angle ");
        double temp = Math.acos(this.w) * 2.0;
        double scalarNumber = Math.sin(temp / 2.0);
        axisAngle.x = this.x / scalarNumber;
        axisAngle.y = -1.0 * this.z / scalarNumber;
        axisAngle.z = this.y / scalarNumber;
        axisAngle.w = temp * 180.0 / Math.PI;
        return axisAngle;
    }

    public Quaternion2 toQuaternion2() {
        Quaternion2 quat = new Quaternion2("Euler To Quaternion2");
        double radX = this.x * Math.PI / 180.0;
        double radY = this.y * Math.PI / 180.0;
        double radZ = this.z * Math.PI / 180.0;
        double tempx = radX * 0.5;
        double tempy = radY * 0.5;
        double tempz = radZ * 0.5;
        double cosx = Math.cos(tempx);
        double cosy = Math.cos(tempy);
        double cosz = Math.cos(tempz);
        double sinx = Math.sin(tempx);
        double siny = Math.sin(tempy);
        double sinz = Math.sin(tempz);
        double cosc = cosx * cosz;
        double coss = cosx * sinz;
        double sinc = sinx * cosz;
        double sins = sinx * sinz;
        quat.x = cosy * sinc - siny * coss;
        quat.y = cosy * sins + siny * cosc;
        quat.z = cosy * coss - siny * sinc;
        quat.w = cosy * cosc + siny * sins;
        quat.normalize();
        return quat;
    }

    public Quaternion2 toEulerAngles() {
        double cosf;
        double sinf;
        double cosv;
        double sinv;
        Quaternion2 euler = new Quaternion2("Quat to euler");
        double sint = 2.0 * this.w * this.y - 2.0 * this.x * this.z;
        double cost = Math.sqrt(1.0 - Math.pow(sint, 2.0));
        if (cost != 0.0) {
            sinv = (2.0 * this.y * this.z + 2.0 * this.w * this.x) / cost;
            cosv = (1.0 - 2.0 * this.x * this.x - 2.0 * this.y * this.y) / cost;
            sinf = (1.0 - 2.0 * this.x * this.x - 2.0 * this.y * this.y) / cost;
            cosf = (1.0 - 2.0 * this.y * this.y - 2.0 * this.z * this.z) / cost;
        } else {
            sinv = 2.0 * this.w * this.x - 2.0 * this.y * this.z;
            cosv = 1.0 - 2.0 * this.x * this.x - 2.0 * this.z * this.z;
            sinf = 0.0;
            cosf = 1.0;
        }
        double ex = Math.atan2(sinv, cosv);
        double ey = Math.atan2(sint, cost);
        double ez = Math.atan2(sinf, cosf);
        euler.setQuaternion2(0.0, ex *= 57.29577951308232, ey *= 57.29577951308232, ez *= 57.29577951308232);
        return euler;
    }

    public String toString() {
        return "[ " + this.name + " w=" + String.valueOf(this.w) + " x=" + String.valueOf(this.x) + " y=" + String.valueOf(this.y) + " z=" + String.valueOf(this.z) + " ]";
    }

    public float[] toFloat() {
        float[] myFloat = new float[]{(float)this.w, (float)this.x, (float)this.y, (float)this.z};
        return myFloat;
    }

    public static void main(String[] ags) {
        Quaternion2 one = new Quaternion2("one");
        Quaternion2 two = new Quaternion2("two", 5.0, 1.0, 2.0, 3.0);
        System.out.println(two);
        float[] f = new float[4];
        f = two.toFloat();
        System.out.println("floats " + f[0] + " " + f[1] + " " + f[2] + " " + f[3]);
        System.out.println(one + "\n" + two);
        two.normalize();
        System.out.println(two);
        System.out.println(one);
        System.out.println(one.add(two));
        Quaternion2 q = new Quaternion2();
        System.out.println(q);
        q = one.multiply(two);
        q.normalize();
        System.out.println(q);
        q = two.rotate(one);
        System.out.println(one + "\n " + two + "\n " + q);
    }
}

