/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.math;

import mil.navy.nps.math.Matrix3f;

public class Vec3f {
    private float[] v = new float[3];

    public Vec3f() {
        this.makeNull();
    }

    public Vec3f(float v0, float v1, float v2) {
        this.set(v0, v1, v2);
    }

    public Vec3f(float[] vec) {
        this.set(vec);
    }

    public Vec3f(Vec3f vec) {
        this.set(vec);
    }

    public void print() {
        System.out.println("v = " + this.v[0] + ", " + this.v[1] + ", " + this.v[2]);
    }

    public void set(float v0, float v1, float v2) {
        this.v[0] = v0;
        this.v[1] = v1;
        this.v[2] = v2;
    }

    public void get(float[] v0, float[] v1, float[] v2) {
        v0[0] = this.v[0];
        v1[0] = this.v[1];
        v2[0] = this.v[2];
    }

    public void set(int index, float val) {
        this.v[index] = val;
    }

    public float get(int index) {
        return this.v[index];
    }

    public void set(float[] vec) {
        this.v[0] = vec[0];
        this.v[1] = vec[1];
        this.v[2] = vec[2];
    }

    public void get(float[] vec) {
        vec[0] = this.v[0];
        vec[1] = this.v[1];
        vec[2] = this.v[2];
    }

    public void set(Vec3f vec) {
        this.v[0] = vec.get(0);
        this.v[1] = vec.get(1);
        this.v[2] = vec.get(2);
    }

    public void get(Vec3f vec) {
        vec.set(0, this.v[0]);
        vec.set(1, this.v[1]);
        vec.set(2, this.v[2]);
    }

    public void makeNull() {
        this.v[0] = 0.0f;
        this.v[1] = 0.0f;
        this.v[2] = 0.0f;
    }

    public void negate() {
        this.v[0] = -this.v[0];
        this.v[1] = -this.v[1];
        this.v[2] = -this.v[2];
    }

    public void negate(Vec3f vec) {
        this.v[0] = -vec.get(0);
        this.v[1] = -vec.get(1);
        this.v[2] = -vec.get(2);
    }

    public void add(Vec3f vec) {
        this.v[0] = this.v[0] + vec.get(0);
        this.v[1] = this.v[1] + vec.get(1);
        this.v[2] = this.v[2] + vec.get(2);
    }

    public void add(Vec3f vec1, Vec3f vec2) {
        this.v[0] = vec1.get(0) + vec2.get(0);
        this.v[1] = vec1.get(1) + vec2.get(1);
        this.v[2] = vec1.get(2) + vec2.get(2);
    }

    public void sub(Vec3f vec) {
        this.v[0] = this.v[0] - vec.get(0);
        this.v[1] = this.v[1] - vec.get(1);
        this.v[2] = this.v[2] - vec.get(2);
    }

    public void sub(Vec3f vec1, Vec3f vec2) {
        this.v[0] = vec1.get(0) - vec2.get(0);
        this.v[1] = vec1.get(1) - vec2.get(1);
        this.v[2] = vec1.get(2) - vec2.get(2);
    }

    public void scale(float s) {
        this.v[0] = s * this.v[0];
        this.v[1] = s * this.v[1];
        this.v[2] = s * this.v[2];
    }

    public void scale(float s, Vec3f vec) {
        this.v[0] = s * vec.get(0);
        this.v[1] = s * vec.get(1);
        this.v[2] = s * vec.get(2);
    }

    public float length() {
        return (float)Math.sqrt(this.v[0] * this.v[0] + this.v[1] * this.v[1] + this.v[2] * this.v[2]);
    }

    public float length_sqr() {
        return this.v[0] * this.v[0] + this.v[1] * this.v[1] + this.v[2] * this.v[2];
    }

    public void normalize() {
        float len_sqr = this.length_sqr();
        float one_over_length = len_sqr > 1.0E-4f ? 1.0f / (float)Math.sqrt(len_sqr) : 0.0f;
        this.v[0] = this.v[0] * one_over_length;
        this.v[1] = this.v[1] * one_over_length;
        this.v[2] = this.v[2] * one_over_length;
    }

    public void normalize(Vec3f vec) {
        float len_sqr = vec.length_sqr();
        float one_over_length = len_sqr > 1.0E-4f ? 1.0f / (float)Math.sqrt(len_sqr) : 0.0f;
        this.v[0] = vec.get(0) * one_over_length;
        this.v[1] = vec.get(1) * one_over_length;
        this.v[2] = vec.get(2) * one_over_length;
    }

    public float dot(Vec3f vec) {
        return this.v[0] * vec.get(0) + this.v[1] * vec.get(1) + this.v[2] * vec.get(2);
    }

    public static float dot(Vec3f vec1, Vec3f vec2) {
        return vec1.get(0) * vec2.get(0) + vec1.get(1) * vec2.get(1) + vec1.get(2) * vec2.get(2);
    }

    public void cross(Vec3f vec) {
        float[] tmp_float = new float[]{this.v[1] * vec.get(2) - this.v[2] * vec.get(1), this.v[2] * vec.get(0) - this.v[0] * vec.get(2), this.v[0] * vec.get(1) - this.v[1] * vec.get(0)};
        this.set(tmp_float);
    }

    public void cross(Vec3f vec1, Vec3f vec2) {
        this.v[0] = vec1.get(1) * vec2.get(2) - vec1.get(2) * vec2.get(1);
        this.v[1] = vec1.get(2) * vec2.get(0) - vec1.get(0) * vec2.get(2);
        this.v[2] = vec1.get(0) * vec2.get(1) - vec1.get(1) * vec2.get(0);
    }

    public void xform(Matrix3f mat) {
        float[] tmp_v = new float[3];
        float[][] m = new float[3][3];
        mat.getMat(m);
        tmp_v[0] = this.v[0] * m[0][0] + this.v[1] * m[0][1] + this.v[2] * m[0][2];
        tmp_v[1] = this.v[0] * m[1][0] + this.v[1] * m[1][1] + this.v[2] * m[1][2];
        tmp_v[2] = this.v[0] * m[2][0] + this.v[1] * m[2][1] + this.v[2] * m[2][2];
        this.set(tmp_v);
    }

    public void xform(Matrix3f mat, Vec3f vec) {
        float[] tmp_v = new float[3];
        float[][] m = new float[3][3];
        vec.get(tmp_v);
        mat.getMat(m);
        this.v[0] = tmp_v[0] * m[0][0] + tmp_v[1] * m[0][1] + tmp_v[2] * m[0][2];
        this.v[1] = tmp_v[0] * m[1][0] + tmp_v[1] * m[1][1] + tmp_v[2] * m[1][2];
        this.v[2] = tmp_v[0] * m[2][0] + tmp_v[1] * m[2][1] + tmp_v[2] * m[2][2];
    }
}

