/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.math;

import mil.navy.nps.math.Matrix4f;

public class Vec4f {
    private float[] v = new float[4];

    public Vec4f() {
        this.makeNull();
    }

    public Vec4f(float v0, float v1, float v2, float v3) {
        this.set(v0, v1, v2, v3);
    }

    public Vec4f(float[] vec) {
        this.set(vec);
    }

    public Vec4f(Vec4f vec) {
        this.set(vec);
    }

    public void print() {
        System.out.println("v = " + this.v[0] + ", " + this.v[1] + ", " + this.v[2] + ", " + this.v[3]);
    }

    public void set(float v0, float v1, float v2, float v3) {
        this.v[0] = v0;
        this.v[1] = v1;
        this.v[2] = v2;
        this.v[3] = v3;
    }

    public void get(float[] v0, float[] v1, float[] v2, float[] v3) {
        v0[0] = this.v[0];
        v1[0] = this.v[1];
        v2[0] = this.v[2];
        v3[0] = this.v[3];
    }

    public void set(int index, float val) {
        if (index < 0 || index > 3) {
            return;
        }
        this.v[index] = val;
    }

    public float get(int index) {
        if (index < 0 || index > 3) {
            return 0.0f;
        }
        return this.v[index];
    }

    public void set(float[] vec) {
        this.v[0] = vec[0];
        this.v[1] = vec[1];
        this.v[2] = vec[2];
        this.v[3] = vec[3];
    }

    public void get(float[] vec) {
        vec[0] = this.v[0];
        vec[1] = this.v[1];
        vec[2] = this.v[2];
        vec[3] = this.v[3];
    }

    public void set(Vec4f vec) {
        this.v[0] = vec.get(0);
        this.v[1] = vec.get(1);
        this.v[2] = vec.get(2);
        this.v[3] = vec.get(3);
    }

    public void get(Vec4f vec) {
        vec.set(this.v[0], this.v[1], this.v[2], this.v[3]);
    }

    public void makeNull() {
        this.v[0] = 0.0f;
        this.v[1] = 0.0f;
        this.v[2] = 0.0f;
    }

    public void negate() {
        this.v[0] = -this.v[0];
        this.v[1] = -this.v[1];
        this.v[2] = -this.v[2];
        this.v[3] = -this.v[3];
    }

    public void negate(Vec4f vec) {
        this.v[0] = -vec.get(0);
        this.v[1] = -vec.get(1);
        this.v[2] = -vec.get(2);
        this.v[3] = -vec.get(3);
    }

    public void add(Vec4f vec) {
        this.v[0] = this.v[0] + vec.get(0);
        this.v[1] = this.v[1] + vec.get(1);
        this.v[2] = this.v[2] + vec.get(2);
        this.v[3] = this.v[3] + vec.get(3);
    }

    public void add(Vec4f vec1, Vec4f vec2) {
        this.v[0] = vec1.get(0) + vec2.get(0);
        this.v[1] = vec1.get(1) + vec2.get(1);
        this.v[2] = vec1.get(2) + vec2.get(2);
        this.v[3] = vec1.get(3) + vec2.get(3);
    }

    public void sub(Vec4f vec) {
        this.v[0] = this.v[0] - vec.get(0);
        this.v[1] = this.v[1] - vec.get(1);
        this.v[2] = this.v[2] - vec.get(2);
        this.v[3] = this.v[3] - vec.get(3);
    }

    public void sub(Vec4f vec1, Vec4f vec2) {
        this.v[0] = vec1.get(0) - vec2.get(0);
        this.v[1] = vec1.get(1) - vec2.get(1);
        this.v[2] = vec1.get(2) - vec2.get(2);
        this.v[3] = vec1.get(3) - vec2.get(3);
    }

    public void scale(float s) {
        this.v[0] = s * this.v[0];
        this.v[1] = s * this.v[1];
        this.v[2] = s * this.v[2];
        this.v[3] = s * this.v[3];
    }

    public void scale(float s, Vec4f vec) {
        this.v[0] = s * vec.get(0);
        this.v[1] = s * vec.get(1);
        this.v[2] = s * vec.get(2);
        this.v[3] = s * vec.get(3);
    }

    public float length() {
        return (float)Math.sqrt(this.v[0] * this.v[0] + this.v[1] * this.v[1] + this.v[2] * this.v[2] + this.v[3] * this.v[3]);
    }

    public float length_sqr() {
        return this.v[0] * this.v[0] + this.v[1] * this.v[1] + this.v[2] * this.v[2] + this.v[3] * this.v[3];
    }

    public void normalize() {
        float len_sqr = this.length_sqr();
        float one_over_length = len_sqr > 1.0E-4f ? 1.0f / (float)Math.sqrt(len_sqr) : 0.0f;
        this.v[0] = this.v[0] * one_over_length;
        this.v[1] = this.v[1] * one_over_length;
        this.v[2] = this.v[2] * one_over_length;
        this.v[3] = this.v[3] * one_over_length;
    }

    public void normalize(Vec4f vec) {
        float len_sqr = vec.length_sqr();
        float one_over_length = len_sqr > 1.0E-4f ? 1.0f / (float)Math.sqrt(len_sqr) : 0.0f;
        this.v[0] = vec.get(0) * one_over_length;
        this.v[1] = vec.get(1) * one_over_length;
        this.v[2] = vec.get(2) * one_over_length;
        this.v[3] = vec.get(3) * one_over_length;
    }

    public float dot(Vec4f vec) {
        return this.v[0] * vec.get(0) + this.v[1] * vec.get(1) + this.v[2] * vec.get(2) + this.v[3] * vec.get(3);
    }

    public static float dot(Vec4f vec1, Vec4f vec2) {
        return vec1.get(0) * vec2.get(0) + vec1.get(1) * vec2.get(1) + vec1.get(2) * vec2.get(2) + vec1.get(3) * vec2.get(3);
    }

    public void xform(Matrix4f mat) {
        float[] tmp_v = new float[4];
        float[][] m = new float[4][4];
        mat.getMat(m);
        tmp_v[0] = this.v[0] * m[0][0] + this.v[1] * m[0][1] + this.v[2] * m[0][2] + this.v[3] * m[0][3];
        tmp_v[1] = this.v[0] * m[1][0] + this.v[1] * m[1][1] + this.v[2] * m[1][2] + this.v[3] * m[1][3];
        tmp_v[2] = this.v[0] * m[2][0] + this.v[1] * m[2][1] + this.v[2] * m[2][2] + this.v[3] * m[2][3];
        tmp_v[3] = this.v[0] * m[3][0] + this.v[1] * m[3][1] + this.v[2] * m[3][2] + this.v[3] * m[3][3];
        this.set(tmp_v);
    }

    public void xform(Matrix4f mat, Vec4f vec) {
        float[] tmp_v = new float[4];
        float[][] m = new float[4][4];
        vec.get(tmp_v);
        mat.getMat(m);
        this.v[0] = tmp_v[0] * m[0][0] + tmp_v[1] * m[0][1] + tmp_v[2] * m[0][2] + tmp_v[3] * m[0][3];
        this.v[1] = tmp_v[0] * m[1][0] + tmp_v[1] * m[1][1] + tmp_v[2] * m[1][2] + tmp_v[3] * m[1][3];
        this.v[2] = tmp_v[0] * m[2][0] + tmp_v[1] * m[2][1] + tmp_v[2] * m[2][2] + tmp_v[3] * m[2][3];
        this.v[3] = tmp_v[0] * m[3][0] + tmp_v[1] * m[3][1] + tmp_v[2] * m[3][2] + tmp_v[3] * m[3][3];
    }
}

