/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.net;

import java.net.InetAddress;
import java.net.MulticastSocket;
import mil.navy.nps.dis.BehaviorConsumerIF;
import mil.navy.nps.dis.BehaviorProducerIF;
import mil.navy.nps.dis.EntityID;
import mil.navy.nps.dis.EntityStatePdu;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.net.BehaviorConsumerThreaded;
import mil.navy.nps.net.BehaviorProducerUDP;

public class NetworkTester
implements BehaviorConsumerIF {
    private static final int PORT = 62040;
    private static final String GROUP = "224.2.181.145";

    public static void main(String[] args) {
        NetworkTester tester = new NetworkTester();
        tester.test();
    }

    public void test() {
        try {
            MulticastSocket socket = new MulticastSocket(62040);
            InetAddress address = InetAddress.getByName(GROUP);
            socket.joinGroup(address);
            BehaviorProducerUDP writer = new BehaviorProducerUDP(socket);
            writer.setDefaultDestination(address, new Integer(62040));
            Thread readThread = new Thread(writer);
            readThread.start();
            BehaviorConsumerThreaded consumer = new BehaviorConsumerThreaded();
            Thread consumerThread = new Thread(consumer);
            consumerThread.start();
            writer.addListener(consumer);
            EntityStatePdu pdu = new EntityStatePdu();
            EntityID id = new EntityID(0, 0, 42);
            pdu.setEntityID(id);
            System.out.println("Waiting for PDU's");
            while (true) {
                Thread.sleep(50L);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
    }

    public void receivePdu(ProtocolDataUnit pdu, BehaviorProducerIF producer) {
        System.out.println("Got PDU in tester");
    }

    public void receivePdu(ProtocolDataUnit pdu, BehaviorProducerIF producer, Object data) {
        this.receivePdu(pdu, producer);
    }
}

