/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mil.navy.nps.util.SerializationInterface;

public class UnsignedByte
extends Number
implements SerializationInterface,
Cloneable {
    public static final short MAX_UNSIGNED_BYTE_VALUE = 255;
    private byte _data;

    public UnsignedByte() {
        this._data = 0;
    }

    public UnsignedByte(byte pData) {
        if (pData < 0) {
            throw new RuntimeException("Exception in UnsignedByte. Attempt to assign value beyond maximum range of an unsigned byte.");
        }
        this._data = pData;
    }

    public UnsignedByte(short pData) {
        if (pData < 0 || pData > 255) {
            throw new RuntimeException("Exception in UnsignedByte. Short value exceeds max value for an unsigned byte.");
        }
        this._data = (byte)pData;
    }

    public UnsignedByte(int pData) {
        if (pData < 0 || pData > 255) {
            throw new RuntimeException("Exception in UnsignedByte. Int value out of range for an unsigned byte.");
        }
        this._data = (byte)pData;
    }

    public double doubleValue() {
        double temp = this._data < 0 ? 255 + this._data + 1 : this._data;
        return temp;
    }

    public float floatValue() {
        float temp = this._data < 0 ? 255 + this._data + 1 : this._data;
        return temp;
    }

    public int intValue() {
        int temp = this._data < 0 ? 255 + this._data + 1 : this._data;
        return temp;
    }

    public long longValue() {
        long temp = this._data < 0 ? 255 + this._data + 1 : this._data;
        return temp;
    }

    public void serialize(DataOutputStream pOutputStream) {
        try {
            pOutputStream.writeByte(this._data);
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in UnsignedByte. Error serializing to stream.");
        }
    }

    public void deSerialize(DataInputStream pInputStream) {
        try {
            this._data = pInputStream.readByte();
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in UnsignedByte. Error deSerializing from stream.");
        }
    }

    public String toString() {
        Integer temp = new Integer(this.intValue());
        return temp.toString();
    }

    public void debugTest() {
        System.out.println("Testing functionality of unsigned byte class");
        UnsignedByte zero = new UnsignedByte(0);
        UnsignedByte one = new UnsignedByte(127);
        UnsignedByte two = new UnsignedByte(128);
        UnsignedByte three = new UnsignedByte(129);
        UnsignedByte four = new UnsignedByte(255);
        System.out.println("Values should be 0, 127, 128, 129, 255:" + zero.toString() + " " + one.toString() + " " + two.toString() + " " + three.toString() + " " + four.toString());
        zero = new UnsignedByte(0);
        one = new UnsignedByte(127);
        two = new UnsignedByte(128);
        three = new UnsignedByte(129);
        four = new UnsignedByte(255);
        System.out.println("Values should be 0, 127, 128, 129, 255:" + zero.toString() + " " + one.toString() + " " + two.toString() + " " + three.toString() + " " + four.toString());
        zero = new UnsignedByte(0);
        one = new UnsignedByte(127);
        two = new UnsignedByte(128);
        three = new UnsignedByte(129);
        four = new UnsignedByte(255);
        System.out.println("Values should be 0, 127, 128, 129, 255:" + zero.toString() + " " + one.toString() + " " + two.toString() + " " + three.toString() + " " + four.toString());
    }

    public Object clone() {
        Object newObject;
        try {
            newObject = super.clone();
        }
        catch (CloneNotSupportedException cloneError) {
            throw new RuntimeException("Exception in UnsignedByte. Error cloning object.");
        }
        return newObject;
    }
}

