/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mil.navy.nps.util.SerializationInterface;

public class UnsignedInt
extends Number
implements SerializationInterface,
Cloneable {
    public static final int MAX_INT_VALUE = Integer.MAX_VALUE;
    public static final long MAX_LONG_VALUE = Long.MAX_VALUE;
    private int _data;

    public UnsignedInt() {
        this._data = 0;
    }

    public UnsignedInt(int pData) {
        if (pData < 0) {
            throw new RuntimeException("Exception in UnsignedInt. Attempt to assign value beyond maximum range of an unsigned int.");
        }
        this._data = pData;
    }

    public UnsignedInt(short pData) {
        if (pData < 0) {
            throw new RuntimeException("Exception in UnsignedInt. Attempt to assign value beyond maximum range of an unsigned int.");
        }
        this._data = pData;
    }

    public UnsignedInt(long pData) {
        if (pData > Integer.MAX_VALUE || pData < 0L) {
            throw new RuntimeException("Exception in UnsignedInt. Attempt to assign value beyond maximum range of an unsigned int.");
        }
        this._data = (int)pData;
    }

    public double doubleValue() {
        double temp = this._data < 0 ? Integer.MAX_VALUE + this._data + 1 : this._data;
        return temp;
    }

    public float floatValue() {
        float temp = this._data < 0 ? Integer.MAX_VALUE + this._data + 1 : this._data;
        return temp;
    }

    public long longValue() {
        long temp = this._data < 0 ? Integer.MAX_VALUE + this._data + 1 : this._data;
        return temp;
    }

    public int intValue() {
        if (this._data < 0) {
            System.err.println("Warning: UnsignedInt above maximum allowed value for int, cast to negative int anyway.");
        }
        return this._data;
    }

    public void serialize(DataOutputStream pOutputStream) {
        try {
            pOutputStream.writeInt(this._data);
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in UnsignedInt. Error writing to file.");
        }
    }

    public void deSerialize(DataInputStream pInputStream) {
        try {
            this._data = pInputStream.readInt();
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in UnsignedInt. Error reading from file.");
        }
    }

    public String toString() {
        Long temp = new Long(this.longValue());
        return temp.toString();
    }

    public Object clone() {
        Object newObject;
        try {
            newObject = super.clone();
        }
        catch (CloneNotSupportedException cloneError) {
            throw new RuntimeException("Exception in UnsignedByte. Error cloning object.");
        }
        return newObject;
    }

    public void debugTest() {
        System.out.println("Testing functionality of unsigned int class");
        UnsignedInt zero = new UnsignedInt(0L);
        UnsignedInt one = new UnsignedInt((long)Integer.MAX_VALUE);
        UnsignedInt two = new UnsignedInt(0x80000000L);
        UnsignedInt three = new UnsignedInt(0x80000001L);
        UnsignedInt four = new UnsignedInt((long)Integer.MAX_VALUE);
        System.out.println("Values should be 0, 2147483647, 2147483648L, 2147483649L, 4294907295L:" + zero.toString() + " " + one.toString() + " " + two.toString() + " " + three.toString() + " " + four.toString());
    }
}

