/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mil.navy.nps.util.SerializationInterface;

public class UnsignedLong
extends Number
implements SerializationInterface,
Cloneable {
    public static final long MAX_UNSIGNEDLONG_VALUE = Long.MAX_VALUE;
    private long _data;

    public UnsignedLong() {
        this._data = 0L;
    }

    public UnsignedLong(byte pData) {
        if (pData < 0) {
            throw new RuntimeException("Exception in UnsignedLong. Attempt to assign value beyond maximum range of an unsigned long.");
        }
        this._data = pData;
    }

    public UnsignedLong(short pData) {
        if (pData < 0) {
            throw new RuntimeException("Exception in UnsignedLong. Attempt to assign value beyond maximum range of an unsigned long.");
        }
        this._data = pData;
    }

    public UnsignedLong(int pData) {
        if (pData < 0) {
            throw new RuntimeException("Exception in UnsignedLong. Attempt to assign value beyond maximum range of an unsigned long.");
        }
        this._data = pData;
    }

    public UnsignedLong(double pData) {
        if (pData < 0.0) {
            throw new RuntimeException("Exception in UnsignedLong. Attempt to assign value beyond maximum range of an unsigned long.");
        }
        this._data = (long)pData;
    }

    public UnsignedLong(float pData) {
        if (pData < 0.0f) {
            throw new RuntimeException("Exception in UnsignedLong. Attempt to assign value beyond maximum range of an unsigned long.");
        }
        this._data = (long)pData;
    }

    public UnsignedLong(long pData) {
        if (pData < 0L) {
            throw new RuntimeException("Exception in UnsignedLong. Attempt to assign value beyond maximum range of an unsigned long.");
        }
        this._data = pData;
    }

    public float floatValue() {
        double temp = this._data < 0L ? Long.MAX_VALUE + this._data + 1L : this._data;
        return (float)temp;
    }

    public double doubleValue() {
        double temp = this._data < 0L ? Long.MAX_VALUE + this._data + 1L : this._data;
        return temp;
    }

    public long longValue() {
        double temp = this._data < 0L ? Long.MAX_VALUE + this._data + 1L : this._data;
        return (long)temp;
    }

    public int intValue() {
        if ((int)this._data < 0 || this._data > Integer.MAX_VALUE) {
            System.err.println("Warning: Unsignedlong above maximum allowed value for int, cast to int anyway.");
        }
        return (int)this._data;
    }

    public void serialize(DataOutputStream pOutputStream) {
        try {
            pOutputStream.writeLong(this._data);
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in UnsignedLong. Error writing to file.");
        }
    }

    public void deSerialize(DataInputStream pInputStream) {
        try {
            this._data = pInputStream.readLong();
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in UnsignedLong. Error reading from file.");
        }
    }

    public String toString() {
        Long temp = new Long(this.longValue());
        return temp.toString();
    }

    public Object clone() {
        Object newObject;
        try {
            newObject = super.clone();
        }
        catch (CloneNotSupportedException cloneError) {
            throw new RuntimeException("Exception in UnsignedByte. Error cloning object.");
        }
        return newObject;
    }

    public static void debugTest() {
        System.out.println("Testing functionality of unsigned long class");
        UnsignedLong zero = new UnsignedLong(0L);
        UnsignedLong one = new UnsignedLong((long)Integer.MAX_VALUE);
        UnsignedLong two = new UnsignedLong(0x80000000L);
        UnsignedLong three = new UnsignedLong(0x80000001L);
        UnsignedLong four = new UnsignedLong(Long.MAX_VALUE);
        System.out.println("Values should be 0, 2147483647, 2147483648L, 2147483649L, 4294907295L:");
        System.out.println("             >>> " + zero.toString() + " " + one.toString() + " " + two.toString() + " " + three.toString() + " " + four.toString());
        System.out.println();
        System.out.println("Causes runtime exception: five = new UnsignedLong(-1);");
        try {
            UnsignedLong five = new UnsignedLong(-1);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.println();
        System.out.println("Causes runtime exception: six = new UnsignedLong((long) MAX_UNSIGNEDLONG_VALUE + 1);");
        try {
            UnsignedLong six = new UnsignedLong(Long.MIN_VALUE);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void main(String[] args) {
        UnsignedLong.debugTest();
    }
}

