/*
 * Decompiled with CFR 0.152.
 */
package mil.navy.nps.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mil.navy.nps.util.SerializationInterface;

public class UnsignedShort
extends Number
implements SerializationInterface,
Cloneable {
    public static final int MAX_SHORT_VALUE = 65535;
    private short _data;

    public UnsignedShort() {
        this._data = 0;
    }

    public UnsignedShort(int pData) {
        if (pData < 0 || pData > 65535) {
            throw new RuntimeException("Exception in UnsignedShort. Attempt to assign value beyond maximum range of an unsigned short, value=" + pData);
        }
        this._data = (short)pData;
    }

    public UnsignedShort(short pData) {
        if (pData < 0) {
            throw new RuntimeException("Exception in UnsignedShort. Attempt to assign value beyond maximum range of an unsigned short.");
        }
        this._data = pData;
    }

    public UnsignedShort(long pData) {
        if (pData > 65535L || pData < 0L) {
            throw new RuntimeException("Exception in UnsignedShort. Attempt to assign value beyond maximum range of an unsigned short.");
        }
        this._data = (short)pData;
    }

    public double doubleValue() {
        double temp = this._data < 0 ? 65535 + this._data + 1 : this._data;
        return temp;
    }

    public float floatValue() {
        float temp = this._data < 0 ? 65535 + this._data + 1 : this._data;
        return temp;
    }

    public long longValue() {
        long temp = this._data < 0 ? 65535 + this._data + 1 : this._data;
        return temp;
    }

    public int intValue() {
        int temp = this._data < 0 ? 65535 + this._data + 1 : this._data;
        return temp;
    }

    public void serialize(DataOutputStream pOutputStream) {
        try {
            pOutputStream.writeShort(this._data);
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in UnsignedShort. Error writing to file.");
        }
    }

    public void deSerialize(DataInputStream pInputStream) {
        try {
            this._data = pInputStream.readShort();
        }
        catch (IOException ioError) {
            throw new RuntimeException("Exception in UnsignedShort. Error reading from file.");
        }
    }

    public String toString() {
        Integer temp = new Integer(this.intValue());
        return temp.toString();
    }

    public Object clone() {
        Object newObject;
        try {
            newObject = super.clone();
        }
        catch (CloneNotSupportedException cloneError) {
            throw new RuntimeException("Exception in UnsignedByte. Error cloning object.");
        }
        return newObject;
    }

    public boolean equals(Object obj) {
        int objValue;
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        int myValue = this.intValue();
        return myValue == (objValue = ((UnsignedShort)obj).intValue());
    }

    public void debugTest() {
        System.out.println("Testing functionality of unsigned short class");
        UnsignedShort zero = new UnsignedShort(0);
        UnsignedShort one = new UnsignedShort(32766);
        UnsignedShort two = new UnsignedShort((int)Short.MAX_VALUE);
        UnsignedShort three = new UnsignedShort(32768);
        UnsignedShort four = new UnsignedShort(65535);
        System.out.println("Values should be 0, 32766, 32767, 32768, 65535:" + zero.toString() + " " + one.toString() + " " + two.toString() + " " + three.toString() + " " + four.toString());
        zero = new UnsignedShort(0);
        one = new UnsignedShort(32766);
        two = new UnsignedShort((int)Short.MAX_VALUE);
        three = new UnsignedShort(32768);
        four = new UnsignedShort(65535);
        System.out.println("Values should be 0, 32766, 32767, 32768, 65535:" + zero.toString() + " " + one.toString() + " " + two.toString() + " " + three.toString() + " " + four.toString());
        zero = new UnsignedShort(0);
        one = new UnsignedShort(32766);
        two = new UnsignedShort((int)Short.MAX_VALUE);
        three = new UnsignedShort(32768);
        four = new UnsignedShort(65535);
        System.out.println("Values should be 0, 32766, 32767, 32768, 65535:" + zero.toString() + " " + one.toString() + " " + two.toString() + " " + three.toString() + " " + four.toString());
    }
}

