/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.mavs;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.mavs.WaypointUtils;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(name="QGroundControl interface")
public class QGCExporter
extends ConsolePanel {
    private static final long serialVersionUID = 1L;

    public QGCExporter(ConsoleLayout console) {
        super(console);
    }

    public void initSubPanel() {
        this.addMenuItem("Tools>QGC>Export Waypoint List", ImageUtils.getIcon((String)PluginUtils.getPluginIcon(((Object)((Object)this)).getClass())), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PlanType plan = QGCExporter.this.getConsole().getPlan();
                    if (plan == null) {
                        throw new Exception("Please choose a main plan first");
                    }
                    String wptList = WaypointUtils.getAsQGCFormat(plan);
                    JFileChooser fchooser = new JFileChooser();
                    fchooser.setAcceptAllFileFilterUsed(true);
                    fchooser.setMultiSelectionEnabled(false);
                    int option = fchooser.showSaveDialog((Component)QGCExporter.this.getConsole());
                    if (option != 0) {
                        return;
                    }
                    File f = fchooser.getSelectedFile();
                    FileUtil.saveToFile((String)f.getAbsolutePath(), (String)wptList);
                    GuiUtils.infoMessage((Component)QGCExporter.this.getConsole(), (String)"Export Waypoint List", (String)("Waypoint list successfully exported to '" + f.getName() + "'"));
                }
                catch (Exception ex) {
                    GuiUtils.errorMessage((Component)QGCExporter.this.getConsole(), (Exception)ex);
                }
            }
        });
    }

    public void cleanSubPanel() {
    }
}

