/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.mavs;

import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.maneuvers.Goto;
import pt.lsts.neptus.mp.maneuvers.Loiter;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class WaypointUtils {
    public static String getWPLWaypoint(int index, int curwpt, Goto man) {
        double[] lld = man.getManeuverLocation().getAbsoluteLatLonDepth();
        return index + "\t" + curwpt + "\t16\t0\t0\t0\t0\t" + lld[0] + "\t" + lld[1] + "\t" + -lld[2] + "1";
    }

    public static String getWPLWaypoint(int index, int curwpt, Loiter man) {
        double[] lld = man.getLocation().getAbsoluteLatLonDepth();
        if (man.getLoiterType().equals("Circular")) {
            return index + "\t" + curwpt + "\t19\t" + man.getMaxTime() + "\t0\t" + man.getRadius() + "\t" + man.getBearing() + "\t" + lld[0] + "\t" + lld[1] + "\t" + -lld[2] + "1";
        }
        if (man.getLoiterType().equals("Hover")) {
            return index + "\t" + curwpt + "\t18\t" + man.getMaxTime() + "\t0\t0\t0\t" + lld[0] + "\t" + lld[1] + "\t" + -lld[2] + "1";
        }
        return null;
    }

    public static String getAsQGCFormat(PlanType plan) throws Exception {
        String ret = "QGC WPL 110\n";
        int index = 0;
        int first = 1;
        for (Maneuver man : plan.getGraph().getManeuversSequence()) {
            String line = null;
            if (man instanceof Goto) {
                line = WaypointUtils.getWPLWaypoint(index, first, (Goto)man);
            }
            if (man instanceof Loiter) {
                line = WaypointUtils.getWPLWaypoint(index, first, (Loiter)man);
            }
            if (line != null) {
                first = 0;
                ++index;
            } else {
                throw new Exception("Error converting maneuver '" + man.getId() + "' (" + man.getClass().getSimpleName() + ")");
            }
            ret = ret + line + "\n";
        }
        return ret;
    }
}

