/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.teleoperation;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Graphics2D;
import pt.lsts.imc.DesiredHeading;
import pt.lsts.imc.DesiredZ;
import pt.lsts.imc.EstimatedState;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.util.MathMiscUtils;

@PluginDescription(name="ROV Information Layer", icon="pt/lsts/neptus/plugins/position/position.png", description="ROV Information Layer", category=PluginDescription.CATEGORY.INTERFACE)
@LayerPriority(priority=70)
public class ROVInfoLayer
extends ConsolePanel
implements Renderer2DPainter {
    private static final long serialVersionUID = 4624519156694623532L;
    private double desiredDepth = 0.0;
    private double desiredHeading = 0.0;
    private double depth = 0.0;
    private double heading = 0.0;
    private double altitude = 0.0;

    public ROVInfoLayer(ConsoleLayout console) {
        super(console);
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        System.out.println();
        g.setColor(Color.BLACK);
        g.translate(0, renderer.getHeight() - 100);
        g.drawString("Desired Heading: " + this.desiredHeading, 10, 0);
        g.drawString("Heading: " + this.heading, 10, 10);
        g.drawString("Desired Depth: " + this.desiredDepth, 10, 20);
        g.drawString("Depth: " + this.depth, 10, 30);
        g.drawString("Altitude: " + this.altitude, 10, 40);
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }

    @Subscribe
    public void onMessage(EstimatedState state) {
        if (state.getSourceName().equals(this.getMainVehicleId())) {
            this.depth = MathMiscUtils.round((double)state.getDepth(), (int)3);
            this.heading = MathMiscUtils.round((double)state.getPsi(), (int)3);
            this.altitude = MathMiscUtils.round((double)state.getAlt(), (int)3);
        }
    }

    @Subscribe
    public void onMessage(DesiredZ dz) {
        if (dz.getSourceName().equals(this.getMainVehicleId())) {
            this.desiredDepth = MathMiscUtils.round((double)dz.getValue(), (int)3);
        }
    }

    @Subscribe
    public void onMessage(DesiredHeading dh) {
        if (dh.getSourceName().equals(this.getMainVehicleId())) {
            this.desiredHeading = MathMiscUtils.round((double)dh.getValue(), (int)3);
        }
    }
}

