/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.teleoperation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.teleoperation.ISliderPanelListener;
import pt.lsts.neptus.plugins.teleoperation.SliderPanel;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(name="Servo Control")
public class ServoControlPanel
extends ConsolePanel
implements ConfigurationListener,
ISliderPanelListener {
    private static final long serialVersionUID = 1L;
    @NeptusProperty(name="Servo id")
    public int servoId = 0;
    @NeptusProperty(name="Minimum Value (degrees)")
    public double minVal = -45.0;
    @NeptusProperty(name="Mean Value (degrees)")
    public double meanVal = 0.0;
    @NeptusProperty(name="Maximum Value (degrees)")
    public double maxVal = 45.0;
    @NeptusProperty(name="Title")
    public String title = "title";
    protected SliderPanel slider = new SliderPanel();
    IMCMessage msg = null;

    public ServoControlPanel(ConsoleLayout console) {
        super(console);
        this.setLayout(new BorderLayout());
        this.add(this.slider);
        ToolbarButton tbutton = new ToolbarButton(ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/teleoperation/settings.png"), "Settings", "settings");
        this.add((Component)tbutton, "East");
        tbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServoControlPanel.this.showSettingPanel();
            }
        });
        ToolbarButton cbutton = new ToolbarButton(ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/teleoperation/start.png"), "Center", "center");
        cbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServoControlPanel.this.slider.setValue(ServoControlPanel.this.meanVal);
                ServoControlPanel.this.slider.repaint();
            }
        });
        this.add((Component)cbutton, "West");
        this.propertiesChanged();
        this.slider.setValue(this.meanVal);
        this.slider.addSliderListener(this);
    }

    protected void showSettingPanel() {
        final JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor((Component)((Object)this)));
        final SliderPanel min = new SliderPanel();
        final SliderPanel max = new SliderPanel();
        final SliderPanel mean = new SliderPanel();
        final JTextField text = new JTextField("" + this.servoId);
        JPanel panel = new JPanel(new GridLayout(5, 1));
        JPanel tmp1 = new JPanel(new BorderLayout());
        tmp1.add((Component)new JLabel("Servo ID:"), "West");
        tmp1.add(text);
        panel.add(tmp1);
        min.setMin(-180.0);
        max.setMin(-180.0);
        min.setMax(180.0);
        max.setMax(180.0);
        mean.setMin(-180.0);
        mean.setMax(180.0);
        min.setTitle("min");
        max.setTitle("max");
        mean.setTitle("zero");
        min.setValue(this.minVal);
        max.setValue(this.maxVal);
        mean.setValue(this.meanVal);
        min.addSliderListener(this);
        max.addSliderListener(this);
        mean.addSliderListener(this);
        panel.add(min);
        panel.add(mean);
        panel.add(max);
        JPanel controls = new JPanel(new FlowLayout(2, 2, 2));
        JButton ok = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        ok.setPreferredSize(new Dimension(80, 24));
        cancel.setPreferredSize(new Dimension(80, 24));
        controls.add(ok);
        controls.add(cancel);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ServoControlPanel.this.servoId = Integer.parseInt(text.getText());
                    if (ServoControlPanel.this.servoId < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception ex) {
                    GuiUtils.errorMessage((Component)dialog, (String)"Servo Control Settings", (String)"Servo ID must be a positive integer");
                    ex.printStackTrace();
                    return;
                }
                ServoControlPanel.this.minVal = min.getValue();
                ServoControlPanel.this.maxVal = max.getValue();
                ServoControlPanel.this.meanVal = mean.getValue();
                dialog.dispose();
                ServoControlPanel.this.getConsole().setConsoleChanged(true);
                ServoControlPanel.this.propertiesChanged();
            }
        });
        panel.add(controls);
        dialog.setContentPane(panel);
        dialog.setTitle("Servo control settings");
        dialog.setModal(true);
        dialog.setSize(450, 180);
        dialog.setVisible(true);
    }

    public void propertiesChanged() {
        this.slider.setMin(this.minVal);
        this.slider.setMax(this.maxVal);
        this.slider.setMean(this.meanVal);
        this.slider.setTitle(this.title);
        this.slider.repaint();
    }

    @Override
    public void SliderChanged(SliderPanel source) {
        if (this.msg == null) {
            this.msg = IMCDefinition.getInstance().create("SetServoPosition", new Object[0]);
        }
        this.msg.setValue("id", (Object)this.servoId);
        this.msg.setValue("value", (Object)Math.toRadians(source.getValue()));
        this.send(this.msg);
    }

    public static void main(String[] args) {
        GuiUtils.testFrame((JComponent)((Object)new ServoControlPanel(null)));
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }
}

