/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.teleoperation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JPanel;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.GuiUtils;

public class SimpleOrientationGauge
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected double angleRads = 0.0;
    protected double distance = 100.0;
    private NumberFormat nf = GuiUtils.getNeptusDecimalFormat((int)1);

    public double getAngleRads() {
        return this.angleRads;
    }

    public void setAngleRads(double angleRads) {
        this.angleRads = angleRads;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    @Override
    public void paint(Graphics g) {
        double diameter = this.getWidth() - 6;
        if (this.getHeight() - 16 < this.getWidth() - 6) {
            diameter = this.getHeight() - 16;
        }
        Graphics2D g2 = (Graphics2D)g;
        g.setColor(Color.white);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.fill(new Ellipse2D.Double(3.0, 3.0, diameter, diameter));
        g.setColor(Color.black);
        g2.draw(new Ellipse2D.Double(3.0, 3.0, diameter, diameter));
        g.setColor(Color.black);
        String text = this.nf.format(this.distance) + "m";
        double width = g2.getFontMetrics(g2.getFont()).getStringBounds(text, g2).getWidth();
        NeptusLog.pub().info((Object)("<###> " + width));
        g2.drawString(this.nf.format(this.distance) + "m", (int)((double)(this.getWidth() / 2) - width / 2.0), this.getHeight() - 10);
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0, 0.9);
        gp.lineTo(0.5, -0.5);
        gp.lineTo(-0.5, -0.5);
        gp.closePath();
        g2.translate(diameter / 2.0 + 3.0, diameter / 2.0 + 3.0);
        g2.scale(diameter * 0.2, -diameter * 0.2);
        g2.rotate(this.angleRads);
        g2.draw(gp);
        g2.scale(1.0 / (diameter * 0.2), 1.0 / (diameter * 0.2));
        g2.setColor(Color.gray);
        g2.fillOval(-4, -4, 8, 8);
    }

    public static void main(String[] args) {
        SimpleOrientationGauge gauge = new SimpleOrientationGauge();
        GuiUtils.testFrame((JComponent)gauge);
        gauge.angleRads = Math.toRadians(45.0);
    }
}

