/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.teleoperation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.InterpolationColorMap;
import pt.lsts.neptus.util.GuiUtils;

public class SimpleTurnGauge
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected double value = 0.0;
    protected ColorMap colormap = ColorMapFactory.createInvertedColorMap((InterpolationColorMap)((InterpolationColorMap)ColorMapFactory.createRedYellowGreenColorMap()));
    protected double ballRadius = 7.0;

    public SimpleTurnGauge() {
        this.setBackground(Color.white);
        this.setMinimumSize(new Dimension(25, 25));
        this.setPreferredSize(new Dimension(25, 25));
    }

    public ColorMap getColormap() {
        return this.colormap;
    }

    public void setColormap(ColorMap colormap) {
        this.colormap = colormap;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Color c = this.colormap.getColor(Math.abs(this.value));
        Graphics2D g2 = (Graphics2D)g;
        double xCenter = (double)(this.getWidth() / 2) + ((double)(this.getWidth() / 2) - this.ballRadius) * this.value;
        g2.setColor(c);
        Ellipse2D.Double ellis = new Ellipse2D.Double(xCenter - this.ballRadius, (double)(this.getHeight() / 2) - this.ballRadius, this.ballRadius * 2.0, this.ballRadius * 2.0);
        g2.fill(ellis);
        g2.setColor(Color.black);
        g2.draw(ellis);
    }

    public static void main(String[] args) throws Exception {
        SimpleTurnGauge gauge = new SimpleTurnGauge();
        GuiUtils.testFrame((JComponent)gauge);
        for (double i = -1.0; i < 1.0; i += 0.01) {
            gauge.setValue(i);
            gauge.repaint();
            Thread.sleep(50L);
        }
    }
}

