/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.teleoperation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.InterpolationColorMap;
import pt.lsts.neptus.util.GuiUtils;

public class SimpleVerticalGauge
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected double value = 0.0;
    protected ColorMap colormap = ColorMapFactory.createInvertedColorMap((InterpolationColorMap)((InterpolationColorMap)ColorMapFactory.createRedYellowGreenColorMap()));
    protected Color bright = new Color(255, 255, 255, 100);
    protected Color dark = new Color(0, 0, 0, 100);

    public SimpleVerticalGauge() {
        this.setMinimumSize(new Dimension(25, 25));
        this.setPreferredSize(new Dimension(25, 25));
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public ColorMap getColormap() {
        return this.colormap;
    }

    public void setColormap(ColorMap colormap) {
        this.colormap = colormap;
    }

    @Override
    public void paint(Graphics g) {
        Color c = this.colormap.getColor(this.value);
        ((Graphics2D)g).setPaint(new GradientPaint(0.0f, 0.0f, c.brighter(), this.getWidth(), 0.0f, c.darker()));
        int height = (int)(this.value * (double)this.getHeight());
        g.fillRect(1, this.getHeight() - height, this.getWidth() - 1, this.getHeight());
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g.setColor(new Color(0, 0, 0, 128));
        g.drawLine(1, this.getHeight() - height, this.getWidth() - 2, this.getHeight() - height);
    }

    public static void main(String[] args) {
        SimpleVerticalGauge gauge = new SimpleVerticalGauge();
        gauge.setValue(0.56);
        GuiUtils.testFrame((JComponent)gauge);
    }
}

