/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.teleoperation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pt.lsts.neptus.plugins.teleoperation.ISliderPanelListener;
import pt.lsts.neptus.util.GuiUtils;

public class SliderPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected int margin = 3;
    protected int rectWidth = 20;
    protected double sliderPosition = 0.5;
    protected double min = -1.0;
    protected double max = 1.0;
    protected double mean = 0.0;
    protected NumberFormat nf = GuiUtils.getNeptusDecimalFormat((int)1);
    protected JLabel valText = new JLabel("");
    protected JLabel title = new JLabel();
    protected Vector<ISliderPanelListener> listeners = new Vector();
    protected boolean hasFocus = false;

    public SliderPanel() {
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.setLayout(new GridLayout(1, 3));
        this.valText.setHorizontalAlignment(0);
        this.title.setHorizontalAlignment(0);
        this.title.setForeground(Color.blue.darker());
        this.valText.setText("tsd");
        this.add(this.title);
        this.add(this.valText);
        this.add(new JLabel(""));
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                super.mouseDragged(e);
                double val = (double)e.getX() / (double)SliderPanel.this.getWidth();
                SliderPanel.this.sliderPosition = Math.min(1.0, Math.max(0.0, val));
                for (ISliderPanelListener l : SliderPanel.this.listeners) {
                    l.SliderChanged(SliderPanel.this);
                }
                SliderPanel.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                double val = (double)e.getX() / (double)SliderPanel.this.getWidth();
                SliderPanel.this.sliderPosition = Math.min(1.0, Math.max(0.0, val));
                for (ISliderPanelListener l : SliderPanel.this.listeners) {
                    l.SliderChanged(SliderPanel.this);
                }
                SliderPanel.this.repaint();
                SliderPanel.this.requestFocusInWindow();
            }
        });
        this.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                SliderPanel.this.hasFocus = false;
                SliderPanel.this.repaint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                SliderPanel.this.hasFocus = true;
                SliderPanel.this.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                double step = (SliderPanel.this.max - SliderPanel.this.min) / 100.0;
                double val = SliderPanel.this.getValue();
                switch (e.getKeyCode()) {
                    case 38: 
                    case 40: {
                        SliderPanel.this.setValue(SliderPanel.this.mean);
                        SliderPanel.this.repaint();
                        break;
                    }
                    case 37: {
                        val -= step;
                        if (val < SliderPanel.this.min) {
                            val = SliderPanel.this.min;
                        }
                        SliderPanel.this.setValue(val);
                        SliderPanel.this.repaint();
                        break;
                    }
                    case 39: {
                        val += step;
                        if (val > SliderPanel.this.max) {
                            val = SliderPanel.this.max;
                        }
                        SliderPanel.this.setValue(val);
                        SliderPanel.this.repaint();
                    }
                }
            }
        });
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    @Override
    public void paint(Graphics arg0) {
        this.valText.setText(this.nf.format((this.max - this.min) * this.sliderPosition + this.min));
        super.paint(arg0);
        Graphics2D g = (Graphics2D)arg0;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.gray);
        double pos = (this.mean - this.min) / (this.max - this.min) * (double)(this.getWidth() - this.margin * 2) + (double)this.margin;
        g.draw(new Line2D.Double(pos, 2.0, pos, this.getHeight() - 2));
        if (this.hasFocus) {
            g.setColor(new Color(100, 175, 200, 200));
        } else {
            g.setColor(new Color(180, 180, 180, 150));
        }
        double usableWidth = this.getWidth() - this.margin * 2 - this.rectWidth;
        double rectX = this.sliderPosition * usableWidth + (double)this.margin;
        g.fill(new RoundRectangle2D.Double(rectX, this.margin, 20.0, this.getHeight() - this.margin * 2, 6.0, 6.0));
        g.setColor(Color.black);
        g.draw(new RoundRectangle2D.Double(rectX, this.margin, 20.0, this.getHeight() - this.margin * 2, 6.0, 6.0));
    }

    public double getSliderPosition() {
        return this.sliderPosition;
    }

    public void setSliderPosition(double sliderPosition) {
        this.sliderPosition = sliderPosition;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setValue(double value) {
        value = Math.min(value, this.max);
        value = Math.max(value, this.min);
        this.sliderPosition = (value - this.min) / (this.max - this.min);
        for (ISliderPanelListener l : this.listeners) {
            l.SliderChanged(this);
        }
    }

    public double getValue() {
        return (this.max - this.min) * this.sliderPosition + this.min;
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public void addSliderListener(ISliderPanelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeSliderListener(ISliderPanelListener listener) {
        this.listeners.remove(listener);
    }

    public static void main(String[] args) {
        JPanel testPanel = new JPanel();
        testPanel.setLayout(new GridLayout(3, 1));
        SliderPanel min = new SliderPanel();
        SliderPanel max = new SliderPanel();
        SliderPanel mean = new SliderPanel();
        min.setTitle("min");
        max.setTitle("max");
        mean.setTitle("mean");
        testPanel.add(min);
        testPanel.add(mean);
        testPanel.add(max);
        GuiUtils.testFrame((JComponent)testPanel);
    }
}

