/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.teleoperation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.InterpolationColorMap;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.teleoperation.SimpleOrientationGauge;
import pt.lsts.neptus.plugins.teleoperation.SimpleTurnGauge;
import pt.lsts.neptus.plugins.teleoperation.SimpleVerticalGauge;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;

public class TeleoperationPanel
extends ConsolePanel
implements IPeriodicUpdates {
    private static final long serialVersionUID = 1L;
    ColorMap normal = ColorMapFactory.createRedYellowGreenColorMap();
    ColorMap inverted = ColorMapFactory.createInvertedColorMap((InterpolationColorMap)((InterpolationColorMap)this.normal));
    protected SimpleTurnGauge turnGauge = new SimpleTurnGauge();
    protected SimpleVerticalGauge motorLeft = new SimpleVerticalGauge();
    protected SimpleVerticalGauge motorRight = new SimpleVerticalGauge();
    protected SimpleOrientationGauge orientation = new SimpleOrientationGauge();
    protected LocationType destination = null;

    public TeleoperationPanel(ConsoleLayout console) {
        super(console);
        this.setLayout(new BorderLayout());
        this.add(this.motorLeft, "West");
        this.add(this.motorRight, "East");
        this.add(this.turnGauge, "South");
        this.add(this.orientation, "Center");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JPopupMenu popup = new JPopupMenu();
                popup.add("Head to copied location").addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                        if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            try {
                                String text = (String)contents.getTransferData(DataFlavor.stringFlavor);
                                LocationType lt = new LocationType();
                                lt.fromClipboardText(text);
                                TeleoperationPanel.this.destination = new LocationType(lt);
                            }
                            catch (Exception ex) {
                                NeptusLog.pub().error((Object)ex);
                            }
                        }
                    }
                });
                popup.show((Component)((Object)TeleoperationPanel.this), e.getX(), e.getY());
            }
        });
    }

    public long millisBetweenUpdates() {
        return 100L;
    }

    public boolean update() {
        return false;
    }

    public static void main(String[] args) {
        GuiUtils.testFrame((JComponent)((Object)new TeleoperationPanel(null)));
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }
}

