/*
 * Decompiled with CFR 0.152.
 */
package aw.gui.chart;

import aw.gui.chart.ITrace2D;
import aw.gui.chart.TracePoint2D;

public abstract class AbstractDataCollector
implements Runnable {
    private boolean stop = false;
    private long latency = 400L;
    private ITrace2D trace;

    public AbstractDataCollector(ITrace2D trace, int latency) {
        this.latency = latency;
        this.trace = trace;
    }

    public void run() {
        while (!this.stop) {
            long lasttime = System.currentTimeMillis();
            this.trace.addPoint(this.collectData());
            try {
                Thread.sleep(Math.max(this.latency - System.currentTimeMillis() + lasttime, 0L));
            }
            catch (InterruptedException e) {
                this.stop = true;
            }
            if (!Thread.interrupted()) continue;
            this.stop = true;
        }
        this.stop = false;
    }

    public void stop() {
        this.stop = true;
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.stop();
    }

    public abstract TracePoint2D collectData();

    public ITrace2D getTrace() {
        return this.trace;
    }

    public long getLatency() {
        return this.latency;
    }

    public void setLatency(long latency) {
        this.latency = latency;
    }
}

