/*
 * Decompiled with CFR 0.152.
 */
package aw.gui.chart;

import aw.gui.chart.ITrace2D;
import aw.gui.chart.TracePoint2D;
import aw.util.Range;
import aw.util.units.Unit;
import aw.util.units.UnitFactory;
import aw.util.units.UnitSystemSI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Chart2D
extends JPanel
implements ITrace2D.Trace2DListener {
    static final int OFFSETS_DEBUG = 1;
    static final int MINMAX_DEBUG = 2;
    static final int TRACEPAINT_DEBUG = 4;
    static final int GRIDPAINT_DEBUG = 8;
    static final int LABELPAINT_DEBUG = 16;
    static final int COLORPAINT_DEBUG = 32;
    static final int SCALING_DEBUG = 64;
    static final int EVENT_DEBUG = 128;
    static final int MATH_DEBUG = 256;
    static final int SYNC_DEBUG = 512;
    static final int ALL_DEBUG = 1023;
    static final int EVENT_DEBUG_HARD = 755;
    static final int DEBUG_LEVEL = 0;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int X_Y = 3;
    protected List traces = new LinkedList();
    protected Map labels = new HashMap();
    protected Unit unitY;
    protected Unit unitX = this.unitY = UnitFactory.getInstance().getUnit(1.0, UnitSystemSI.getInstance());
    protected Color gridcolor = Color.lightGray;
    protected int decimalsX = 1;
    protected int decimalsY = 1;
    protected boolean gridX = false;
    protected boolean gridY = false;
    protected boolean scaleX = true;
    protected boolean scaleY = true;
    protected boolean labeling = true;
    protected double xmax;
    protected double xmin;
    protected double ymax;
    protected double ymin;
    protected double xmaxold;
    protected double xminold;
    protected double ymaxold;
    protected double yminold;
    public static Range NO_RANGE_FORCED = new Range(0.0, 0.0);
    protected Range forceXRange = NO_RANGE_FORCED;
    protected Range forceYRange = NO_RANGE_FORCED;
    protected Painter painter = new Painter();
    protected List pendingChanges = new LinkedList();

    public Chart2D() {
        Font dflt = this.getFont();
        if (dflt != null) {
            this.setFont(new Font(dflt.getFontName(), dflt.getStyle(), 10));
        }
        this.setBackground(Color.white);
        this.painter.start();
    }

    public synchronized void paint(Graphics g) {
        int i;
        int tmp;
        super.paint(g);
        this.updateScaling();
        Dimension d = this.getSize();
        int width = (int)d.getWidth();
        int height = (int)d.getHeight();
        FontMetrics fontdim = g.getFontMetrics();
        int fontwidth = fontdim.charWidth('9');
        int fontheight = fontdim.getHeight();
        int rootx = (this.decimalsY + 5) * fontwidth;
        int labelheight = 0;
        if (this.labeling) {
            int remwidth;
            Collection entries = this.labels.values();
            Iterator it = entries.iterator();
            int xtmpos = rootx;
            int ytmpos = height - 2;
            int allwidth = remwidth = width - rootx;
            int lblwidth = 0;
            boolean crlfdone = false;
            if (it.hasNext()) {
                labelheight += fontheight;
            }
            while (it.hasNext()) {
                ColoredLabel current = (ColoredLabel)it.next();
                String tmplabel = current.label;
                lblwidth = tmplabel.length() * fontwidth;
                if (lblwidth > remwidth) {
                    if (lblwidth <= allwidth || !crlfdone) {
                        ytmpos -= fontheight;
                        xtmpos = rootx;
                        labelheight += fontheight;
                        crlfdone = true;
                        remwidth = width - rootx;
                    } else {
                        crlfdone = false;
                    }
                }
                remwidth -= lblwidth;
                g.setColor(current.color);
                g.drawString(tmplabel, xtmpos, ytmpos);
                xtmpos += lblwidth;
            }
        }
        int rooty = height - fontheight - labelheight;
        int endx = width - 20;
        int endy = 20;
        int rangex = endx - rootx;
        int rangey = rooty - endy;
        g.setColor(Color.black);
        g.drawLine(rootx, rooty, endx, rooty);
        g.drawLine(rootx, rooty, rootx, endy);
        if (this.scaleX) {
            tmp = 0;
            LabeledValue[] labels = this.getScaleValuesX(this.getScaleDistanceX((this.decimalsX + 4) * fontwidth));
            for (i = 0; i < labels.length; ++i) {
                tmp = rootx + (int)(labels[i].getValue() * (double)rangex);
                g.drawLine(tmp, rooty, tmp, rooty + 5);
                g.drawString(labels[i].getLabel(), tmp, rooty + fontheight);
                if (!this.gridX || i == 0 && tmp == rootx) continue;
                g.setColor(this.gridcolor);
                g.drawLine(tmp, rooty - 1, tmp, endy);
                g.setColor(Color.black);
            }
            g.drawString(this.unitX.getLabel(), endx - 20, rooty - 5);
        }
        if (this.scaleY) {
            LabeledValue[] labels = this.getScaleValuesY(this.getScaleDistanceY(fontheight));
            for (i = 0; i < labels.length; ++i) {
                tmp = rooty - (int)(labels[i].getValue() * (double)rangey);
                g.drawLine(rootx, tmp, rootx - 5, tmp);
                g.drawString(labels[i].getLabel(), 2, tmp);
                if (!this.gridY || i == 0 && tmp == rooty) continue;
                g.setColor(this.gridcolor);
                g.drawLine(rootx + 1, tmp, endx, tmp);
                g.setColor(Color.black);
            }
            g.drawString(this.unitY.getLabel(), rootx, endy - 5);
        }
        int stop = this.traces.size();
        Iterator it = null;
        for (int i2 = 0; i2 < stop; ++i2) {
            ITrace2D tmpdata = (ITrace2D)this.traces.get(i2);
            Color acolor = tmpdata.getColor();
            g.setColor(tmpdata.getColor());
            it = tmpdata.iterator();
            if (!it.hasNext()) continue;
            TracePoint2D tmppt = (TracePoint2D)it.next();
            int oldtmpx = rootx + (int)(tmppt.scaledX * (double)rangex);
            int oldtmpy = rooty - (int)((double)rangey * tmppt.scaledY);
            while (it.hasNext()) {
                tmppt = (TracePoint2D)it.next();
                int tmpx = rootx + (int)(tmppt.scaledX * (double)rangex);
                int tmpy = rooty - (int)(tmppt.scaledY * (double)rangey);
                g.drawLine(oldtmpx, oldtmpy, tmpx, tmpy);
                oldtmpx = tmpx;
                oldtmpy = tmpy;
            }
        }
    }

    public final synchronized void addTrace(ITrace2D points) {
        points.setRenderer(this);
        this.traces.add(points);
        points.addChangeListener(this);
        String name = points.getName();
        String physunit = points.getPhysicalUnits();
        if (name != "" && physunit != "") {
            name = name + " " + physunit;
        } else if (physunit != "") {
            name = "unnamed" + " " + physunit;
        }
        if (name.length() != 0) {
            ColoredLabel label = new ColoredLabel(name, points.getColor());
            this.labels.put(points, label);
        }
        this.traceChanged(new ITrace2D.Trace2DChangeEvent(points, ITrace2D.ALL_POINTS_CHANGED));
    }

    public final synchronized void removeTrace(ITrace2D points) {
        this.traces.remove(points);
        this.labels.remove(points);
        this.adjustRangeX();
        this.adjustRangeY();
        this.scaleAll(3);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Chart2D.this.repaint();
            }
        });
    }

    public final List getTraces() {
        return this.traces;
    }

    private final void adjustRangeX() {
        this.getMaxX();
        this.getMinX();
        if (this.xmaxold != this.xmax || this.xminold != this.xmin) {
            this.chooseUnitX();
        }
        if (this.xmin == this.xmax) {
            this.xmin -= this.unitX.factor;
        }
    }

    private final void adjustRangeY() {
        this.getMaxY();
        this.getMinY();
        if (this.ymaxold != this.ymax || this.yminold != this.ymin) {
            this.chooseUnitY();
        }
        if (this.ymin == this.ymax) {
            this.ymin -= this.unitY.factor;
        }
    }

    public Range getForceXRange() {
        return this.forceXRange;
    }

    public void setForceXRange(Range forceXRange) {
        this.forceXRange = forceXRange;
    }

    public Range getForceYRange() {
        return this.forceYRange;
    }

    public void setForceYRange(Range forceYRange) {
        this.forceYRange = forceYRange;
    }

    public double getOffsetX() {
        return this.xmin;
    }

    public final double getOffsetY() {
        return this.ymin;
    }

    protected final void getMaxX() {
        double max = -1.7976931348623157E308;
        Iterator it = this.traces.iterator();
        while (it.hasNext()) {
            double tmp = ((ITrace2D)it.next()).getMaxX();
            if (!(tmp > max)) continue;
            max = tmp;
        }
        if (max == -1.7976931348623157E308) {
            max = 10.0;
        }
        this.xmaxold = this.xmax;
        if (this.forceXRange != NO_RANGE_FORCED) {
            max = Math.max(this.forceXRange.getMax(), max);
        }
        this.xmax = max;
    }

    protected final void getMinX() {
        double min = Double.MAX_VALUE;
        Iterator it = this.traces.iterator();
        while (it.hasNext()) {
            double tmp = ((ITrace2D)it.next()).getMinX();
            if (!(tmp < min)) continue;
            min = tmp;
        }
        if (min == Double.MAX_VALUE) {
            min = 0.0;
        }
        this.xminold = this.xmin;
        if (this.forceXRange != NO_RANGE_FORCED) {
            min = Math.min(this.forceXRange.getMin(), min);
        }
        this.xmin = min;
    }

    protected final void getMaxY() {
        double max = -1.7976931348623157E308;
        for (int i = this.traces.size() - 1; i >= 0; --i) {
            double tmp = ((ITrace2D)this.traces.get(i)).getMaxY();
            if (!(tmp > max)) continue;
            max = tmp;
        }
        if (max == -1.7976931348623157E308) {
            max = 10.0;
        }
        this.ymaxold = this.ymax;
        if (this.forceYRange != NO_RANGE_FORCED) {
            max = Math.max(this.forceYRange.getMax(), max);
        }
        this.ymax = max;
    }

    protected final void getMinY() {
        double min = Double.MAX_VALUE;
        for (int i = this.traces.size() - 1; i >= 0; --i) {
            double tmp = ((ITrace2D)this.traces.get(i)).getMinY();
            if (!(tmp < min)) continue;
            min = tmp;
        }
        if (min == Double.MAX_VALUE) {
            min = 0.0;
        }
        this.yminold = this.ymin;
        if (this.forceYRange != NO_RANGE_FORCED) {
            min = Math.min(this.forceYRange.getMin(), min);
        }
        this.ymin = min;
    }

    protected final void chooseUnitX() {
        double max = Math.max(Math.abs(this.xmax), Math.abs(this.xmin));
        if (max == 0.0) {
            max = 1.0;
        }
        this.unitX = UnitFactory.getInstance().getUnit(max, UnitSystemSI.getInstance());
    }

    protected final void chooseUnitY() {
        double max = Math.max(Math.abs(this.ymax), Math.abs(this.ymin));
        if (max == 0.0) {
            max = 1.0;
        }
        this.unitY = UnitFactory.getInstance().getUnit(max, UnitSystemSI.getInstance());
    }

    public final double getScaledValueX(double absoluteX) {
        double scalerX = this.xmax - this.xmin;
        return (absoluteX - this.xmin) / scalerX;
    }

    public final double getScaledValueY(double absoluteY) {
        double scalerY = this.ymax - this.ymin;
        return (absoluteY - this.ymin) / scalerY;
    }

    public final String getLabelAbsoluteX(double absolute) {
        if (this.unitX == null) {
            this.chooseUnitX();
        }
        return this.unitX.getLabel(absolute);
    }

    public final String getLabelAbsoluteY(double absolute) {
        if (this.unitY == null) {
            this.chooseUnitY();
        }
        return this.unitY.getLabel(absolute);
    }

    public final double getScaleDistanceX(int pixel) {
        Dimension d = this.getSize();
        int pxrangex = (int)d.getWidth() - 60;
        if (pxrangex <= 0) {
            return -1.0;
        }
        double valuerangex = this.xmax - this.xmin;
        double px_to_value = valuerangex / (double)pxrangex;
        double ret = px_to_value * (double)pixel;
        return ret;
    }

    public final double getScaleDistanceY(int pixel) {
        Dimension d = this.getSize();
        int pxrangey = (int)d.getHeight() - 40;
        if (pxrangey <= 0) {
            return -1.0;
        }
        double valuerangey = this.ymax - this.ymin;
        double px_to_value = valuerangey / (double)pxrangey;
        double ret = px_to_value * (double)pixel;
        return ret;
    }

    private final LabeledValue[] getScaleValuesX(double resolution) {
        double add;
        if (resolution <= 0.0) {
            return new LabeledValue[0];
        }
        LinkedList<LabeledValue> collect = new LinkedList<LabeledValue>();
        double rangex = this.xmax - this.xmin;
        for (add = 1.0 / this.unitX.factor; add < resolution; add *= 10.0) {
        }
        double roundlabel = 0.0;
        for (double tmp = this.round(Math.abs(this.xmin) / this.unitX.factor, this.decimalsX, false) * this.unitX.factor - Math.abs(this.xmin); tmp <= rangex; tmp += add) {
            roundlabel = this.round((tmp + this.xmin) / this.unitX.factor, this.decimalsX, false);
            String tmplabel = String.valueOf(roundlabel);
            collect.add(new LabeledValue(tmp / rangex, tmplabel));
        }
        int stop = collect.size();
        LabeledValue[] ret = new LabeledValue[stop];
        for (int i = 0; i < stop; ++i) {
            ret[i] = (LabeledValue)collect.get(i);
        }
        return ret;
    }

    private final LabeledValue[] getScaleValuesY(double resolution) {
        double add;
        if (resolution <= 0.0) {
            return new LabeledValue[0];
        }
        LinkedList<LabeledValue> collect = new LinkedList<LabeledValue>();
        double rangey = this.ymax - this.ymin;
        for (add = 1.0 / this.unitY.factor; add < resolution; add *= 10.0) {
        }
        double roundlabel = 0.0;
        for (double tmp = this.round(Math.abs(this.ymin) / this.unitY.factor, this.decimalsY, false) * this.unitY.factor - Math.abs(this.ymin); tmp <= rangey; tmp += add) {
            roundlabel = this.round((tmp + this.ymin) / this.unitY.factor, this.decimalsY, false);
            String tmplabel = String.valueOf(roundlabel);
            collect.add(new LabeledValue(tmp / rangey, tmplabel));
        }
        int stop = collect.size();
        LabeledValue[] ret = new LabeledValue[stop];
        for (int i = 0; i < stop; ++i) {
            ret[i] = (LabeledValue)collect.get(i);
        }
        return ret;
    }

    private synchronized void updateScaling() {
        this.adjustRangeX();
        this.adjustRangeY();
        while (!this.pendingChanges.isEmpty()) {
            ITrace2D.Trace2DChangeEvent event = (ITrace2D.Trace2DChangeEvent)this.pendingChanges.remove(0);
            TracePoint2D changed = event.getPoint();
            ITrace2D trace = (ITrace2D)event.getSource();
            double scalerX = this.xmax - this.xmin;
            double scalerY = this.ymax - this.ymin;
            double xnew = (changed.getX() - this.xmin) / scalerX;
            double ynew = (changed.getY() - this.ymin) / scalerY;
            if (ynew == Double.NaN) {
                xnew = 0.0;
            }
            if (ynew == Double.NaN) {
                ynew = 0.0;
            }
            changed.scaledX = xnew;
            changed.scaledY = ynew;
            changed.scaledOnce = true;
        }
        boolean x = false;
        boolean y = false;
        if (this.xmaxold != this.xmax || this.xminold != this.xmin) {
            x = true;
        }
        if (this.ymaxold != this.ymax || this.yminold != this.ymin) {
            y = true;
        }
        if (x || y) {
            if (x && y) {
                this.scaleAll(3);
            } else if (y) {
                this.scaleAll(1);
            } else {
                this.scaleAll(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scaleTrace(ITrace2D trace, int axis) {
        LinkedList scaled = new LinkedList();
        double scalerX = this.xmax - this.xmin;
        double scalerY = this.ymax - this.ymin;
        Chart2D chart2D = this;
        synchronized (chart2D) {
            Iterator it = trace.iterator();
            if (axis == 3) {
                while (it.hasNext()) {
                    TracePoint2D tmp = (TracePoint2D)it.next();
                    double tmpx = (tmp.getX() - this.xmin) / scalerX;
                    double tmpy = (tmp.getY() - this.ymin) / scalerY;
                    if (tmpx == Double.NaN) {
                        tmpx = 0.0;
                    }
                    if (tmpy == Double.NaN) {
                        tmpy = 0.0;
                    }
                    tmp.scaledX = tmpx;
                    tmp.scaledY = tmpy;
                }
            } else if (axis == 0) {
                while (it.hasNext()) {
                    TracePoint2D tmp = (TracePoint2D)it.next();
                    double tmpx = (tmp.getX() - this.xmin) / scalerX;
                    if (tmpx == Double.NaN) {
                        tmpx = 0.0;
                    }
                    tmp.scaledX = tmpx;
                }
            } else if (axis == 1) {
                while (it.hasNext()) {
                    TracePoint2D tmp = (TracePoint2D)it.next();
                    double tmpy = (tmp.getY() - this.ymin) / scalerY;
                    if (tmpy == Double.NaN) {
                        tmpy = 0.0;
                    }
                    tmp.scaledY = tmpy;
                }
            }
        }
    }

    protected final void scaleAll(int axis) {
        for (int i = this.traces.size() - 1; i >= 0; --i) {
            this.scaleTrace((ITrace2D)this.traces.get(i), axis);
        }
    }

    public final double round(double value, int decimals, boolean floor) {
        double tmp = Math.pow(10.0, decimals);
        double toround = value * tmp;
        toround = floor ? Math.floor(toround + 0.5) : Math.ceil(toround + 0.5);
        return toround /= tmp;
    }

    public final void setDecimalsX(int decimals) {
        this.decimalsX = decimals;
    }

    public final void setDecimalsY(int decimals) {
        this.decimalsY = decimals;
    }

    public final void setGridX(boolean gridx) {
        this.gridX = gridx;
        if (gridx) {
            this.setScaleX(true);
        }
    }

    public final void setGridY(boolean gridy) {
        this.gridY = gridy;
        if (gridy) {
            this.setScaleY(true);
        }
    }

    public final void setScaleX(boolean show) {
        this.scaleX = show;
    }

    public final void setScaleY(boolean show) {
        this.scaleY = show;
    }

    public final void setGridColor(Color gridclr) {
        if (gridclr != null) {
            this.gridcolor = gridclr;
        }
    }

    public final Color getGridColor() {
        return this.gridcolor;
    }

    public synchronized void traceChanged(ITrace2D.Trace2DChangeEvent e) {
        this.pendingChanges.add(e);
    }

    public BufferedImage snapShot() {
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics g = img.getGraphics();
        this.paint(g);
        return img;
    }

    class Painter
    extends Thread {
        long MAX_SLEEP = 1000L;
        long MIN_SLEEP;
        private long sleepTime = this.MIN_SLEEP = 10L;

        Painter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    Painter.sleep(this.sleepTime);
                    Chart2D chart2D = Chart2D.this;
                    synchronized (chart2D) {
                        int pendingSize = Chart2D.this.pendingChanges.size();
                        if (pendingSize == 0) {
                            if (this.sleepTime < this.MAX_SLEEP) {
                                this.sleepTime += 10L;
                            }
                        } else {
                            this.sleepTime = Math.max(this.sleepTime - (long)(pendingSize * 10), this.MIN_SLEEP);
                        }
                    }
                    Chart2D.this.repaint();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class ColoredLabel {
        private String label;
        private Color color;

        private ColoredLabel(String label, Color color) {
            this.label = label;
            this.color = color;
        }
    }

    public class LabeledValue {
        String label;
        double value;

        LabeledValue(double value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public double getValue() {
            return this.value;
        }

        public String toString() {
            return this.label + " : " + this.value;
        }
    }
}

