/*
 * Decompiled with CFR 0.152.
 */
package aw.gui.chart;

import aw.gui.chart.Chart2D;
import aw.gui.chart.ITrace2D;
import aw.gui.chart.TracePoint2D;
import aw.util.Range;
import java.awt.Color;
import java.util.Iterator;

public class Trace2DDebugger
implements ITrace2D {
    ITrace2D delegate;
    Range xRange = new Range(-1.7976931348623157E308, Double.MAX_VALUE);
    Range yRange = new Range(-1.7976931348623157E308, Double.MAX_VALUE);

    public Trace2DDebugger(ITrace2D debug) {
        if (debug == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.delegate = debug;
    }

    public Range getXRange() {
        return this.xRange;
    }

    public void setXRange(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.xRange = range;
    }

    public Range getYRange() {
        return this.yRange;
    }

    public void setYRange(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.yRange = range;
    }

    public void addChangeListener(ITrace2D.Trace2DListener x) {
        this.delegate.addChangeListener(x);
    }

    public void addPoint(double x, double y) {
        TracePoint2D p = new TracePoint2D(this, x, y);
        this.addPoint(p);
    }

    public void addPoint(TracePoint2D p) {
        double x = p.getX();
        double y = p.getY();
        if (!this.xRange.isContained(x)) {
            throw new IllegalArgumentException(p.toString() + " is not within the valid x-range " + this.xRange.toString());
        }
        if (!this.yRange.isContained(y)) {
            throw new IllegalArgumentException(p.toString() + " is not within the valid x-range " + this.xRange.toString());
        }
        System.out.println(p);
        this.delegate.addPoint(p);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public void fireTraceChanged(TracePoint2D changed) {
        this.delegate.fireTraceChanged(changed);
    }

    public Color getColor() {
        return this.delegate.getColor();
    }

    public String getLabel() {
        return this.delegate.getLabel();
    }

    public int getMaxSize() {
        return this.delegate.getMaxSize();
    }

    public double getMaxX() {
        return this.delegate.getMaxX();
    }

    public double getMaxY() {
        return this.delegate.getMaxY();
    }

    public double getMinX() {
        return this.delegate.getMinX();
    }

    public double getMinY() {
        return this.delegate.getMinY();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getPhysicalUnits() {
        return this.delegate.getPhysicalUnits();
    }

    public Chart2D getRenderer() {
        return this.delegate.getRenderer();
    }

    public int getSize() {
        return this.delegate.getSize();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Iterator iterator() {
        return this.delegate.iterator();
    }

    public void pointChanged(TracePoint2D d) {
        this.delegate.pointChanged(d);
    }

    public void removeChangeListener(ITrace2D.Trace2DListener x) {
        this.delegate.removeChangeListener(x);
    }

    public void setColor(Color color) {
        this.delegate.setColor(color);
    }

    public void setLabel(String label) {
        this.delegate.setLabel(label);
    }

    public void setName(String s) {
        this.delegate.setName(s);
    }

    public void setPhysicalUnits(String xunit, String yunit) {
        this.delegate.setPhysicalUnits(xunit, yunit);
    }

    public void setRenderer(Chart2D renderer) {
        this.delegate.setRenderer(renderer);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

